/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.gid.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.ResultReceiver;
import com.taptap.sdk.gid.internal.GidStorage;
import com.taptap.sdk.gid.internal.util.TapOpenlogHelper;
import com.taptap.sdk.kit.internal.TapLogger;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00042\u001e\b\u0002\u0010\t\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\u0006\u0018\u00010\nj\u0004\u0018\u0001`\fJ4\u0010\r\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0018\u0010\t\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\u00060\nj\u0002`\fH\u0002J\u0010\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0010H\u0002J@\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00102\u001e\b\u0002\u0010\t\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\u0006\u0018\u00010\nj\u0004\u0018\u0001`\fH\u0002J@\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00102\u001e\b\u0002\u0010\t\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\u0006\u0018\u00010\nj\u0004\u0018\u0001`\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/taptap/sdk/gid/internal/TapGidLocalFetcher;", "", "()V", "regionType", "", "fetchGidInLocalStorage", "", "context", "Landroid/content/Context;", "callback", "Lkotlin/Function1;", "", "Lcom/taptap/sdk/gid/GetId;", "fetchTapService", "pkg", "getPkgNameWithRegionType", "", "startTapPackageGidFetch", "packageNames", "tapPackageGidFetch", "Companion", "TapPackage", "tap-gid_release"})
public final class TapGidLocalFetcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int regionType;
    @NotNull
    public static final String TAG = "TapGidServiceFetcher";

    public final void fetchGidInLocalStorage(@NotNull Context context, int regionType, @Nullable Function1<? super String, Unit> callback) {
        block3: {
            String tapGid;
            block1: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    this.regionType = regionType;
                    tapGid = GidStorage.INSTANCE.getSpGid(context);
                    TapOpenlogHelper.INSTANCE.reportTechnicalLog("fetched_sp_gid", MapsKt.mapOf((Pair)TuplesKt.to((Object)"tapGid", (Object)tapGid)));
                    TapLogger.logd((String)TAG, (String)("Fetched sp gid, tapGid = " + tapGid));
                    CharSequence charSequence = tapGid;
                    if (charSequence == null || charSequence.length() == 0) {
                        tapGid = GidStorage.INSTANCE.getSDCardGid(context);
                        TapOpenlogHelper.INSTANCE.reportTechnicalLog("fetched_sdcard_gid", MapsKt.mapOf((Pair)TuplesKt.to((Object)"tapGid", (Object)tapGid)));
                        TapLogger.logd((String)TAG, (String)("Fetched sdcard gid, tapGid = " + tapGid));
                    }
                    if (!((charSequence = (CharSequence)tapGid) == null || charSequence.length() == 0)) break block1;
                    List<String> tapPackages = this.getPkgNameWithRegionType();
                    if (tapPackages != null && tapPackages.contains(context.getPackageName())) break block2;
                    TapOpenlogHelper.INSTANCE.reportTechnicalLog("fetch_tap_remote_service_gid_start", MapsKt.mapOf((Pair)TuplesKt.to((Object)"packageName", (Object)context.getPackageName())));
                    TapLogger.logd((String)TAG, (String)"Fetch tap remote service gid start");
                    this.startTapPackageGidFetch(context, this.getPkgNameWithRegionType(), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(callback){
                        final /* synthetic */ Function1<String, Unit> $callback;
                        {
                            this.$callback = $callback;
                            super(1);
                        }

                        public final void invoke(@Nullable String gid) {
                            block0: {
                                TapOpenlogHelper.INSTANCE.reportTechnicalLog("fetched_remote_gid", MapsKt.mapOf((Pair)TuplesKt.to((Object)"tapGid", (Object)gid)));
                                TapLogger.logd((String)"TapGidServiceFetcher", (String)("Fetched remote gid, tapGid = " + gid));
                                Function1<String, Unit> function1 = this.$callback;
                                if (function1 == null) break block0;
                                function1.invoke((Object)gid);
                            }
                        }
                    }));
                    break block3;
                }
                Function1<? super String, Unit> function1 = callback;
                if (function1 == null) break block3;
                function1.invoke((Object)tapGid);
                break block3;
            }
            Function1<? super String, Unit> function1 = callback;
            if (function1 == null) break block3;
            function1.invoke((Object)tapGid);
        }
    }

    public static /* synthetic */ void fetchGidInLocalStorage$default(TapGidLocalFetcher tapGidLocalFetcher, Context context, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 4) != 0) {
            function1 = null;
        }
        tapGidLocalFetcher.fetchGidInLocalStorage(context, n, (Function1<? super String, Unit>)function1);
    }

    private final void startTapPackageGidFetch(Context context, List<String> packageNames, Function1<? super String, Unit> callback) {
        Collection collection = packageNames;
        if (collection == null || collection.isEmpty()) {
            Function1<? super String, Unit> function1 = callback;
            if (function1 != null) {
                function1.invoke(null);
            }
            return;
        }
        this.tapPackageGidFetch(context, packageNames, callback);
    }

    static /* synthetic */ void startTapPackageGidFetch$default(TapGidLocalFetcher tapGidLocalFetcher, Context context, List list, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = null;
        }
        tapGidLocalFetcher.startTapPackageGidFetch(context, list, (Function1<? super String, Unit>)function1);
    }

    private final void tapPackageGidFetch(Context context, List<String> packageNames, Function1<? super String, Unit> callback) {
        block2: {
            block1: {
                Collection collection = packageNames;
                if (collection == null || collection.isEmpty()) break block1;
                List<String> list = packageNames;
                Intrinsics.checkNotNull(list);
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String pkg = (String)element$iv;
                    boolean bl = false;
                    this.fetchTapService(context, pkg, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(callback){
                        final /* synthetic */ Function1<String, Unit> $callback;
                        {
                            this.$callback = $callback;
                            super(1);
                        }

                        public final void invoke(@Nullable String gid) {
                            block1: {
                                CharSequence charSequence = gid;
                                if (charSequence == null || charSequence.length() == 0) break block1;
                                Function1<String, Unit> function1 = this.$callback;
                                if (function1 != null) {
                                    function1.invoke((Object)gid);
                                }
                            }
                        }
                    }));
                }
                break block2;
            }
            Function1<? super String, Unit> function1 = callback;
            if (function1 == null) break block2;
            function1.invoke(null);
        }
    }

    static /* synthetic */ void tapPackageGidFetch$default(TapGidLocalFetcher tapGidLocalFetcher, Context context, List list, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = null;
        }
        tapGidLocalFetcher.tapPackageGidFetch(context, list, (Function1<? super String, Unit>)function1);
    }

    /*
     * WARNING - void declaration
     */
    private final void fetchTapService(Context context, String pkg, Function1<? super String, Unit> callback) {
        block3: {
            Object object;
            Object object2;
            if (context == null) {
                callback.invoke(null);
                return;
            }
            TapOpenlogHelper.INSTANCE.reportTechnicalLog("fetch_tap_remote_service", MapsKt.mapOf((Pair)TuplesKt.to((Object)"pkg", (Object)pkg)));
            TapLogger.logd((String)TAG, (String)("Fetch tap remote service, pkg = " + pkg));
            try {
                void $this$fetchTapService_u24lambda_u243_u24lambda_u242_u24lambda_u241;
                boolean bl = false;
                Intent $this$fetchTapService_u24lambda_u243_u24lambda_u242 = object2 = new Intent();
                boolean bl2 = false;
                Handler handler = new Handler(Looper.getMainLooper());
                $this$fetchTapService_u24lambda_u243_u24lambda_u242.putExtra("receiver", (Parcelable)TapGidLocalFetcher.Companion.receiverForSending(new ResultReceiver(callback, handler){
                    final /* synthetic */ Function1<String, Unit> $callback;
                    {
                        this.$callback = $callback;
                        super($super_call_param$1);
                    }

                    protected void onReceiveResult(int resultCode, @NotNull Bundle resultData) {
                        Intrinsics.checkNotNullParameter((Object)resultData, (String)"resultData");
                        super.onReceiveResult(resultCode, resultData);
                        try {
                            if (resultData.containsKey("unified_gid_result_param")) {
                                String gid = resultData.getString("unified_gid_result_param");
                                TapOpenlogHelper.INSTANCE.reportTechnicalLog("get_gid_success", MapsKt.mapOf((Pair)TuplesKt.to((Object)"gid", (Object)gid)));
                                TapLogger.logd((String)"TapGidServiceFetcher", (String)("get gid success: " + gid));
                                this.$callback.invoke((Object)gid);
                            } else {
                                TapOpenlogHelper.INSTANCE.reportTechnicalLog("on_receive_result", MapsKt.mapOf((Pair)TuplesKt.to((Object)"msg", (Object)"didn't contain unified_id_result_param")));
                                TapLogger.logd((String)"TapGidServiceFetcher", (String)"onReceiveResult: didn't contain unified_id_result_param");
                                this.$callback.invoke(null);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }));
                Handler handler2 = handler = new Bundle();
                Intent intent2 = $this$fetchTapService_u24lambda_u243_u24lambda_u242;
                boolean bl3 = false;
                $this$fetchTapService_u24lambda_u243_u24lambda_u242_u24lambda_u241.putString("cmd", "getUnifiedGid");
                intent2.putExtras((Bundle)handler);
                $this$fetchTapService_u24lambda_u243_u24lambda_u242.setComponent(new ComponentName(pkg, "com.taptap.sdk.gid.service.TapGidIntentService"));
                Object intent3 = object2;
                object = Result.constructor-impl((Object)(Build.VERSION.SDK_INT >= 26 ? context.startForegroundService(intent3) : context.startService(intent3)));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block3;
            Object it = object2 = throwable;
            boolean bl = false;
            callback.invoke(null);
        }
    }

    private final List<String> getPkgNameWithRegionType() {
        List list;
        switch (this.regionType) {
            case 0: {
                list = CollectionsKt.listOf((Object)TapPackage.TAP_CN.getPackageName());
                break;
            }
            case 1: {
                Object[] objectArray = new String[]{TapPackage.TAP_IO.getPackageName(), TapPackage.TAP_IO_LITE.getPackageName()};
                list = CollectionsKt.listOf((Object[])objectArray);
                break;
            }
            default: {
                list = null;
            }
        }
        return list;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/taptap/sdk/gid/internal/TapGidLocalFetcher$TapPackage;", "", "packageName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getPackageName", "()Ljava/lang/String;", "TAP_CN", "TAP_IO", "TAP_IO_LITE", "tap-gid_release"})
    private static final class TapPackage
    extends Enum<TapPackage> {
        @NotNull
        private final String packageName;
        public static final /* enum */ TapPackage TAP_CN = new TapPackage("com.taptap");
        public static final /* enum */ TapPackage TAP_IO = new TapPackage("com.taptap.global");
        public static final /* enum */ TapPackage TAP_IO_LITE = new TapPackage("com.taptap.global.lite");
        private static final /* synthetic */ TapPackage[] $VALUES;

        private TapPackage(String packageName) {
            this.packageName = packageName;
        }

        @NotNull
        public final String getPackageName() {
            return this.packageName;
        }

        public static TapPackage[] values() {
            return (TapPackage[])$VALUES.clone();
        }

        public static TapPackage valueOf(String value) {
            return Enum.valueOf(TapPackage.class, value);
        }

        static {
            $VALUES = tapPackageArray = new TapPackage[]{TapPackage.TAP_CN, TapPackage.TAP_IO, TapPackage.TAP_IO_LITE};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/taptap/sdk/gid/internal/TapGidLocalFetcher$Companion;", "", "()V", "TAG", "", "receiverForSending", "Landroid/os/ResultReceiver;", "actualReceiver", "tap-gid_release"})
    public static final class Companion {
        private Companion() {
        }

        private final ResultReceiver receiverForSending(ResultReceiver actualReceiver) {
            Parcel parcel = Parcel.obtain();
            Intrinsics.checkNotNullExpressionValue((Object)parcel, (String)"obtain()");
            Parcel parcel2 = parcel;
            actualReceiver.writeToParcel(parcel2, 0);
            parcel2.setDataPosition(0);
            ResultReceiver receiverForSending = (ResultReceiver)ResultReceiver.CREATOR.createFromParcel(parcel2);
            parcel2.recycle();
            Intrinsics.checkNotNullExpressionValue((Object)receiverForSending, (String)"receiverForSending");
            return receiverForSending;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

