/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.gid.internal;

import android.content.Context;
import android.content.SharedPreferences;
import com.taptap.sdk.kit.internal.TapLogger;
import com.taptap.sdk.kit.internal.utils.KVUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/taptap/sdk/gid/internal/TapGidStorage;", "", "()V", "TAP_DEVICE_ID_SAVED_PARAM", "", "TAP_GID_SHARE_PREFERENCE", "TAP_GID_SP_CACHE_CN", "TAP_GID_SP_CACHE_GLOBAL", "clearDeprecatedSpGid", "", "context", "Landroid/content/Context;", "getDeprecatedSpGid", "getGidFromSp", "regionType", "", "saveGidToSp", "gid", "tap-gid_release"})
public final class TapGidStorage {
    @NotNull
    public static final TapGidStorage INSTANCE = new TapGidStorage();
    @NotNull
    private static final String TAP_GID_SHARE_PREFERENCE = "tap_gid_share_preference";
    @NotNull
    private static final String TAP_DEVICE_ID_SAVED_PARAM = "taptap_device_id_saved_param";
    @NotNull
    private static final String TAP_GID_SP_CACHE_CN = "taptap_gid_cn_cache";
    @NotNull
    private static final String TAP_GID_SP_CACHE_GLOBAL = "taptap_gid_global_cache";

    private TapGidStorage() {
    }

    public final void saveGidToSp(int regionType, @NotNull String gid) {
        Intrinsics.checkNotNullParameter((Object)gid, (String)"gid");
        try {
            switch (regionType) {
                case 0: {
                    KVUtil.putString$default((KVUtil)KVUtil.INSTANCE, (String)TAP_GID_SP_CACHE_CN, (String)gid, null, (int)4, null);
                    break;
                }
                case 1: {
                    KVUtil.putString$default((KVUtil)KVUtil.INSTANCE, (String)TAP_GID_SP_CACHE_GLOBAL, (String)gid, null, (int)4, null);
                }
            }
        }
        catch (Exception e) {
            TapLogger.loge$default((String)"TapGidStorage", null, (Throwable)e, (int)2, null);
        }
    }

    @Nullable
    public final String getGidFromSp(int regionType) {
        CharSequence charSequence;
        String gidCache = "";
        try {
            switch (regionType) {
                case 0: {
                    gidCache = KVUtil.getString$default((KVUtil)KVUtil.INSTANCE, (String)TAP_GID_SP_CACHE_CN, (String)"", null, (int)4, null);
                    break;
                }
                case 1: {
                    gidCache = KVUtil.getString$default((KVUtil)KVUtil.INSTANCE, (String)TAP_GID_SP_CACHE_GLOBAL, (String)"", null, (int)4, null);
                }
            }
        }
        catch (Exception e) {
            TapLogger.loge$default((String)"TapGidStorage", null, (Throwable)e, (int)2, null);
        }
        CharSequence charSequence2 = gidCache;
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = null;
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    public final void clearDeprecatedSpGid(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            SharedPreferences sp = context.getSharedPreferences(TAP_GID_SHARE_PREFERENCE, 0);
            SharedPreferences.Editor editor = sp.edit();
            editor.remove(TAP_DEVICE_ID_SAVED_PARAM);
            editor.apply();
        }
        catch (Exception e) {
            TapLogger.loge$default((String)"TapGidStorage", null, (Throwable)e, (int)2, null);
        }
    }

    @Nullable
    public final String getDeprecatedSpGid(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences sp = context.getSharedPreferences(TAP_GID_SHARE_PREFERENCE, 0);
        String gid = sp.getString(TAP_DEVICE_ID_SAVED_PARAM, null);
        return gid;
    }
}

