/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.gid.service.disk;

import android.content.Context;
import android.content.SharedPreferences;
import com.taptap.sdk.gid.service.GidService;
import com.taptap.sdk.gid.service.disk.cn.TapCNGidDiskService;
import com.taptap.sdk.gid.service.disk.decorator.CompatGidDiskService;
import com.taptap.sdk.gid.service.disk.intl.TapINTLGidDiskService;
import com.taptap.sdk.gid.service.disk.legacy.LegacyTapGidDiskService;
import com.taptap.sdk.initializer.api.model.RegionType;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/taptap/sdk/gid/service/disk/GidDiskServiceFactory;", "", "()V", "create", "Lcom/taptap/sdk/gid/service/GidService;", "context", "Landroid/content/Context;", "region", "Lcom/taptap/sdk/initializer/api/model/RegionType;", "useMigration", "", "tap-gid_release"})
public final class GidDiskServiceFactory {
    @NotNull
    public static final GidDiskServiceFactory INSTANCE = new GidDiskServiceFactory();

    private GidDiskServiceFactory() {
    }

    @NotNull
    public final GidService create(@NotNull Context context, @NotNull RegionType region, boolean useMigration) {
        GidService gidService;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)region, (String)"region");
        switch (WhenMappings.$EnumSwitchMapping$0[region.ordinal()]) {
            case 1: {
                SharedPreferences sharedPreferences = context.getSharedPreferences("tap_sdk_sp", 0);
                Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026ATE\n                    )");
                gidService = new TapCNGidDiskService(sharedPreferences);
                break;
            }
            case 2: {
                SharedPreferences sharedPreferences = context.getSharedPreferences("tap_sdk_sp", 0);
                Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026ATE\n                    )");
                gidService = new TapINTLGidDiskService(sharedPreferences);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        GidService regionService = gidService;
        if (!useMigration) {
            return regionService;
        }
        SharedPreferences sharedPreferences = context.getSharedPreferences("tap_gid_share_preference", 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026ODE_PRIVATE\n            )");
        LegacyTapGidDiskService legacyService = new LegacyTapGidDiskService(sharedPreferences);
        return new CompatGidDiskService(regionService, legacyService);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RegionType.values().length];
            try {
                nArray[RegionType.CN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RegionType.GLOBAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

