/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.gid.service.disk.decorator;

import android.util.Log;
import com.taptap.sdk.gid.service.GidService;
import com.taptap.sdk.gid.service.disk.decorator.GidDiskServiceDecorator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/taptap/sdk/gid/service/disk/decorator/GidMigrationDecorator;", "Lcom/taptap/sdk/gid/service/disk/decorator/GidDiskServiceDecorator;", "newStorageService", "Lcom/taptap/sdk/gid/service/GidService;", "legacyStorageService", "clearLegacyAfterMigration", "", "(Lcom/taptap/sdk/gid/service/GidService;Lcom/taptap/sdk/gid/service/GidService;Z)V", "value", "", "gid", "getGid", "()Ljava/lang/String;", "setGid", "(Ljava/lang/String;)V", "Companion", "tap-gid_release"})
public final class GidMigrationDecorator
extends GidDiskServiceDecorator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GidService legacyStorageService;
    private final boolean clearLegacyAfterMigration;
    @NotNull
    private static final String TAG = "GidMigration";

    public GidMigrationDecorator(@NotNull GidService newStorageService, @NotNull GidService legacyStorageService, boolean clearLegacyAfterMigration) {
        Intrinsics.checkNotNullParameter((Object)newStorageService, (String)"newStorageService");
        Intrinsics.checkNotNullParameter((Object)legacyStorageService, (String)"legacyStorageService");
        super(newStorageService);
        this.legacyStorageService = legacyStorageService;
        this.clearLegacyAfterMigration = clearLegacyAfterMigration;
    }

    @Override
    @NotNull
    public String getGid() {
        String legacyGid;
        String newGid = this.getWrapped().getGid();
        if (((CharSequence)newGid).length() == 0 && ((CharSequence)(legacyGid = this.legacyStorageService.getGid())).length() > 0) {
            Log.d((String)TAG, (String)"Migrating GID from legacy storage");
            this.getWrapped().setGid(legacyGid);
            if (this.clearLegacyAfterMigration) {
                Log.d((String)TAG, (String)"Clearing legacy storage after migration");
                this.legacyStorageService.setGid("");
            }
            return legacyGid;
        }
        return newGid;
    }

    @Override
    public void setGid(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.getWrapped().setGid(value);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/taptap/sdk/gid/service/disk/decorator/GidMigrationDecorator$Companion;", "", "()V", "TAG", "", "tap-gid_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

