/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.gid;

import android.util.Log;
import com.taptap.sdk.common.network.NetworkClientKt;
import com.taptap.sdk.gid.data.response.Gid;
import com.taptap.sdk.gid.repository.GidRepository;
import com.taptap.sdk.gid.service.disk.GidDiskServiceFactory;
import com.taptap.sdk.gid.service.network.DefaultGidNetworkService;
import com.taptap.sdk.gid.service.network.GidApiService;
import com.taptap.sdk.initializer.api.model.RegionType;
import com.taptap.sdk.initializer.api.option.TapTapSdkOptions;
import com.taptap.sdk.kit.internal.TapTapKit;
import com.taptap.sdk.retrofit2.Retrofit;
import com.taptap.sdk.themis.lite.ThemisLiteManager;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u0000 *2\u00020\u0001:\u0004()*+B\u000f\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B)\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0011\u0010\u0015\u001a\u00020\u0012H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0011\u0010\u0019\u001a\u00020\u0014H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\u0006\u0010\u001a\u001a\u00020\u0000J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0012H\u0002J\u0012\u0010\u001d\u001a\u00020\u00182\b\u0010\u001e\u001a\u0004\u0018\u00010\u0014H\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\tJ\b\u0010%\u001a\u00020\u0018H\u0002J\b\u0010&\u001a\u00020\u0018H\u0002J\u000e\u0010'\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\tR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006,"}, d2={"Lcom/taptap/sdk/gid/TapSdkGid;", "", "builder", "Lcom/taptap/sdk/gid/TapSdkGid$Builder;", "(Lcom/taptap/sdk/gid/TapSdkGid$Builder;)V", "options", "Lcom/taptap/sdk/initializer/api/option/TapTapSdkOptions;", "gidCallbacks", "", "Lcom/taptap/sdk/gid/TapSdkGid$GidCallback;", "tdidCallbacks", "Lcom/taptap/sdk/gid/TapSdkGid$TdidCallback;", "(Lcom/taptap/sdk/initializer/api/option/TapTapSdkOptions;Ljava/util/List;Ljava/util/List;)V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "gidRepository", "Lcom/taptap/sdk/gid/repository/GidRepository;", "getCurrentGid", "Lcom/taptap/sdk/gid/data/response/Gid;", "getCurrentTdid", "", "getGid", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getGidAsync", "", "getTdid", "initialize", "notifyListenersGidUpdated", "gid", "notifyListenersTdidUpdated", "tdid", "provideGidApiService", "Lcom/taptap/sdk/gid/service/network/GidApiService;", "isRND", "", "registerGidCallback", "callback", "setupGidFlowCollection", "setupTdidFlowCollection", "unregisterGidCallback", "Builder", "GidCallback", "Runtime", "TdidCallback", "tap-gid_release"})
public final class TapSdkGid {
    @NotNull
    public static final Runtime Runtime = new Runtime(null);
    @NotNull
    private TapTapSdkOptions options;
    @NotNull
    private List<? extends GidCallback> gidCallbacks;
    @NotNull
    private List<? extends TdidCallback> tdidCallbacks;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final GidRepository gidRepository;
    @NotNull
    private static final String TAG = "TapSdkGid";
    @Nullable
    private static volatile TapSdkGid INSTANCE;

    public TapSdkGid(@NotNull TapTapSdkOptions options, @NotNull List<? extends GidCallback> gidCallbacks, @NotNull List<? extends TdidCallback> tdidCallbacks) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter(gidCallbacks, (String)"gidCallbacks");
        Intrinsics.checkNotNullParameter(tdidCallbacks, (String)"tdidCallbacks");
        this.options = options;
        this.gidCallbacks = gidCallbacks;
        this.tdidCallbacks = tdidCallbacks;
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getMain().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
        this.gidRepository = new GidRepository(GidDiskServiceFactory.INSTANCE.create(this.options.getContext(), this.options.getRegion(), true), new DefaultGidNetworkService(this.provideGidApiService(TapTapKit.INSTANCE.isRND(), this.options)), new ThemisLiteManager.Builder().setAppID(this.options.getRegion().getValue()).setTimeout(5000L).setInitThemisTapaid(this.options.getRegion() == RegionType.CN).setInitGADID(this.options.getRegion() == RegionType.GLOBAL).build());
    }

    private TapSdkGid(Builder builder) {
        this(builder.getOptions(), builder.getGidCallbacks(), builder.getTdidCallbacks());
    }

    @NotNull
    public final TapSdkGid initialize() {
        TapSdkGid tapSdkGid;
        TapSdkGid $this$initialize_u24lambda_u240 = tapSdkGid = this;
        boolean bl = false;
        $this$initialize_u24lambda_u240.setupGidFlowCollection();
        $this$initialize_u24lambda_u240.setupTdidFlowCollection();
        $this$initialize_u24lambda_u240.gidRepository.initialize();
        $this$initialize_u24lambda_u240.getGidAsync();
        return tapSdkGid;
    }

    private final void setupGidFlowCollection() {
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ TapSdkGid this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = TapSdkGid.access$getGidRepository$p(this.this$0).getGidFlow().collect(new FlowCollector(this.this$0){
                            final /* synthetic */ TapSdkGid this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            @Nullable
                            public final Object emit(@NotNull Gid gid, @NotNull Continuation<? super Unit> $completion) {
                                TapSdkGid.access$notifyListenersGidUpdated(this.this$0, gid);
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void setupTdidFlowCollection() {
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ TapSdkGid this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = TapSdkGid.access$getGidRepository$p(this.this$0).getTdidFlow().collect(new FlowCollector(this.this$0){
                            final /* synthetic */ TapSdkGid this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            @Nullable
                            public final Object emit(@NotNull String tdid, @NotNull Continuation<? super Unit> $completion) {
                                TapSdkGid.access$notifyListenersTdidUpdated(this.this$0, tdid);
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void getGidAsync() {
        try {
            this.gidRepository.getGidAsync();
        }
        catch (Throwable error) {
            Log.e((String)TAG, (String)"\u83b7\u53d6 gid \u5931\u8d25", (Throwable)error);
        }
    }

    @Nullable
    public final Gid getCurrentGid() {
        return this.gidRepository.getCurrentGid();
    }

    @Nullable
    public final String getCurrentTdid() {
        return this.gidRepository.getCurrentTdid();
    }

    @Nullable
    public final Object getGid(@NotNull Continuation<? super Gid> $completion) {
        return this.gidRepository.getGid($completion);
    }

    @Nullable
    public final Object getTdid(@NotNull Continuation<? super String> $completion) {
        return this.gidRepository.getTdid($completion);
    }

    public final void registerGidCallback(@NotNull GidCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.gidCallbacks = CollectionsKt.plus((Collection)this.gidCallbacks, (Object)callback);
    }

    public final void unregisterGidCallback(@NotNull GidCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.gidCallbacks = CollectionsKt.minus((Iterable)this.gidCallbacks, (Object)callback);
    }

    private final void notifyListenersGidUpdated(Gid gid) {
        Iterable $this$forEach$iv = this.gidCallbacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            GidCallback callback = (GidCallback)element$iv;
            boolean bl = false;
            TapSdkGid tapSdkGid = this;
            try {
                TapSdkGid $this$notifyListenersGidUpdated_u24lambda_u242_u24lambda_u241 = tapSdkGid;
                boolean bl2 = false;
                callback.onGidUpdated(gid);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
        }
    }

    private final void notifyListenersTdidUpdated(String tdid) {
        Iterable $this$forEach$iv = this.tdidCallbacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            TdidCallback callback = (TdidCallback)element$iv;
            boolean bl = false;
            TapSdkGid tapSdkGid = this;
            try {
                TapSdkGid $this$notifyListenersTdidUpdated_u24lambda_u244_u24lambda_u243 = tapSdkGid;
                boolean bl2 = false;
                callback.onTdidUpdated(tdid);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
        }
    }

    private final GidApiService provideGidApiService(boolean isRND, TapTapSdkOptions options) {
        Retrofit retrofit = NetworkClientKt.provideRetrofit((String)TapSdkGid.provideGidApiService$getBaseUrl(isRND, options.getRegion()), (TapTapSdkOptions)options);
        Object object = retrofit.create(GidApiService.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"retrofit.create(GidApiService::class.java)");
        return (GidApiService)object;
    }

    private static final String provideGidApiService$getBaseUrl(boolean isRND, RegionType regionType) {
        String string;
        block9: {
            block8: {
                if (!isRND) break block8;
                switch (WhenMappings.$EnumSwitchMapping$0[regionType.ordinal()]) {
                    case 1: {
                        string = "https://gid.api.xdrnd.cn";
                        break block9;
                    }
                    case 2: {
                        string = "https://gid.api.xdrnd.com";
                        break block9;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            switch (WhenMappings.$EnumSwitchMapping$0[regionType.ordinal()]) {
                case 1: {
                    string = "https://gid.tapapis.cn";
                    break;
                }
                case 2: {
                    string = "https://gid.tapapis.com";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return string;
    }

    public static final /* synthetic */ GidRepository access$getGidRepository$p(TapSdkGid $this) {
        return $this.gidRepository;
    }

    public static final /* synthetic */ void access$notifyListenersGidUpdated(TapSdkGid $this, Gid gid) {
        $this.notifyListenersGidUpdated(gid);
    }

    public static final /* synthetic */ void access$notifyListenersTdidUpdated(TapSdkGid $this, String tdid) {
        $this.notifyListenersTdidUpdated(tdid);
    }

    public /* synthetic */ TapSdkGid(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/taptap/sdk/gid/TapSdkGid$GidCallback;", "", "onGidUpdated", "", "gid", "Lcom/taptap/sdk/gid/data/response/Gid;", "tap-gid_release"})
    public static interface GidCallback {
        public void onGidUpdated(@NotNull Gid var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/taptap/sdk/gid/TapSdkGid$TdidCallback;", "", "onTdidUpdated", "", "tdid", "", "tap-gid_release"})
    public static interface TdidCallback {
        public void onTdidUpdated(@Nullable String var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0007J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\rR*\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR*\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\r0\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/taptap/sdk/gid/TapSdkGid$Builder;", "", "options", "Lcom/taptap/sdk/initializer/api/option/TapTapSdkOptions;", "(Lcom/taptap/sdk/initializer/api/option/TapTapSdkOptions;)V", "<set-?>", "", "Lcom/taptap/sdk/gid/TapSdkGid$GidCallback;", "gidCallbacks", "getGidCallbacks", "()Ljava/util/List;", "getOptions", "()Lcom/taptap/sdk/initializer/api/option/TapTapSdkOptions;", "Lcom/taptap/sdk/gid/TapSdkGid$TdidCallback;", "tdidCallbacks", "getTdidCallbacks", "build", "Lcom/taptap/sdk/gid/TapSdkGid;", "registerGidCallback", "callBack", "registerTdidCallback", "tap-gid_release"})
    public static final class Builder {
        @NotNull
        private final TapTapSdkOptions options;
        @NotNull
        private List<? extends GidCallback> gidCallbacks;
        @NotNull
        private List<? extends TdidCallback> tdidCallbacks;

        public Builder(@NotNull TapTapSdkOptions options) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            this.options = options;
            this.gidCallbacks = new CopyOnWriteArrayList();
            this.tdidCallbacks = new CopyOnWriteArrayList();
        }

        @NotNull
        public final TapTapSdkOptions getOptions() {
            return this.options;
        }

        @NotNull
        public final List<GidCallback> getGidCallbacks() {
            return this.gidCallbacks;
        }

        @NotNull
        public final List<TdidCallback> getTdidCallbacks() {
            return this.tdidCallbacks;
        }

        @NotNull
        public final Builder registerGidCallback(@NotNull GidCallback callBack) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
            Builder $this$registerGidCallback_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$registerGidCallback_u24lambda_u240.gidCallbacks = CollectionsKt.plus((Collection)$this$registerGidCallback_u24lambda_u240.gidCallbacks, (Object)callBack);
            return builder;
        }

        @NotNull
        public final Builder registerTdidCallback(@NotNull TdidCallback callBack) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
            Builder $this$registerTdidCallback_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$registerTdidCallback_u24lambda_u241.tdidCallbacks = CollectionsKt.plus((Collection)$this$registerTdidCallback_u24lambda_u241.tdidCallbacks, (Object)callBack);
            return builder;
        }

        @NotNull
        public final TapSdkGid build() {
            return new TapSdkGid(this, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/taptap/sdk/gid/TapSdkGid$Runtime;", "", "()V", "INSTANCE", "Lcom/taptap/sdk/gid/TapSdkGid;", "getINSTANCE$tap_gid_release", "()Lcom/taptap/sdk/gid/TapSdkGid;", "setINSTANCE$tap_gid_release", "(Lcom/taptap/sdk/gid/TapSdkGid;)V", "TAG", "", "tap-gid_release"})
    public static final class Runtime {
        private Runtime() {
        }

        @Nullable
        public final TapSdkGid getINSTANCE$tap_gid_release() {
            return INSTANCE;
        }

        public final void setINSTANCE$tap_gid_release(@Nullable TapSdkGid tapSdkGid) {
            INSTANCE = tapSdkGid;
        }

        public /* synthetic */ Runtime(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RegionType.values().length];
            try {
                nArray[RegionType.CN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RegionType.GLOBAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

