/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.heartbeat.internal;

import android.content.Context;
import com.taptap.sdk.heartbeat.internal.TapHeartbeatSdk;
import com.taptap.sdk.kit.internal.identifier.TapIdentifierUtil;
import com.taptap.sdk.kit.internal.utils.DeviceUtils;
import com.taptap.sdk.kit.internal.utils.NetworkUtil;
import com.taptap.sdk.kit.internal.utils.PlatformXUA;
import com.taptap.sdk.kit.internal.utils.localize.TapLocalizeUtil;
import java.io.File;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0003J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/taptap/sdk/heartbeat/internal/TapHeartbeatParamsHelper;", "", "()V", "ENV_CLOUD", "", "ENV_LOCAL", "ENV_SANDBOX", "PARAM_PN", "PATH_DATA_DIR", "TAG", "getCommonParams", "Lorg/json/JSONObject;", "context", "Landroid/content/Context;", "getHeartbeatParams", "tap-heartbeat_release"})
public final class TapHeartbeatParamsHelper {
    @NotNull
    public static final TapHeartbeatParamsHelper INSTANCE = new TapHeartbeatParamsHelper();
    @NotNull
    private static final String TAG = "TapHeartbeatParamsHelper";
    @NotNull
    private static final String PATH_DATA_DIR = "tapsdk";
    @NotNull
    private static final String ENV_LOCAL = "local";
    @NotNull
    private static final String ENV_SANDBOX = "sandbox";
    @NotNull
    private static final String ENV_CLOUD = "cloud";
    @NotNull
    private static final String PARAM_PN = "TapSDK";

    private TapHeartbeatParamsHelper() {
    }

    @JvmStatic
    @JvmName(name="getHeartbeatParams")
    @NotNull
    public static final JSONObject getHeartbeatParams(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JSONObject config = new JSONObject();
        config.put("region", TapHeartbeatSdk.INSTANCE.getRegionType$tap_heartbeat_release());
        config.put("log_to_console", 0);
        config.put("log_level", 1);
        config.put("platform", (Object)"Android");
        config.put("tapsdk_version", (Object)"4.3.1");
        config.put("tapsdk_artifact", (Object)PlatformXUA.getTrackSDKArtifact());
        File dir = new File(context.getFilesDir(), PATH_DATA_DIR);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        config.put("data_dir", (Object)dir.getAbsolutePath());
        String env = ENV_LOCAL;
        if (DeviceUtils.isRunInSandbox()) {
            env = ENV_SANDBOX;
        } else if (DeviceUtils.isRunInCloud()) {
            env = ENV_CLOUD;
        }
        config.put("env", (Object)env);
        config.put("ua", (Object)PlatformXUA.getTrackUA());
        config.put("client_id", (Object)TapHeartbeatSdk.INSTANCE.getClientId$tap_heartbeat_release());
        config.put("client_token", (Object)TapHeartbeatSdk.INSTANCE.getClientToken$tap_heartbeat_release());
        config.put("common", (Object)TapHeartbeatParamsHelper.getCommonParams(context));
        return config;
    }

    @JvmStatic
    private static final JSONObject getCommonParams(Context context) {
        JSONObject commonConfig = new JSONObject();
        commonConfig.put("pn", (Object)PARAM_PN);
        commonConfig.put("app_version_code", (Object)String.valueOf(DeviceUtils.getPackageVersionCode((Context)context)));
        commonConfig.put("app_version", (Object)DeviceUtils.getPackageVersion((Context)context));
        commonConfig.put("app_package_name", (Object)context.getPackageName());
        commonConfig.put("install_uuid", (Object)TapIdentifierUtil.INSTANCE.getInstallUUID());
        commonConfig.put("device_id", (Object)TapIdentifierUtil.INSTANCE.getDeviceId(context));
        commonConfig.put("android_id", (Object)TapIdentifierUtil.getAndroidID((Context)context));
        commonConfig.put("dv", (Object)DeviceUtils.getManufacturer());
        commonConfig.put("md", (Object)DeviceUtils.getModel());
        commonConfig.put("hardware", (Object)DeviceUtils.getCPUHardware());
        commonConfig.put("cpu", (Object)DeviceUtils.getCpuInfo());
        commonConfig.put("cpu_abis", (Object)DeviceUtils.getCpuABIS());
        commonConfig.put("network_type", (Object)NetworkUtil.getConnectedType((Context)context));
        commonConfig.put("mobile_type", (Object)NetworkUtil.getNetworkType((Context)context));
        commonConfig.put("os", (Object)DeviceUtils.getPlatform());
        commonConfig.put("sv", (Object)DeviceUtils.getOS());
        int[] nArray = DeviceUtils.getDeviceSize((Context)context);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getDeviceSize(context)");
        int[] size = nArray;
        commonConfig.put("width", (Object)String.valueOf(size[0]));
        commonConfig.put("height", (Object)String.valueOf(size[1]));
        commonConfig.put("timezone", (Object)TimeZone.getDefault().getID());
        commonConfig.put("rom", (Object)String.valueOf(DeviceUtils.getRemainingRomSize()));
        commonConfig.put("ram", (Object)String.valueOf(DeviceUtils.getRemainingRamSize((Context)context)));
        commonConfig.put("total_rom", (Object)String.valueOf(DeviceUtils.getDeviceTotalRom((Context)context)));
        commonConfig.put("total_ram", (Object)String.valueOf(DeviceUtils.getDeviceTotalRam((Context)context)));
        commonConfig.put("sdk_locale", (Object)TapLocalizeUtil.getPreferredLanguage().getLanguage());
        return commonConfig;
    }
}

