/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.heartbeat.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import com.taptap.sdk.heartbeat.internal.TapHeartbeatParamsHelper;
import com.taptap.sdk.heartbeat.internal.TapHeartbeatRemote;
import com.taptap.sdk.heartbeat.internal.TapHeartbeatSdk;
import com.taptap.sdk.heartbeat.internal.util.TapOpenlogHelper;
import com.taptap.sdk.kit.ITapTapOptionsInternal;
import com.taptap.sdk.kit.TapTapSdkBaseOptions;
import com.taptap.sdk.kit.internal.TapLogger;
import com.taptap.sdk.kit.internal.TapTapKit;
import com.taptap.sdk.kit.internal.identifier.TapIdentifierUtil;
import com.taptap.sdk.kit.internal.service.ITapAutoService;
import com.taptap.sdk.kit.internal.service.ITapServiceCallback;
import com.taptap.sdk.kit.internal.service.TapTapServices;
import com.taptap.sdk.kit.internal.utils.TapActivityLifecycleCallbacks;
import com.taptap.sdk.kit.internal.utils.TapActivityLifecycleTracker;
import com.taptap.sdk.kit.internal.utils.localize.ITapLanguageChangeListener;
import com.taptap.sdk.kit.internal.utils.localize.TapLanguageInternal;
import com.taptap.sdk.kit.internal.utils.localize.TapLocalizeUtil;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000O\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016*\u0001\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b J'\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'H\u0001\u00a2\u0006\u0002\b(J\r\u0010\u0016\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b)J\u0017\u0010*\u001a\u00020\u001e2\b\u0010+\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b,J\r\u0010-\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b.J\u0015\u0010/\u001a\u00020\u001e2\u0006\u00100\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b1J\u0017\u00102\u001a\u00020\u001e2\b\u00103\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b4J\u0017\u00105\u001a\u00020\u001e2\b\u00106\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b7J\u0017\u00108\u001a\u00020\u001e2\b\u00109\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b:J\b\u0010;\u001a\u00020\u001eH\u0002J\b\u0010<\u001a\u00020\u001eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u001a\u0010\b\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006="}, d2={"Lcom/taptap/sdk/heartbeat/internal/TapHeartbeatSdk;", "", "()V", "TAG", "", "activityLifecycleCallbacks", "com/taptap/sdk/heartbeat/internal/TapHeartbeatSdk$activityLifecycleCallbacks$1", "Lcom/taptap/sdk/heartbeat/internal/TapHeartbeatSdk$activityLifecycleCallbacks$1;", "clientId", "getClientId$tap_heartbeat_release", "()Ljava/lang/String;", "setClientId$tap_heartbeat_release", "(Ljava/lang/String;)V", "clientToken", "getClientToken$tap_heartbeat_release", "setClientToken$tap_heartbeat_release", "currentOpenId", "heartbeatParams", "Lorg/json/JSONObject;", "isEnable", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isInitialized", "isStart", "regionType", "", "getRegionType$tap_heartbeat_release", "()I", "setRegionType$tap_heartbeat_release", "(I)V", "enable", "", "", "enable$tap_heartbeat_release", "initializeIfNotInitialized", "context", "Landroid/content/Context;", "baseOptions", "Lcom/taptap/sdk/kit/TapTapSdkBaseOptions;", "options", "Lcom/taptap/sdk/kit/ITapTapOptionsInternal;", "initializeIfNotInitialized$tap_heartbeat_release", "isStart$tap_heartbeat_release", "login", "openId", "login$tap_heartbeat_release", "logout", "logout$tap_heartbeat_release", "setExtraParams", "extraParams", "setExtraParams$tap_heartbeat_release", "setGameUserId", "gameUserId", "setGameUserId$tap_heartbeat_release", "setGid", "gid", "setGid$tap_heartbeat_release", "setOAID", "oaid", "setOAID$tap_heartbeat_release", "start", "stop", "tap-heartbeat_release"})
public final class TapHeartbeatSdk {
    @NotNull
    public static final TapHeartbeatSdk INSTANCE = new TapHeartbeatSdk();
    @NotNull
    private static final String TAG = "TapHeartbeatSdk";
    @NotNull
    private static final AtomicBoolean isInitialized = new AtomicBoolean(false);
    @NotNull
    private static final AtomicBoolean isStart = new AtomicBoolean(false);
    @NotNull
    private static final AtomicBoolean isEnable = new AtomicBoolean(false);
    @NotNull
    private static String clientId = "";
    @NotNull
    private static String clientToken = "";
    private static int regionType;
    @NotNull
    private static JSONObject heartbeatParams;
    @Nullable
    private static String currentOpenId;
    @NotNull
    private static final activityLifecycleCallbacks.1 activityLifecycleCallbacks;

    private TapHeartbeatSdk() {
    }

    @NotNull
    public final String getClientId$tap_heartbeat_release() {
        return clientId;
    }

    public final void setClientId$tap_heartbeat_release(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        clientId = string;
    }

    @NotNull
    public final String getClientToken$tap_heartbeat_release() {
        return clientToken;
    }

    public final void setClientToken$tap_heartbeat_release(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        clientToken = string;
    }

    public final int getRegionType$tap_heartbeat_release() {
        return regionType;
    }

    public final void setRegionType$tap_heartbeat_release(int n) {
        regionType = n;
    }

    @JvmStatic
    public static final void initializeIfNotInitialized$tap_heartbeat_release(@NotNull Context context, @NotNull TapTapSdkBaseOptions baseOptions, @Nullable ITapTapOptionsInternal options) {
        block6: {
            String it;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)baseOptions, (String)"baseOptions");
            if (isInitialized.get()) {
                return;
            }
            TapLogger.logd((String)TAG, (String)"initialize start");
            clientId = baseOptions.getClientId();
            clientToken = baseOptions.getClientToken();
            regionType = TapTapKit.INSTANCE.isRND() ? 2 : baseOptions.getRegionType();
            heartbeatParams = TapHeartbeatParamsHelper.getHeartbeatParams(context);
            String string = TapIdentifierUtil.INSTANCE.getOpenId();
            if (string != null) {
                it = string;
                boolean bl = false;
                currentOpenId = it;
                JSONObject jSONObject = heartbeatParams.optJSONObject("common");
                if (jSONObject != null) {
                    jSONObject.put("open_id", (Object)it);
                }
            }
            TapLogger.logd((String)TAG, (String)("init heartbeatParams =\n" + heartbeatParams));
            try {
                System.loadLibrary("tapsdkcore");
                TapLogger.logd((String)TAG, (String)"initialize end");
                isInitialized.set(true);
            }
            catch (Throwable e) {
                TapOpenlogHelper.INSTANCE.reportTechnicalLog("init_throwable", MapsKt.mapOf((Pair)TuplesKt.to((Object)"throwable", (Object)String.valueOf(e.getMessage()))));
                TapLogger.loge((String)TAG, (String)"initialize failure", (Throwable)e);
            }
            TapLocalizeUtil.INSTANCE.registerLanguageChangeListener(new ITapLanguageChangeListener(){

                public void onLanguageChange(boolean isDomestic, @NotNull TapLanguageInternal currentLanguage) {
                    Intrinsics.checkNotNullParameter((Object)currentLanguage, (String)"currentLanguage");
                    JSONObject jsonObject = new JSONObject();
                    JSONObject jsonCommon = new JSONObject();
                    jsonCommon.put("sdk_locale", (Object)TapLocalizeUtil.getPreferredLanguage().getLanguage());
                    jsonObject.put("common", (Object)jsonCommon);
                    String string = jsonObject.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject.toString()");
                    TapHeartbeatRemote.INSTANCE.updateConfig(string);
                }
            });
            ITapAutoService iTapAutoService = TapTapServices.INSTANCE.find("TapTapGid");
            if (iTapAutoService != null) {
                iTapAutoService.execute(TapTapKit.INSTANCE.getContext(), "registerCallback", MapsKt.mapOf((Pair)TuplesKt.to((Object)"callback", (Object)new ITapServiceCallback(){

                    public void onResult(int code, @Nullable String result) {
                        TapLogger.logd((String)"TapHeartbeatSdk", (String)("onResult code = " + code + ", result = " + result));
                        TapHeartbeatSdk.INSTANCE.setGid$tap_heartbeat_release(result);
                    }
                })));
            }
            String string2 = TapIdentifierUtil.INSTANCE.queryGID();
            if (string2 == null) break block6;
            it = string2;
            boolean bl = false;
            INSTANCE.setGid$tap_heartbeat_release(it);
        }
    }

    public final void enable$tap_heartbeat_release(boolean enable) {
        if (!isInitialized.get()) {
            return;
        }
        if (isEnable.get() == enable) {
            return;
        }
        TapLogger.logd((String)TAG, (String)("TapHeartbeat enable = " + enable));
        isEnable.set(enable);
        if (enable) {
            this.start();
        } else {
            this.stop();
        }
    }

    public final boolean isStart$tap_heartbeat_release() {
        if (!isInitialized.get()) {
            return false;
        }
        return isStart.get();
    }

    public final void login$tap_heartbeat_release(@Nullable String openId) {
        if (!isInitialized.get()) {
            return;
        }
        CharSequence charSequence = openId;
        if (charSequence == null || charSequence.length() == 0 || Intrinsics.areEqual((Object)currentOpenId, (Object)openId)) {
            TapLogger.logd((String)TAG, (String)("openId \u975e\u6cd5\u6216\u8005\u4e0e\u5f53\u524d\u4e00\u81f4 currentOpenId = " + currentOpenId + " , openId = " + openId));
            return;
        }
        currentOpenId = openId;
        TapLogger.logd((String)TAG, (String)("login, openId = " + openId));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("open_id", (Object)openId);
        String string = jsonObject.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject.toString()");
        TapHeartbeatRemote.INSTANCE.onLogin(string);
    }

    public final void logout$tap_heartbeat_release() {
        if (!isInitialized.get()) {
            return;
        }
        currentOpenId = null;
        TapLogger.logd((String)TAG, (String)"logout");
        TapHeartbeatRemote.INSTANCE.onLogout();
    }

    public final void setExtraParams$tap_heartbeat_release(@NotNull String extraParams) {
        Intrinsics.checkNotNullParameter((Object)extraParams, (String)"extraParams");
        if (!isInitialized.get()) {
            return;
        }
        TapLogger.logd((String)TAG, (String)("setExtraParams = " + extraParams));
        TapHeartbeatRemote.INSTANCE.setExtraParams(extraParams);
    }

    public final void setGid$tap_heartbeat_release(@Nullable String gid) {
        if (!isInitialized.get()) {
            return;
        }
        TapLogger.logd((String)TAG, (String)("setGid = " + gid));
        JSONObject jsonObject = new JSONObject();
        String string = gid;
        if (string == null) {
            string = "";
        }
        jsonObject.put("gid", (Object)string);
        String string2 = jsonObject.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jsonObject.toString()");
        TapHeartbeatRemote.INSTANCE.setExtraParams(string2);
    }

    public final void setOAID$tap_heartbeat_release(@Nullable String oaid) {
        if (!isInitialized.get()) {
            return;
        }
        TapLogger.logd((String)TAG, (String)("setOAID = " + oaid));
        JSONObject jsonObject = new JSONObject();
        String string = oaid;
        if (string == null) {
            string = "";
        }
        jsonObject.put("oaid", (Object)string);
        String string2 = jsonObject.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jsonObject.toString()");
        TapHeartbeatRemote.INSTANCE.setExtraParams(string2);
    }

    public final void setGameUserId$tap_heartbeat_release(@Nullable String gameUserId) {
        if (!isInitialized.get()) {
            return;
        }
        TapLogger.logd((String)TAG, (String)("setGameUserId = " + gameUserId));
        JSONObject jsonObject = new JSONObject();
        String string = gameUserId;
        if (string == null) {
            string = "";
        }
        jsonObject.put("game_user_id", (Object)string);
        String string2 = jsonObject.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jsonObject.toString()");
        TapHeartbeatRemote.INSTANCE.setExtraParams(string2);
    }

    private final void start() {
        if (!isInitialized.get()) {
            return;
        }
        if (!isEnable.get() || isStart.get()) {
            return;
        }
        TapActivityLifecycleTracker.INSTANCE.registerActivityLifecycleCallbacks((TapActivityLifecycleCallbacks)activityLifecycleCallbacks);
        String string = heartbeatParams.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"heartbeatParams.toString()");
        int code = TapHeartbeatRemote.INSTANCE.onAppStarted(string);
        if (code == 0) {
            isStart.set(true);
        }
        TapLogger.logd((String)TAG, (String)("start = " + isStart + " , heartbeatParams = \n" + heartbeatParams));
    }

    private final void stop() {
        if (!isInitialized.get()) {
            return;
        }
        TapActivityLifecycleTracker.INSTANCE.unregisterActivityLifecycleCallbacks((TapActivityLifecycleCallbacks)activityLifecycleCallbacks);
        TapHeartbeatRemote.INSTANCE.onAppStopped();
        isStart.set(false);
        TapLogger.logd((String)TAG, (String)"stop");
    }

    public static final /* synthetic */ AtomicBoolean access$isInitialized$p() {
        return isInitialized;
    }

    public static final /* synthetic */ AtomicBoolean access$isEnable$p() {
        return isEnable;
    }

    public static final /* synthetic */ AtomicBoolean access$isStart$p() {
        return isStart;
    }

    public static final /* synthetic */ JSONObject access$getHeartbeatParams$p() {
        return heartbeatParams;
    }

    static {
        heartbeatParams = new JSONObject();
        activityLifecycleCallbacks = new TapActivityLifecycleCallbacks(){

            public void onForeground(@NotNull Context context) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                TapActivityLifecycleCallbacks.DefaultImpls.onForeground((TapActivityLifecycleCallbacks)this, (Context)context);
                if (TapHeartbeatSdk.access$isInitialized$p().get() && TapHeartbeatSdk.access$isEnable$p().get()) {
                    if (TapHeartbeatSdk.access$isStart$p().get()) {
                        TapLogger.logd((String)"TapHeartbeatSdk", (String)"onForeground");
                        TapHeartbeatRemote.INSTANCE.onForeground();
                    } else {
                        TapLogger.logd((String)"TapHeartbeatSdk", (String)"onAppStarted");
                        String string = TapHeartbeatSdk.access$getHeartbeatParams$p().toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"heartbeatParams.toString()");
                        TapHeartbeatRemote.INSTANCE.onAppStarted(string);
                        TapHeartbeatRemote.INSTANCE.onForeground();
                    }
                }
            }

            public void onBackground(@NotNull Context context) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                TapActivityLifecycleCallbacks.DefaultImpls.onBackground((TapActivityLifecycleCallbacks)this, (Context)context);
                if (TapHeartbeatSdk.access$isInitialized$p().get() && TapHeartbeatSdk.access$isEnable$p().get()) {
                    TapLogger.logd((String)"TapHeartbeatSdk", (String)"onBackground");
                    TapHeartbeatRemote.INSTANCE.onBackground();
                }
            }

            public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
                TapActivityLifecycleCallbacks.DefaultImpls.onActivityCreated((TapActivityLifecycleCallbacks)this, (Activity)activity, (Bundle)savedInstanceState);
            }

            public void onActivityDestroyed(@NotNull Activity activity) {
                TapActivityLifecycleCallbacks.DefaultImpls.onActivityDestroyed((TapActivityLifecycleCallbacks)this, (Activity)activity);
            }

            public void onActivityPaused(@NotNull Activity activity) {
                TapActivityLifecycleCallbacks.DefaultImpls.onActivityPaused((TapActivityLifecycleCallbacks)this, (Activity)activity);
            }

            public void onActivityResumed(@NotNull Activity activity) {
                TapActivityLifecycleCallbacks.DefaultImpls.onActivityResumed((TapActivityLifecycleCallbacks)this, (Activity)activity);
            }

            public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
                TapActivityLifecycleCallbacks.DefaultImpls.onActivitySaveInstanceState((TapActivityLifecycleCallbacks)this, (Activity)activity, (Bundle)outState);
            }

            public void onActivityStarted(@NotNull Activity activity) {
                TapActivityLifecycleCallbacks.DefaultImpls.onActivityStarted((TapActivityLifecycleCallbacks)this, (Activity)activity);
            }

            public void onActivityStopped(@NotNull Activity activity) {
                TapActivityLifecycleCallbacks.DefaultImpls.onActivityStopped((TapActivityLifecycleCallbacks)this, (Activity)activity);
            }
        };
    }
}

