/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.initializer.manager;

import android.content.Context;
import android.content.SharedPreferences;
import com.taptap.sdk.common.network.NetworkClientKt;
import com.taptap.sdk.initializer.api.model.RegionType;
import com.taptap.sdk.initializer.api.option.TapTapSdkOptions;
import com.taptap.sdk.initializer.data.response.GateKeeper;
import com.taptap.sdk.initializer.manager.GatekeeperManager;
import com.taptap.sdk.initializer.repository.GatekeeperRepository;
import com.taptap.sdk.initializer.repository.local.PrefsGatekeeperStorage;
import com.taptap.sdk.initializer.repository.remote.GatekeeperApiService;
import com.taptap.sdk.kit.internal.TapTapKit;
import com.taptap.sdk.retrofit2.Retrofit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002%&B\u000f\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\b\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u0000J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0018H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020$H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006'"}, d2={"Lcom/taptap/sdk/initializer/manager/GatekeeperManager;", "", "builder", "Lcom/taptap/sdk/initializer/manager/GatekeeperManager$Builder;", "(Lcom/taptap/sdk/initializer/manager/GatekeeperManager$Builder;)V", "options", "Lcom/taptap/sdk/initializer/api/option/TapTapSdkOptions;", "listeners", "", "Lcom/taptap/sdk/initializer/manager/GatekeeperManager$OnGateKeeperChangeListener;", "(Lcom/taptap/sdk/initializer/api/option/TapTapSdkOptions;Ljava/util/List;)V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "repository", "Lcom/taptap/sdk/initializer/repository/GatekeeperRepository;", "getRepository", "()Lcom/taptap/sdk/initializer/repository/GatekeeperRepository;", "repository$delegate", "Lkotlin/Lazy;", "getBaseUrl", "", "isRND", "", "regionType", "Lcom/taptap/sdk/initializer/api/model/RegionType;", "getCurrentGateKeeper", "Lcom/taptap/sdk/initializer/data/response/GateKeeper;", "initialize", "provideNetworkApiService", "Lcom/taptap/sdk/initializer/repository/remote/GatekeeperApiService;", "region", "provideStorage", "Lcom/taptap/sdk/initializer/repository/local/PrefsGatekeeperStorage;", "context", "Landroid/content/Context;", "setupGateKeeperFlow", "", "Builder", "OnGateKeeperChangeListener", "tap-initializer_release"})
public final class GatekeeperManager {
    @NotNull
    private final TapTapSdkOptions options;
    @NotNull
    private final List<OnGateKeeperChangeListener> listeners;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final Lazy repository$delegate;

    private GatekeeperManager(TapTapSdkOptions options, List<? extends OnGateKeeperChangeListener> listeners) {
        this.options = options;
        this.listeners = listeners;
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getMain().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));
        this.repository$delegate = LazyKt.lazy((Function0)((Function0)new Function0<GatekeeperRepository>(this){
            final /* synthetic */ GatekeeperManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final GatekeeperRepository invoke() {
                return new GatekeeperRepository(GatekeeperManager.access$getOptions$p(this.this$0).getContext(), GatekeeperManager.access$provideNetworkApiService(this.this$0, TapTapKit.INSTANCE.isRND(), GatekeeperManager.access$getOptions$p(this.this$0).getRegion()), GatekeeperManager.access$provideStorage(this.this$0, GatekeeperManager.access$getOptions$p(this.this$0).getContext()));
            }
        }));
    }

    private GatekeeperManager(Builder builder) {
        this(builder.getOptions(), builder.getListeners$tap_initializer_release());
    }

    private final GatekeeperRepository getRepository() {
        Lazy lazy = this.repository$delegate;
        return (GatekeeperRepository)lazy.getValue();
    }

    @NotNull
    public final GatekeeperManager initialize() {
        GatekeeperManager gatekeeperManager;
        GatekeeperManager $this$initialize_u24lambda_u240 = gatekeeperManager = this;
        boolean bl = false;
        $this$initialize_u24lambda_u240.getRepository().initialize();
        $this$initialize_u24lambda_u240.setupGateKeeperFlow();
        return gatekeeperManager;
    }

    @NotNull
    public final GateKeeper getCurrentGateKeeper() {
        return this.getRepository().getCurrentGateKeeper();
    }

    private final PrefsGatekeeperStorage provideStorage(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.taptap.sdk.GATEKEEPER_SETTING", 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026ODE_PRIVATE\n            )");
        return new PrefsGatekeeperStorage(sharedPreferences, JsonKt.Json$default(null, (Function1)provideStorage.1.INSTANCE, (int)1, null));
    }

    private final GatekeeperApiService provideNetworkApiService(boolean isRND, RegionType region) {
        Retrofit retrofit = NetworkClientKt.provideRetrofit((String)this.getBaseUrl(isRND, region), (TapTapSdkOptions)this.options);
        Object object = retrofit.create(GatekeeperApiService.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"retrofit.create(GatekeeperApiService::class.java)");
        return (GatekeeperApiService)object;
    }

    private final String getBaseUrl(boolean isRND, RegionType regionType) {
        String string;
        block9: {
            block8: {
                if (isRND) break block8;
                switch (WhenMappings.$EnumSwitchMapping$0[regionType.ordinal()]) {
                    case 1: {
                        string = "https://tapsdk.tapapis.cn";
                        break block9;
                    }
                    case 2: {
                        string = "https://tapsdk.tapapis.com";
                        break block9;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            switch (WhenMappings.$EnumSwitchMapping$0[regionType.ordinal()]) {
                case 1: {
                    string = "https://tapsdk.api.xdrnd.cn";
                    break;
                }
                case 2: {
                    string = "https://tapsdk.api.xdrnd.com";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return string;
    }

    private final void setupGateKeeperFlow() {
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ GatekeeperManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = GatekeeperManager.access$getRepository(this.this$0).getGateKeeperFlow().collect(new FlowCollector(this.this$0){
                            final /* synthetic */ GatekeeperManager this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            @Nullable
                            public final Object emit(@NotNull GateKeeper gateKeeper, @NotNull Continuation<? super Unit> $completion) {
                                Iterable $this$forEach$iv = GatekeeperManager.access$getListeners$p(this.this$0);
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    OnGateKeeperChangeListener listener = (OnGateKeeperChangeListener)element$iv;
                                    boolean bl = false;
                                    listener.onGateKeeperChange(gateKeeper);
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static final /* synthetic */ GatekeeperRepository access$getRepository(GatekeeperManager $this) {
        return $this.getRepository();
    }

    public static final /* synthetic */ List access$getListeners$p(GatekeeperManager $this) {
        return $this.listeners;
    }

    public /* synthetic */ GatekeeperManager(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    public static final /* synthetic */ TapTapSdkOptions access$getOptions$p(GatekeeperManager $this) {
        return $this.options;
    }

    public static final /* synthetic */ GatekeeperApiService access$provideNetworkApiService(GatekeeperManager $this, boolean isRND, RegionType region) {
        return $this.provideNetworkApiService(isRND, region);
    }

    public static final /* synthetic */ PrefsGatekeeperStorage access$provideStorage(GatekeeperManager $this, Context context) {
        return $this.provideStorage(context);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/taptap/sdk/initializer/manager/GatekeeperManager$OnGateKeeperChangeListener;", "", "onGateKeeperChange", "", "newValue", "Lcom/taptap/sdk/initializer/data/response/GateKeeper;", "tap-initializer_release"})
    public static interface OnGateKeeperChangeListener {
        public void onGateKeeperChange(@NotNull GateKeeper var1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0007J\u0006\u0010\u000f\u001a\u00020\u0010R*\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/taptap/sdk/initializer/manager/GatekeeperManager$Builder;", "", "options", "Lcom/taptap/sdk/initializer/api/option/TapTapSdkOptions;", "(Lcom/taptap/sdk/initializer/api/option/TapTapSdkOptions;)V", "<set-?>", "", "Lcom/taptap/sdk/initializer/manager/GatekeeperManager$OnGateKeeperChangeListener;", "listeners", "getListeners$tap_initializer_release", "()Ljava/util/List;", "getOptions", "()Lcom/taptap/sdk/initializer/api/option/TapTapSdkOptions;", "addOnGateKeeperChangeListener", "listener", "build", "Lcom/taptap/sdk/initializer/manager/GatekeeperManager;", "tap-initializer_release"})
    public static final class Builder {
        @NotNull
        private final TapTapSdkOptions options;
        @NotNull
        private List<OnGateKeeperChangeListener> listeners;

        public Builder(@NotNull TapTapSdkOptions options) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            this.options = options;
            this.listeners = new ArrayList();
        }

        @NotNull
        public final TapTapSdkOptions getOptions() {
            return this.options;
        }

        @NotNull
        public final List<OnGateKeeperChangeListener> getListeners$tap_initializer_release() {
            return this.listeners;
        }

        @NotNull
        public final Builder addOnGateKeeperChangeListener(@NotNull OnGateKeeperChangeListener listener) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            Builder $this$addOnGateKeeperChangeListener_u24lambda_u240 = builder = this;
            boolean bl = false;
            ((Collection)$this$addOnGateKeeperChangeListener_u24lambda_u240.listeners).add(listener);
            return builder;
        }

        @NotNull
        public final GatekeeperManager build() {
            return new GatekeeperManager(this, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RegionType.values().length];
            try {
                nArray[RegionType.CN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RegionType.GLOBAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

