/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.kit.internal;

import android.annotation.SuppressLint;
import android.content.Context;
import com.taptap.sdk.kit.ITapTapOptions;
import com.taptap.sdk.kit.TapTapSdkBaseOptions;
import com.taptap.sdk.kit.internal.TapLogger;
import com.taptap.sdk.kit.internal.service.ITapAutoService;
import com.taptap.sdk.kit.internal.utils.KVUtil;
import com.taptap.sdk.kit.internal.utils.TapActivityLifecycleTracker;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u001eJ/\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!2\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0#\"\u00020$\u00a2\u0006\u0002\u0010%R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0007\"\u0004\b\u000e\u0010\tR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/taptap/sdk/kit/internal/TapTapKit;", "", "()V", "TAG", "", "clientId", "getClientId$tap_kit_release", "()Ljava/lang/String;", "setClientId$tap_kit_release", "(Ljava/lang/String;)V", "clientInitialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "clientToken", "getClientToken$tap_kit_release", "setClientToken$tap_kit_release", "context", "Landroid/content/Context;", "getContext", "()Landroid/content/Context;", "setContext", "(Landroid/content/Context;)V", "regionType", "", "getRegionType$tap_kit_release", "()I", "setRegionType$tap_kit_release", "(I)V", "startInitialized", "init", "", "init$tap_kit_release", "initializeClient", "baseOptions", "Lcom/taptap/sdk/kit/TapTapSdkBaseOptions;", "options", "", "Lcom/taptap/sdk/kit/ITapTapOptions;", "(Landroid/content/Context;Lcom/taptap/sdk/kit/TapTapSdkBaseOptions;[Lcom/taptap/sdk/kit/ITapTapOptions;)V", "tap-kit_release"})
@SuppressLint(value={"StaticFieldLeak"})
public final class TapTapKit {
    @NotNull
    public static final TapTapKit INSTANCE = new TapTapKit();
    @NotNull
    private static final String TAG = "TapTapKit";
    @NotNull
    private static final AtomicBoolean startInitialized = new AtomicBoolean(false);
    @NotNull
    private static final AtomicBoolean clientInitialized = new AtomicBoolean(false);
    @NotNull
    private static String clientId = "";
    @NotNull
    private static String clientToken = "";
    private static int regionType;
    public static Context context;

    private TapTapKit() {
    }

    @NotNull
    public final String getClientId$tap_kit_release() {
        return clientId;
    }

    public final void setClientId$tap_kit_release(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        clientId = string;
    }

    @NotNull
    public final String getClientToken$tap_kit_release() {
        return clientToken;
    }

    public final void setClientToken$tap_kit_release(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        clientToken = string;
    }

    public final int getRegionType$tap_kit_release() {
        return regionType;
    }

    public final void setRegionType$tap_kit_release(int n) {
        regionType = n;
    }

    @NotNull
    public final Context getContext() {
        Context context = TapTapKit.context;
        if (context != null) {
            return context;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"context");
        return null;
    }

    public final void setContext(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"<set-?>");
        TapTapKit.context = context;
    }

    public final synchronized void init$tap_kit_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!startInitialized.compareAndSet(false, true)) {
            return;
        }
        TapLogger.logd(TAG, "startInit");
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        INSTANCE.setContext(context2);
        TapActivityLifecycleTracker.INSTANCE.init$tap_kit_release(context);
    }

    public final void initializeClient(@NotNull Context context, @NotNull TapTapSdkBaseOptions baseOptions, ITapTapOptions ... options) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)baseOptions, (String)"baseOptions");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.init$tap_kit_release(context);
        if (!clientInitialized.compareAndSet(false, true)) {
            return;
        }
        TapLogger.logi("TapTapSdk", "TapTapKit init start");
        clientId = baseOptions.getClientId();
        clientToken = baseOptions.getClientToken();
        regionType = baseOptions.getRegionType();
        KVUtil.INSTANCE.init(context);
        try {
            ServiceLoader<ITapAutoService> tapServices = ServiceLoader.load(ITapAutoService.class);
            TapLogger.logi("TapTapSdk", "TapServices init start");
            ServiceLoader<ITapAutoService> serviceLoader = tapServices;
            if (serviceLoader != null) {
                Iterable $this$forEach$iv = serviceLoader;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ITapTapOptions iTapTapOptions;
                    ITapAutoService service;
                    block6: {
                        service = (ITapAutoService)element$iv;
                        boolean bl = false;
                        TapLogger.logi("TapTapSdk", "TapService[" + service.getModuleName() + "] init start");
                        ITapTapOptions[] iTapTapOptionsArray = options;
                        int n = iTapTapOptionsArray.length;
                        for (int i = 0; i < n; ++i) {
                            ITapTapOptions iTapTapOptions2;
                            ITapTapOptions it = iTapTapOptions2 = iTapTapOptionsArray[i];
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)service.getModuleName(), (Object)it.getModuleName())) continue;
                            iTapTapOptions = iTapTapOptions2;
                            break block6;
                        }
                        iTapTapOptions = null;
                    }
                    ITapTapOptions serviceOptions = iTapTapOptions;
                    boolean initResult = service.init(context, baseOptions, serviceOptions);
                    TapLogger.logi("TapTapSdk", "TapService[" + service.getModuleName() + "] init end , The result is " + (initResult ? "success" : "failure"));
                }
            }
            TapLogger.logi("TapTapSdk", "TapServices init end");
        }
        catch (Exception e) {
            TapLogger.loge$default("TapTapSdk", null, e, 2, null);
        }
        TapLogger.logi("TapTapSdk", "TapTapKit init end");
    }
}

