/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.kit.internal.identifier.content;

import android.content.Context;
import android.text.TextUtils;
import com.taptap.sdk.kit.internal.TapLogger;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.CountDownLatch;

class OaidHelper {
    private static final String TAG = "OaidHelper";
    private static volatile String OAID = "";
    private static CountDownLatch countDownLatch;
    private static Class<?> identifyListener;
    private static Class<?> idSupplier;
    private static Class<?> jLibrary;
    private static Class<?> midSDKHelper;
    private static Method loadCertMethod;
    private static volatile boolean hasInit;
    private static volatile String certString;

    OaidHelper() {
    }

    public static void init(Context context) {
        if (context == null) {
            return;
        }
        OaidHelper.initInvokeListener();
        if (midSDKHelper == null || identifyListener == null || idSupplier == null) {
            TapLogger.logd(TAG, "OAID \u8bfb\u53d6\u7c7b\u521b\u5efa\u5931\u8d25");
            hasInit = true;
            return;
        }
        if (loadCertMethod != null) {
            try {
                String certInfo = certString;
                if (TextUtils.isEmpty((CharSequence)certInfo)) {
                    TapLogger.logd(TAG, "not set OAID certInfo before init, so try to load assets certInfo");
                    certInfo = OaidHelper.loadPemFromAssetFile(context);
                    if (TextUtils.isEmpty((CharSequence)certInfo)) {
                        TapLogger.logd(TAG, "load OAID certInfo from asset is fail");
                    }
                }
                loadCertMethod.invoke(null, context, certInfo);
            }
            catch (Exception e) {
                TapLogger.loge(TAG, null, e);
            }
        }
        hasInit = true;
    }

    public static String getOAID(Context context) {
        try {
            if (!hasInit) {
                OaidHelper.init(context);
            }
            if (midSDKHelper == null || identifyListener == null || idSupplier == null) {
                TapLogger.logd(TAG, "OAID \u8bfb\u53d6\u7c7b\u521b\u5efa\u5931\u8d25");
                return "";
            }
            countDownLatch = new CountDownLatch(1);
            if (!TextUtils.isEmpty((CharSequence)OAID)) {
                return OAID;
            }
            OaidHelper.getOAIDReflect(context, 2);
            try {
                countDownLatch.await();
            }
            catch (InterruptedException e) {
                TapLogger.loge(TAG, null, e);
            }
            TapLogger.logd(TAG, "CountDownLatch await");
            return OAID;
        }
        catch (Throwable ex) {
            TapLogger.loge(TAG, null, ex);
            return "";
        }
    }

    private static void getOAIDReflect(Context context, int retryCount) {
        block6: {
            try {
                if (retryCount == 0) {
                    return;
                }
                int INIT_ERROR_RESULT_DELAY = 1008614;
                int INIT_RESULT_OK = 1008610;
                if (jLibrary != null) {
                    Method initEntry = jLibrary.getDeclaredMethod("InitEntry", Context.class);
                    initEntry.invoke(null, context);
                }
                IdentifyListenerHandler handler = new IdentifyListenerHandler();
                Method initSDK = midSDKHelper.getDeclaredMethod("InitSdk", Context.class, Boolean.TYPE, identifyListener);
                int errCode = (Integer)initSDK.invoke(null, context, true, Proxy.newProxyInstance(context.getClassLoader(), new Class[]{identifyListener}, (InvocationHandler)handler));
                TapLogger.logd(TAG, "MdidSdkHelper ResultCode : " + errCode);
                if (errCode != 1008614 && errCode != 1008610) {
                    OaidHelper.getOAIDReflect(context, --retryCount);
                    if (retryCount == 0) {
                        countDownLatch.countDown();
                    }
                    return;
                }
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        countDownLatch.countDown();
                    }
                }).start();
            }
            catch (Throwable ex) {
                TapLogger.loge(TAG, null, ex);
                OaidHelper.getOAIDReflect(context, --retryCount);
                if (retryCount != 0) break block6;
                countDownLatch.countDown();
            }
        }
    }

    private static void initInvokeListener() {
        try {
            midSDKHelper = Class.forName("com.bun.miitmdid.core.MdidSdkHelper");
        }
        catch (Throwable e) {
            TapLogger.loge(TAG, null, e);
            return;
        }
        try {
            loadCertMethod = midSDKHelper.getMethod("InitCert", Context.class, String.class);
        }
        catch (NoSuchMethodException e) {
            TapLogger.logd(TAG, "TapDB don't need load cert");
        }
        try {
            identifyListener = Class.forName("com.bun.miitmdid.interfaces.IIdentifierListener");
            idSupplier = Class.forName("com.bun.miitmdid.interfaces.IdSupplier");
            return;
        }
        catch (Exception exception) {
            try {
                identifyListener = Class.forName("com.bun.supplier.IIdentifierListener");
                idSupplier = Class.forName("com.bun.supplier.IdSupplier");
                jLibrary = Class.forName("com.bun.miitmdid.core.JLibrary");
                return;
            }
            catch (Exception exception2) {
                try {
                    identifyListener = Class.forName("com.bun.miitmdid.core.IIdentifierListener");
                    idSupplier = Class.forName("com.bun.miitmdid.supplier.IdSupplier");
                    jLibrary = Class.forName("com.bun.miitmdid.core.JLibrary");
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                return;
            }
        }
    }

    public static String loadPemFromAssetFile(Context context) {
        try {
            String line;
            String assetFileName = context.getPackageName() + ".cert.pem";
            InputStream is = context.getAssets().open(assetFileName);
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            StringBuilder builder = new StringBuilder();
            while ((line = in.readLine()) != null) {
                builder.append(line);
                builder.append('\n');
            }
            return builder.toString();
        }
        catch (Exception e) {
            TapLogger.logd(TAG, "loadPemFromAssetFile failed");
            return "";
        }
    }

    public static void setCertString(String cert) {
        certString = cert;
    }

    static {
        loadCertMethod = null;
        hasInit = false;
        certString = null;
    }

    static class IdentifyListenerHandler
    implements InvocationHandler {
        IdentifyListenerHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                if ("OnSupport".equals(method.getName())) {
                    if (((Boolean)args[0]).booleanValue()) {
                        Method getOAID = idSupplier.getDeclaredMethod("getOAID", new Class[0]);
                        OAID = (String)getOAID.invoke(args[1], new Object[0]);
                        TapLogger.logd(OaidHelper.TAG, "oaid:" + OAID);
                    }
                    countDownLatch.countDown();
                } else if ("onSupport".equals(method.getName())) {
                    Method getOAID = idSupplier.getDeclaredMethod("getOAID", new Class[0]);
                    OAID = (String)getOAID.invoke(args[0], new Object[0]);
                    TapLogger.logd(OaidHelper.TAG, "oaid:" + OAID);
                    countDownLatch.countDown();
                }
            }
            catch (Throwable ex) {
                TapLogger.loge(OaidHelper.TAG, null, ex);
                countDownLatch.countDown();
            }
            return null;
        }
    }
}

