/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.kit.internal.identifier.content;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcel;
import android.os.RemoteException;
import android.support.annotation.WorkerThread;
import com.taptap.sdk.kit.internal.TapLogger;
import com.taptap.sdk.kit.internal.TapTapKit;
import com.taptap.sdk.kit.internal.identifier.TapIdentifierUtil;
import com.taptap.sdk.kit.internal.identifier.content.TapGAIDUtil;
import com.taptap.sdk.kit.internal.utils.TapReflectionUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002\u0019\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\n\u0010\u0014\u001a\u0004\u0018\u00010\bH\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001c\u0010\u0017\u001a\u00020\u000e2\u0014\u0010\u0018\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\u000e0\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000e0\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/taptap/sdk/kit/internal/identifier/content/TapGAIDUtil;", "", "()V", "CONNECTION_RESULT_SUCCESS", "", "TAG", "", "gaid", "Lcom/taptap/sdk/kit/internal/identifier/TapIdentifierUtil$GAID;", "isQuerying", "Ljava/util/concurrent/atomic/AtomicBoolean;", "waitingList", "", "Lkotlin/Function1;", "", "getAndroidId", "context", "Landroid/content/Context;", "getAndroidIdViaReflection", "getAndroidIdViaService", "getGAID", "isGooglePlayServicesAvailable", "", "queryGAID", "callback", "GoogleAdInfo", "GoogleAdServiceConnection", "tap-kit_release"})
public final class TapGAIDUtil {
    @NotNull
    public static final TapGAIDUtil INSTANCE = new TapGAIDUtil();
    @NotNull
    private static final String TAG = "TapGAIDUtil";
    private static final int CONNECTION_RESULT_SUCCESS = 0;
    @Nullable
    private static TapIdentifierUtil.GAID gaid;
    @NotNull
    private static List<Function1<TapIdentifierUtil.GAID, Unit>> waitingList;
    @NotNull
    private static AtomicBoolean isQuerying;

    private TapGAIDUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void queryGAID(@NotNull Function1<? super TapIdentifierUtil.GAID, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        TapGAIDUtil tapGAIDUtil = this;
        synchronized (tapGAIDUtil) {
            boolean bl = false;
            if (gaid != null) {
                callback.invoke((Object)gaid);
                return;
            }
            waitingList.add(callback);
            if (isQuerying.get()) {
                return;
            }
            isQuerying.set(true);
            Unit unit = Unit.INSTANCE;
        }
        ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ TapGAIDUtil this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                TapIdentifierUtil.GAID advertisingId = TapGAIDUtil.access$getAndroidId(TapGAIDUtil.INSTANCE, TapTapKit.INSTANCE.getContext());
                new Handler(Looper.getMainLooper()).post(() -> queryGAID.2.invoke$lambda$2(this.this$0, advertisingId));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static final void invoke$lambda$2(TapGAIDUtil this$0, TapIdentifierUtil.GAID $advertisingId) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$advertisingId, (String)"$advertisingId");
                TapGAIDUtil tapGAIDUtil = this$0;
                synchronized (tapGAIDUtil) {
                    boolean bl = false;
                    TapGAIDUtil.access$setGaid$p($advertisingId);
                    Iterable $this$forEach$iv = TapGAIDUtil.access$getWaitingList$p();
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Function1 callback = (Function1)element$iv;
                        boolean bl2 = false;
                        callback.invoke((Object)$advertisingId);
                    }
                    TapGAIDUtil.access$getWaitingList$p().clear();
                    TapGAIDUtil.access$isQuerying$p().set(false);
                    Unit unit = Unit.INSTANCE;
                }
            }
        }), (int)31, null);
    }

    @WorkerThread
    @Nullable
    public final TapIdentifierUtil.GAID getGAID() {
        if (gaid != null) {
            return gaid;
        }
        return this.getAndroidId(TapTapKit.INSTANCE.getContext());
    }

    private final TapIdentifierUtil.GAID getAndroidId(Context context) {
        TapIdentifierUtil.GAID identifiers = this.getAndroidIdViaReflection(context);
        if (identifiers == null && (identifiers = this.getAndroidIdViaService(context)) == null) {
            identifiers = new TapIdentifierUtil.GAID(null, false, 3, null);
        }
        return identifiers;
    }

    private final boolean isGooglePlayServicesAvailable(Context context) {
        Object[] objectArray = new Class[]{Context.class};
        Method method = TapReflectionUtil.getMethodQuietly("com.google.android.gms.common.GooglePlayServicesUtil", "isGooglePlayServicesAvailable", objectArray);
        if (method == null) {
            return false;
        }
        Method method2 = method;
        objectArray = new Object[]{context};
        Object connectionResult = TapReflectionUtil.invokeMethodQuietly(null, method2, objectArray);
        return connectionResult instanceof Integer && Intrinsics.areEqual((Object)connectionResult, (Object)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TapIdentifierUtil.GAID getAndroidIdViaService(Context context) {
        boolean bl;
        GoogleAdServiceConnection connection = new GoogleAdServiceConnection();
        Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
        intent.setPackage("com.google.android.gms");
        try {
            bl = context.bindService(intent, (ServiceConnection)connection, 1);
        }
        catch (SecurityException _) {
            return null;
        }
        boolean isBindServiceSucceed = bl;
        if (isBindServiceSucceed) {
            try {
                GoogleAdInfo adInfo = new GoogleAdInfo(connection.getBinder());
                TapIdentifierUtil.GAID identifiers = new TapIdentifierUtil.GAID(null, false, 3, null);
                identifiers.setAndroidAdvertiserIdValue(adInfo.getAdvertiserId());
                identifiers.setTrackingLimited(adInfo.isTrackingLimited());
                TapIdentifierUtil.GAID gAID = identifiers;
                return gAID;
            }
            catch (Exception exception) {
                TapLogger.loge(TAG, "getAndroidIdViaService", exception);
            }
            finally {
                context.unbindService((ServiceConnection)connection);
            }
        }
        return null;
    }

    private final TapIdentifierUtil.GAID getAndroidIdViaReflection(Context context) {
        try {
            if (!this.isGooglePlayServicesAvailable(context)) {
                return null;
            }
            Class[] classArray = new Class[]{Context.class};
            Method method = TapReflectionUtil.getMethodQuietly("com.google.android.gms.ads.identifier.AdvertisingIdClient", "getAdvertisingIdInfo", classArray);
            if (method == null) {
                return null;
            }
            Method getAdvertisingIdInfo = method;
            Object[] objectArray = new Object[]{context};
            Object object = TapReflectionUtil.invokeMethodQuietly(null, getAdvertisingIdInfo, objectArray);
            if (object == null) {
                return null;
            }
            Object advertisingInfo = object;
            Method getId = TapReflectionUtil.getMethodQuietly(advertisingInfo.getClass(), "getId", new Class[0]);
            Method isLimitAdTrackingEnabled = TapReflectionUtil.getMethodQuietly(advertisingInfo.getClass(), "isLimitAdTrackingEnabled", new Class[0]);
            if (getId == null || isLimitAdTrackingEnabled == null) {
                return null;
            }
            TapIdentifierUtil.GAID identifiers = new TapIdentifierUtil.GAID(null, false, 3, null);
            identifiers.setAndroidAdvertiserIdValue((String)TapReflectionUtil.invokeMethodQuietly(advertisingInfo, getId, new Object[0]));
            Boolean bl = (Boolean)TapReflectionUtil.invokeMethodQuietly(advertisingInfo, isLimitAdTrackingEnabled, new Object[0]);
            identifiers.setTrackingLimited(bl != null ? bl : false);
            return identifiers;
        }
        catch (Exception e) {
            TapLogger.loge(TAG, "getAndroidIdViaReflection", e);
            return null;
        }
    }

    public static final /* synthetic */ TapIdentifierUtil.GAID access$getAndroidId(TapGAIDUtil $this, Context context) {
        return $this.getAndroidId(context);
    }

    public static final /* synthetic */ void access$setGaid$p(TapIdentifierUtil.GAID gAID) {
        gaid = gAID;
    }

    public static final /* synthetic */ List access$getWaitingList$p() {
        return waitingList;
    }

    public static final /* synthetic */ AtomicBoolean access$isQuerying$p() {
        return isQuerying;
    }

    static {
        waitingList = new ArrayList();
        isQuerying = new AtomicBoolean(false);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0016J\u0012\u0010\u0010\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/taptap/sdk/kit/internal/identifier/content/TapGAIDUtil$GoogleAdServiceConnection;", "Landroid/content/ServiceConnection;", "()V", "binder", "Landroid/os/IBinder;", "getBinder", "()Landroid/os/IBinder;", "consumed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "queue", "Ljava/util/concurrent/BlockingQueue;", "onServiceConnected", "", "name", "Landroid/content/ComponentName;", "service", "onServiceDisconnected", "tap-kit_release"})
    private static final class GoogleAdServiceConnection
    implements ServiceConnection {
        @NotNull
        private final AtomicBoolean consumed = new AtomicBoolean(false);
        @NotNull
        private final BlockingQueue<IBinder> queue = new LinkedBlockingDeque();

        public void onServiceConnected(@Nullable ComponentName name, @Nullable IBinder service) {
            try {
                if (service != null) {
                    this.queue.put(service);
                }
            }
            catch (InterruptedException e) {
                TapLogger.loge(TapGAIDUtil.TAG, "onServiceConnected", e);
            }
        }

        public void onServiceDisconnected(@Nullable ComponentName name) {
        }

        @NotNull
        public final IBinder getBinder() throws InterruptedException {
            if (!(!this.consumed.compareAndSet(true, true))) {
                boolean bl = false;
                String string = "Binder already consumed";
                throw new IllegalStateException(string.toString());
            }
            IBinder iBinder = this.queue.take();
            Intrinsics.checkNotNullExpressionValue((Object)iBinder, (String)"queue.take()");
            return iBinder;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\u0003H\u0016R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/taptap/sdk/kit/internal/identifier/content/TapGAIDUtil$GoogleAdInfo;", "Landroid/os/IInterface;", "binder", "Landroid/os/IBinder;", "(Landroid/os/IBinder;)V", "advertiserId", "", "getAdvertiserId", "()Ljava/lang/String;", "isTrackingLimited", "", "()Z", "asBinder", "Companion", "tap-kit_release"})
    private static final class GoogleAdInfo
    implements IInterface {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final IBinder binder;
        private static final int FIRST_TRANSACTION_CODE = 1;
        private static final int SECOND_TRANSACTION_CODE = 2;

        public GoogleAdInfo(@NotNull IBinder binder) {
            Intrinsics.checkNotNullParameter((Object)binder, (String)"binder");
            this.binder = binder;
        }

        @NotNull
        public IBinder asBinder() {
            return this.binder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final String getAdvertiserId() throws RemoteException {
            String string;
            Parcel parcel = Parcel.obtain();
            Intrinsics.checkNotNullExpressionValue((Object)parcel, (String)"obtain()");
            Parcel data = parcel;
            Parcel parcel2 = Parcel.obtain();
            Intrinsics.checkNotNullExpressionValue((Object)parcel2, (String)"obtain()");
            Parcel reply = parcel2;
            try {
                data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                this.binder.transact(1, data, reply, 0);
                reply.readException();
                string = reply.readString();
            }
            finally {
                reply.recycle();
                data.recycle();
            }
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean isTrackingLimited() throws RemoteException {
            boolean bl;
            Parcel parcel = Parcel.obtain();
            Intrinsics.checkNotNullExpressionValue((Object)parcel, (String)"obtain()");
            Parcel data = parcel;
            Parcel parcel2 = Parcel.obtain();
            Intrinsics.checkNotNullExpressionValue((Object)parcel2, (String)"obtain()");
            Parcel reply = parcel2;
            try {
                data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                data.writeInt(1);
                this.binder.transact(2, data, reply, 0);
                reply.readException();
                bl = reply.readInt() != 0;
            }
            finally {
                reply.recycle();
                data.recycle();
            }
            return bl;
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/taptap/sdk/kit/internal/identifier/content/TapGAIDUtil$GoogleAdInfo$Companion;", "", "()V", "FIRST_TRANSACTION_CODE", "", "SECOND_TRANSACTION_CODE", "tap-kit_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

