/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.kit.internal.net;

import android.os.Build;
import android.util.Base64;
import com.taptap.sdk.kit.internal.TapTapKit;
import com.taptap.sdk.kit.internal.net.TapSignatureGenerator;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/taptap/sdk/kit/internal/net/TapSignatureGenerator;", "", "()V", "Companion", "tap-kit_release"})
public final class TapSignatureGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J9\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\nH\u0000\u00a2\u0006\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/taptap/sdk/kit/internal/net/TapSignatureGenerator$Companion;", "", "()V", "generateSHA256Signature", "", "url", "method", "body", "", "headers", "", "generateSHA256Signature$tap_kit_release", "tap-kit_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String generateSHA256Signature$tap_kit_release(@NotNull String url, @NotNull String method, @NotNull byte[] body, @NotNull Map<String, String> headers) {
            String string;
            String clientToken;
            String it;
            void $this$filterKeys$iv;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            URL urlObj = new URL(url);
            String pathAndQuery = urlObj.getPath() + (urlObj.getQuery() != null ? '?' + urlObj.getQuery() : "");
            Map<String, String> map = headers;
            boolean $i$f$filterKeys = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                it = (String)entry$iv.getKey();
                boolean bl = false;
                String string2 = it.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                if (!StringsKt.startsWith$default((String)string2, (String)"x-tap-", (boolean)false, (int)2, null)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            Iterable $this$sortedBy$iv = ((Map)result$iv).entrySet();
            boolean $i$f$sortedBy = false;
            String filteredHeaders2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)a;
                    boolean bl = false;
                    String string = ((String)it.getKey()).toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    it = (Map.Entry)b;
                    Comparable comparable = (Comparable)((Object)string);
                    bl = false;
                    String string2 = ((String)it.getKey()).toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string2)));
                }
            }), (CharSequence)"\n", null, null, (int)0, null, (Function1)generateSHA256Signature.filteredHeaders.3.INSTANCE, (int)30, null);
            String bodyString = new String(body, Charsets.UTF_8);
            String stringToSign = method + '\n' + pathAndQuery + '\n' + filteredHeaders2 + '\n' + bodyString + '\n';
            Mac hmacSha256 = Mac.getInstance("HmacSHA256");
            it = clientToken = TapTapKit.INSTANCE.getClientToken$tap_kit_release();
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = it.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            SecretKeySpec secretKey = new SecretKeySpec(byArray, "HmacSHA256");
            hmacSha256.init(secretKey);
            String string3 = stringToSign;
            Charset charset2 = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"UTF_8");
            byte[] byArray2 = string3.getBytes(charset2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
            byte[] signatureBytes = hmacSha256.doFinal(byArray2);
            if (Build.VERSION.SDK_INT >= 26) {
                String string4 = java.util.Base64.getEncoder().encodeToString(signatureBytes);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"{\n                // And\u2026atureBytes)\n            }");
            } else {
                String string5 = Base64.encodeToString((byte[])signatureBytes, (int)2);
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"{\n                // \u4f4e\u4e8eA\u202664.NO_WRAP)\n            }");
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

