/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.kit.internal.net.impl;

import android.net.Uri;
import android.support.annotation.WorkerThread;
import com.taptap.sdk.kit.internal.TapLogger;
import com.taptap.sdk.kit.internal.TapTapKit;
import com.taptap.sdk.kit.internal.bean.TapHttpResponse;
import com.taptap.sdk.kit.internal.bean.TapHttpResponseError;
import com.taptap.sdk.kit.internal.exception.TapHttpRequestException;
import com.taptap.sdk.kit.internal.executor.TapNetExecutor;
import com.taptap.sdk.kit.internal.json.TapJson;
import com.taptap.sdk.kit.internal.net.ITapApi;
import com.taptap.sdk.kit.internal.net.TapHttpRequest;
import com.taptap.sdk.kit.internal.net.TapSdkHttp;
import com.taptap.sdk.kit.internal.net.TapSignatureGenerator;
import com.taptap.sdk.kit.internal.net.TapTime;
import com.taptap.sdk.kit.internal.net.backoff.TapBackOff;
import com.taptap.sdk.kit.internal.utils.PlatformXUA;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.random.Random;
import kotlin.reflect.KType;
import kotlin.text.Charsets;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J<\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\fj\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006`\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0003J6\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0003J*\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0003J<\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J,\u0010\"\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\fj\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006`\r2\u0006\u0010\u000f\u001a\u00020\u0006H\u0003J\u0010\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0004H\u0003J*\u0010%\u001a\u00020\u001b2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010)2\b\u0010 \u001a\u0004\u0018\u00010!H\u0003J\u001a\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020,2\b\u0010 \u001a\u0004\u0018\u00010!H\u0003J<\u0010-\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J<\u0010.\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0003JF\u0010/\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\b\u0002\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/taptap/sdk/kit/internal/net/impl/TapDefaultApi;", "Lcom/taptap/sdk/kit/internal/net/ITapApi;", "()V", "CONNECT_TIMEOUT", "", "METHOD_GET", "", "METHOD_POST", "RANDOM_NONCE_LENGTH", "READ_TIMEOUT", "TAG", "buildHeaders", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "url", "method", "bodyByteArray", "", "buildRequest", "Lcom/taptap/sdk/kit/internal/net/TapHttpRequest;", "headers", "buildUrl", "host", "path", "params", "Lorg/json/JSONObject;", "get", "", "delay", "", "backoff", "Lcom/taptap/sdk/kit/internal/net/backoff/TapBackOff;", "callback", "Lcom/taptap/sdk/kit/internal/net/TapSdkHttp$HttpCallBack;", "getCommonHeaders", "getRandomString", "length", "onResponseFailure", "responseError", "Lcom/taptap/sdk/kit/internal/bean/TapHttpResponseError;", "throwable", "", "onResponseSuccess", "response", "Lcom/taptap/sdk/kit/internal/bean/TapHttpResponse;", "post", "request", "scheduleRequest", "tap-kit_release"})
public final class TapDefaultApi
implements ITapApi {
    @NotNull
    public static final TapDefaultApi INSTANCE = new TapDefaultApi();
    @NotNull
    private static final String TAG = "TapSdkHttpDefault";
    @NotNull
    private static final String METHOD_POST = "POST";
    @NotNull
    private static final String METHOD_GET = "GET";
    private static final int RANDOM_NONCE_LENGTH = 10;
    private static final int READ_TIMEOUT = 10000;
    private static final int CONNECT_TIMEOUT = 10000;

    private TapDefaultApi() {
    }

    @Override
    public void get(@NotNull String host, @NotNull String path, @Nullable JSONObject params, long delay, @NotNull TapBackOff backoff, @Nullable TapSdkHttp.HttpCallBack callback) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)backoff, (String)"backoff");
        TapLogger.logd(TAG, "get, host = " + host + " , path = " + path + " , params = " + params + " , delay = " + delay + " , backoff = " + backoff);
        this.scheduleRequest(host, path, METHOD_GET, params, delay, backoff, callback);
    }

    @Override
    public void post(@NotNull String host, @NotNull String path, @Nullable JSONObject params, long delay, @NotNull TapBackOff backoff, @Nullable TapSdkHttp.HttpCallBack callback) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)backoff, (String)"backoff");
        TapLogger.logd(TAG, "post, host = " + host + " , path = " + path + " , params = " + params + " , delay = " + delay + " , backoff = " + backoff);
        this.scheduleRequest(host, path, METHOD_POST, params, delay, backoff, callback);
    }

    private final void scheduleRequest(String host, String path, String method, JSONObject params, long delay, TapBackOff backoff, TapSdkHttp.HttpCallBack callback) {
        if (delay > 0L) {
            TapLogger.logd(TAG, "request[" + path + "] schedule delay = " + delay);
            TapNetExecutor.getScheduledExecutor().schedule(() -> TapDefaultApi.scheduleRequest$lambda$1(host, path, method, params, backoff, callback), delay, TimeUnit.MILLISECONDS);
        } else {
            TapLogger.logd(TAG, "request[" + path + "] execute");
            TapNetExecutor.getExecutor().execute(() -> TapDefaultApi.scheduleRequest$lambda$2(host, path, method, params, backoff, callback));
        }
    }

    static /* synthetic */ void scheduleRequest$default(TapDefaultApi tapDefaultApi, String string, String string2, String string3, JSONObject jSONObject, long l, TapBackOff tapBackOff, TapSdkHttp.HttpCallBack httpCallBack, int n, Object object) {
        if ((n & 0x10) != 0) {
            l = 0L;
        }
        tapDefaultApi.scheduleRequest(string, string2, string3, jSONObject, l, tapBackOff, httpCallBack);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private final void request(String host, String path, String method, JSONObject params, TapBackOff backoff, TapSdkHttp.HttpCallBack callback) {
        Object object;
        String url;
        block85: {
            block83: {
                block84: {
                    url = this.buildUrl(host, path, method, params);
                    if (!Intrinsics.areEqual((Object)method, (Object)METHOD_POST)) break block83;
                    object = params;
                    if (object == null || (object = object.toString()) == null) break block84;
                    byte[] byArray = object.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                    object = byArray;
                    if (byArray != null) break block85;
                }
                object = new byte[0];
                break block85;
            }
            object = new byte[0];
        }
        Object object2 = object;
        HashMap<String, String> headers = this.buildHeaders(url, method, (byte[])object2);
        TapLogger.logd(TAG, "request[" + method + "][" + path + "] start\nurl = " + url + "\nheaders = " + headers + "\nbody = " + params);
        TapHttpRequest request = null;
        try {
            request = this.buildRequest(method, url, headers, (byte[])object2);
            if (request == null) {
                TapDefaultApi.onResponseFailure$default(this, null, new TapHttpRequestException("Build Request Failure."), callback, 1, null);
                return;
            }
            int code = request.code();
            String body = request.body();
            TapLogger.logd(TAG, "response[" + method + "][" + path + "] code = " + code + " , body = \n" + body);
            int n = code;
            boolean bl = 200 <= n ? n < 300 : false;
            if (bl) {
                TapHttpResponse httpResponse = null;
                try {
                    Object object3;
                    TapJson this_$iv = TapJson.INSTANCE;
                    boolean $i$f$decodeFromString = false;
                    CharSequence charSequence = body;
                    if (charSequence == null || charSequence.length() == 0) {
                        object3 = null;
                    } else {
                        try {
                            StringFormat $this$decodeFromString$iv$iv = (StringFormat)this_$iv.getJson();
                            boolean $i$f$decodeFromString2 = false;
                            SerializersModule $this$serializer$iv$iv$iv = $this$decodeFromString$iv$iv.getSerializersModule();
                            boolean $i$f$serializer = false;
                            KSerializer $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv, (KType)Reflection.typeOf(TapHttpResponse.class));
                            boolean $i$f$cast = false;
                            Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
                            object3 = $this$decodeFromString$iv$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv$iv, body);
                        }
                        catch (Exception e$iv) {
                            TapLogger.loge$default("TapJson", null, e$iv, 2, null);
                            object3 = null;
                        }
                    }
                    httpResponse = (TapHttpResponse)object3;
                }
                catch (Exception e) {
                    TapLogger.logd(TAG, e);
                }
                if (httpResponse == null) {
                    TapDefaultApi.onResponseFailure$default(this, null, new TapHttpRequestException("Failed to parse data by deserialization."), callback, 1, null);
                    return;
                }
                if (httpResponse.getSuccess()) {
                    TapTime.INSTANCE.fixInvalidTime(httpResponse.getNow());
                    this.onResponseSuccess(httpResponse, callback);
                    return;
                }
                try {
                    Object object4;
                    TapJson $i$f$decodeFromString = TapJson.INSTANCE;
                    JsonElement data$iv = (JsonElement)httpResponse.getData();
                    boolean $i$f$decodeFromJsonElement = false;
                    try {
                        if (data$iv == null) {
                            object4 = null;
                        } else {
                            void this_$iv;
                            Json $this$decodeFromJsonElement$iv$iv = this_$iv.getJson();
                            boolean $i$f$decodeFromJsonElement2 = false;
                            SerializersModule $this$serializer$iv$iv$iv = $this$decodeFromJsonElement$iv$iv.getSerializersModule();
                            boolean $i$f$serializer = false;
                            KSerializer $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv, (KType)Reflection.typeOf(TapHttpResponseError.class));
                            boolean $i$f$cast = false;
                            Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
                            object4 = $this$decodeFromJsonElement$iv$iv.decodeFromJsonElement((DeserializationStrategy)$this$cast$iv$iv$iv$iv, data$iv);
                        }
                    }
                    catch (Exception e$iv) {
                        TapLogger.loge$default("TapJson", null, e$iv, 2, null);
                        object4 = null;
                    }
                    TapHttpResponseError responseError = (TapHttpResponseError)object4;
                    TapDefaultApi.onResponseFailure$default(this, responseError, null, callback, 2, null);
                    return;
                }
                catch (Exception e) {
                    TapLogger.logd(TAG, e);
                    TapDefaultApi.onResponseFailure$default(this, null, new TapHttpRequestException("Failed to parse data by deserialization."), callback, 1, null);
                    return;
                }
            }
            boolean bl2 = 500 <= n ? n < 600 : false;
            if (bl2) {
                long nextBackoffMillis = backoff.nextBackoffMillis();
                if (nextBackoffMillis >= 0L) {
                    this.scheduleRequest(host, path, method, params, nextBackoffMillis, backoff, callback);
                    return;
                }
                TapHttpResponseError responseError = null;
                try {
                    Object object5;
                    Object object6;
                    TapJson this_$iv = TapJson.INSTANCE;
                    boolean $i$f$decodeFromString = false;
                    CharSequence $i$f$decodeFromJsonElement2 = body;
                    if ($i$f$decodeFromJsonElement2 == null || $i$f$decodeFromJsonElement2.length() == 0) {
                        object6 = null;
                    } else {
                        try {
                            StringFormat $this$decodeFromString$iv$iv = (StringFormat)this_$iv.getJson();
                            boolean $i$f$decodeFromString3 = false;
                            SerializersModule $this$serializer$iv$iv$iv = $this$decodeFromString$iv$iv.getSerializersModule();
                            boolean $i$f$serializer = false;
                            KSerializer $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv, (KType)Reflection.typeOf(TapHttpResponse.class));
                            boolean $i$f$cast = false;
                            Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
                            object6 = $this$decodeFromString$iv$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv$iv, body);
                        }
                        catch (Exception e$iv) {
                            TapLogger.loge$default("TapJson", null, e$iv, 2, null);
                            object6 = null;
                        }
                    }
                    TapHttpResponse httpResponse = (TapHttpResponse)object6;
                    this_$iv = TapJson.INSTANCE;
                    TapHttpResponse tapHttpResponse = httpResponse;
                    JsonElement data$iv = (JsonElement)(tapHttpResponse != null ? tapHttpResponse.getData() : null);
                    boolean $i$f$decodeFromJsonElement22 = false;
                    try {
                        if (data$iv == null) {
                            object5 = null;
                        } else {
                            Json $this$decodeFromJsonElement$iv$iv = this_$iv.getJson();
                            boolean $i$f$decodeFromJsonElement = false;
                            SerializersModule $this$serializer$iv$iv$iv = $this$decodeFromJsonElement$iv$iv.getSerializersModule();
                            boolean $i$f$serializer = false;
                            KSerializer $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv, (KType)Reflection.typeOf(TapHttpResponseError.class));
                            boolean $i$f$cast = false;
                            Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
                            object5 = $this$decodeFromJsonElement$iv$iv.decodeFromJsonElement((DeserializationStrategy)$this$cast$iv$iv$iv$iv, data$iv);
                        }
                    }
                    catch (Exception e$iv) {
                        TapLogger.loge$default("TapJson", null, e$iv, 2, null);
                        object5 = null;
                    }
                    responseError = (TapHttpResponseError)object5;
                }
                catch (Exception e) {
                    TapLogger.logd(TAG, e);
                }
                if (responseError == null) {
                    responseError = new TapHttpResponseError((Integer)code, null, "error_local", body, 2, null);
                }
                TapDefaultApi.onResponseFailure$default(this, responseError, null, callback, 2, null);
                return;
            }
            TapHttpResponseError responseError = null;
            TapHttpResponse httpResponse = null;
            try {
                Object object7;
                Object object8;
                TapJson this_$iv = TapJson.INSTANCE;
                boolean $i$f$decodeFromString = false;
                CharSequence this_$iv2 = body;
                if (this_$iv2 == null || this_$iv2.length() == 0) {
                    object8 = null;
                } else {
                    try {
                        StringFormat $this$decodeFromString$iv$iv = (StringFormat)this_$iv.getJson();
                        boolean $i$f$decodeFromString4 = false;
                        SerializersModule $this$serializer$iv$iv$iv = $this$decodeFromString$iv$iv.getSerializersModule();
                        boolean $i$f$serializer = false;
                        KSerializer $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv, (KType)Reflection.typeOf(TapHttpResponse.class));
                        boolean $i$f$cast = false;
                        Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
                        object8 = $this$decodeFromString$iv$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv$iv, body);
                    }
                    catch (Exception e$iv) {
                        TapLogger.loge$default("TapJson", null, e$iv, 2, null);
                        object8 = null;
                    }
                }
                httpResponse = (TapHttpResponse)object8;
                this_$iv = TapJson.INSTANCE;
                TapHttpResponse tapHttpResponse = httpResponse;
                JsonElement data$iv = (JsonElement)(tapHttpResponse != null ? tapHttpResponse.getData() : null);
                boolean $i$f$decodeFromJsonElement = false;
                try {
                    if (data$iv == null) {
                        object7 = null;
                    } else {
                        Json $this$decodeFromJsonElement$iv$iv = this_$iv.getJson();
                        boolean $i$f$decodeFromJsonElement3 = false;
                        SerializersModule $this$serializer$iv$iv$iv = $this$decodeFromJsonElement$iv$iv.getSerializersModule();
                        boolean $i$f$serializer = false;
                        KSerializer $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv, (KType)Reflection.typeOf(TapHttpResponseError.class));
                        boolean $i$f$cast = false;
                        Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
                        object7 = $this$decodeFromJsonElement$iv$iv.decodeFromJsonElement((DeserializationStrategy)$this$cast$iv$iv$iv$iv, data$iv);
                    }
                }
                catch (Exception e$iv) {
                    TapLogger.loge$default("TapJson", null, e$iv, 2, null);
                    object7 = null;
                }
                responseError = (TapHttpResponseError)object7;
            }
            catch (Exception e) {
                TapLogger.logd(TAG, e);
            }
            if (responseError == null) {
                responseError = new TapHttpResponseError((Integer)code, null, "error_local", body, 2, null);
            }
            if ((e = responseError.getError()) != null) {
                int n2 = -1;
                switch (e.hashCode()) {
                    case -332453906: {
                        if (!e.equals("unsupported_response_type")) break;
                        n2 = 1;
                        break;
                    }
                    case -847806252: {
                        if (!e.equals("invalid_grant")) break;
                        n2 = 1;
                        break;
                    }
                    case 621497807: {
                        if (!e.equals("user_is_deactivated")) break;
                        n2 = 1;
                        break;
                    }
                    case 58425439: {
                        if (!e.equals("unsupported_secret_type")) break;
                        n2 = 1;
                        break;
                    }
                    case -825004428: {
                        if (!e.equals("error_local")) break;
                        n2 = 2;
                        break;
                    }
                    case 1503566841: {
                        if (!e.equals("forbidden")) break;
                        n2 = 1;
                        break;
                    }
                    case -632018157: {
                        if (!e.equals("invalid_client")) break;
                        n2 = 1;
                        break;
                    }
                    case 100231633: {
                        if (!e.equals("too_many_login_attempts")) break;
                        n2 = 1;
                        break;
                    }
                    case -2054838772: {
                        if (!e.equals("server_error")) break;
                        n2 = 3;
                        break;
                    }
                    case -444618026: {
                        if (!e.equals("access_denied")) break;
                        n2 = 4;
                        break;
                    }
                    case 772475936: {
                        if (!e.equals("slow_down")) break;
                        n2 = 1;
                        break;
                    }
                    case 469711028: {
                        if (!e.equals("invalid_credentials")) break;
                        n2 = 1;
                        break;
                    }
                    case -750855631: {
                        if (!e.equals("captcha.failed")) break;
                        n2 = 1;
                        break;
                    }
                    case -450628909: {
                        if (!e.equals("replay_attacks")) break;
                        n2 = 1;
                        break;
                    }
                    case -432359895: {
                        if (!e.equals("captcha.needs")) break;
                        n2 = 1;
                        break;
                    }
                    case 2117379143: {
                        if (!e.equals("invalid_request")) break;
                        n2 = 1;
                        break;
                    }
                    case -1916631087: {
                        if (!e.equals("authorization_pending")) break;
                        n2 = 1;
                        break;
                    }
                    case -190904121: {
                        if (!e.equals("unsupported_grant_type")) break;
                        n2 = 1;
                        break;
                    }
                    case 527219733: {
                        if (!e.equals("invalid_time")) break;
                        n2 = 5;
                        break;
                    }
                    case 1615526678: {
                        if (!e.equals("not_found")) break;
                        n2 = 1;
                        break;
                    }
                }
                switch (n2) {
                    case 2: {
                        TapDefaultApi.onResponseFailure$default(this, responseError, null, callback, 2, null);
                        return;
                    }
                    case 1: {
                        TapDefaultApi.onResponseFailure$default(this, responseError, null, callback, 2, null);
                        return;
                    }
                    case 5: {
                        TapHttpResponse tapHttpResponse = httpResponse;
                        TapTime.INSTANCE.fixInvalidTime(tapHttpResponse != null ? tapHttpResponse.getNow() : null);
                        if (backoff.canInvalidTimeRetry()) {
                            this.scheduleRequest(host, path, method, params, 0L, backoff, callback);
                            return;
                        }
                        TapDefaultApi.onResponseFailure$default(this, responseError, null, callback, 2, null);
                        return;
                    }
                    case 3: {
                        long nextBackoffMillis = backoff.nextBackoffMillis();
                        if (nextBackoffMillis >= 0L) {
                            this.scheduleRequest(host, path, method, params, nextBackoffMillis, backoff, callback);
                            return;
                        }
                        TapDefaultApi.onResponseFailure$default(this, responseError, null, callback, 2, null);
                        return;
                    }
                    case 4: {
                        TapDefaultApi.onResponseFailure$default(this, responseError, null, callback, 2, null);
                        return;
                    }
                }
            }
            TapDefaultApi.onResponseFailure$default(this, responseError, null, callback, 2, null);
            return;
        }
        catch (Throwable e) {
            Throwable throwable;
            Throwable cause = null;
            cause = e;
            if (e instanceof TapHttpRequest.HttpRequestException) {
                IOException iOException = ((TapHttpRequest.HttpRequestException)e).getCause();
                if (iOException != null) {
                    IOException it = iOException;
                    boolean bl = false;
                    cause = ((TapHttpRequest.HttpRequestException)e).getCause();
                }
            }
            if ((throwable = cause) instanceof UnknownHostException ? true : throwable instanceof SocketTimeoutException) {
                long nextBackoffMillis = backoff.nextBackoffMillis();
                if (nextBackoffMillis >= 0L) {
                    this.scheduleRequest(host, path, method, params, nextBackoffMillis, backoff, callback);
                    return;
                }
                TapLogger.logd(TAG, e);
                TapDefaultApi.onResponseFailure$default(this, null, e, callback, 1, null);
                return;
            }
            TapLogger.logd(TAG, e);
            TapDefaultApi.onResponseFailure$default(this, null, e, callback, 1, null);
        }
    }

    @WorkerThread
    private final void onResponseSuccess(TapHttpResponse response, TapSdkHttp.HttpCallBack callback) {
        block0: {
            TapSdkHttp.HttpCallBack httpCallBack = callback;
            if (httpCallBack == null) break block0;
            TapSdkHttp.HttpCallBack it = httpCallBack;
            boolean bl = false;
            TapNetExecutor.uiThread().execute(() -> TapDefaultApi.onResponseSuccess$lambda$5$lambda$4(it, response));
        }
    }

    @WorkerThread
    private final void onResponseFailure(TapHttpResponseError responseError, Throwable throwable, TapSdkHttp.HttpCallBack callback) {
        block0: {
            TapSdkHttp.HttpCallBack httpCallBack = callback;
            if (httpCallBack == null) break block0;
            TapSdkHttp.HttpCallBack it = httpCallBack;
            boolean bl = false;
            TapNetExecutor.uiThread().execute(() -> TapDefaultApi.onResponseFailure$lambda$7$lambda$6(it, responseError, throwable));
        }
    }

    static /* synthetic */ void onResponseFailure$default(TapDefaultApi tapDefaultApi, TapHttpResponseError tapHttpResponseError, Throwable throwable, TapSdkHttp.HttpCallBack httpCallBack, int n, Object object) {
        if ((n & 1) != 0) {
            tapHttpResponseError = null;
        }
        if ((n & 2) != 0) {
            throwable = null;
        }
        tapDefaultApi.onResponseFailure(tapHttpResponseError, throwable, httpCallBack);
    }

    @WorkerThread
    private final HashMap<String, String> buildHeaders(String url, String method, byte[] bodyByteArray) {
        HashMap<String, String> headers = this.getCommonHeaders(method);
        String signature = TapSignatureGenerator.Companion.generateSHA256Signature$tap_kit_release(url, method, bodyByteArray, (Map<String, String>)headers);
        ((Map)headers).put("X-Tap-Sign", signature);
        return headers;
    }

    @WorkerThread
    private final String buildUrl(String host, String path, String method, JSONObject params) {
        Uri.Builder uriBuilder = new Uri.Builder().scheme("https").authority(host).path(path);
        uriBuilder.appendQueryParameter("client_id", TapTapKit.INSTANCE.getClientId$tap_kit_release());
        if (Intrinsics.areEqual((Object)method, (Object)METHOD_GET)) {
            JSONObject jSONObject = params;
            Iterator keys = jSONObject != null ? jSONObject.keys() : null;
            while (true) {
                Iterator iterator = keys;
                boolean bl = iterator != null ? iterator.hasNext() : false;
                if (!bl) break;
                String key = (String)keys.next();
                String value = params.get(key).toString();
                uriBuilder.appendQueryParameter(key, value);
            }
        }
        Uri uri = uriBuilder.build();
        String string = uri.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri.toString()");
        return string;
    }

    @WorkerThread
    private final TapHttpRequest buildRequest(String method, String url, HashMap<String, String> headers, byte[] bodyByteArray) {
        TapHttpRequest request;
        block2: {
            String string = method;
            request = Intrinsics.areEqual((Object)string, (Object)METHOD_GET) ? TapHttpRequest.get(url) : (Intrinsics.areEqual((Object)string, (Object)METHOD_POST) ? TapHttpRequest.post(url) : null);
            TapHttpRequest tapHttpRequest = request;
            if (tapHttpRequest != null && (tapHttpRequest = tapHttpRequest.headers((Map<String, String>)headers)) != null && (tapHttpRequest = tapHttpRequest.readTimeout(10000)) != null) {
                tapHttpRequest.connectTimeout(10000);
            }
            if (!Intrinsics.areEqual((Object)method, (Object)METHOD_POST)) break block2;
            TapHttpRequest tapHttpRequest2 = request;
            if (tapHttpRequest2 != null) {
                tapHttpRequest2.send(bodyByteArray);
            }
        }
        return request;
    }

    @WorkerThread
    private final HashMap<String, String> getCommonHeaders(String method) {
        Object object = new Pair[]{TuplesKt.to((Object)"X-Tap-Ts", (Object)String.valueOf(TapTime.INSTANCE.getCurrentTimeInMillis() / (long)1000)), TuplesKt.to((Object)"X-Tap-Nonce", (Object)this.getRandomString(10)), TuplesKt.to((Object)"User-Agent", (Object)PlatformXUA.INSTANCE.getTrackUA())};
        HashMap map = MapsKt.hashMapOf((Pair[])object);
        object = method;
        if (Intrinsics.areEqual((Object)object, (Object)METHOD_GET)) {
            ((Map)map).put("Content-Type", "text/plain; charset=utf-8");
        } else if (Intrinsics.areEqual((Object)object, (Object)METHOD_POST)) {
            ((Map)map).put("Content-Type", "application/json");
        }
        return map;
    }

    @WorkerThread
    private final String getRandomString(int length) {
        String base = "abcdefghijklmnopqrstuvwxyz0123456789";
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = Random.Default.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    private static final void scheduleRequest$lambda$1$lambda$0(String $host, String $path, String $method, JSONObject $params, TapBackOff $backoff, TapSdkHttp.HttpCallBack $callback) {
        Intrinsics.checkNotNullParameter((Object)$host, (String)"$host");
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        Intrinsics.checkNotNullParameter((Object)$method, (String)"$method");
        Intrinsics.checkNotNullParameter((Object)$backoff, (String)"$backoff");
        INSTANCE.request($host, $path, $method, $params, $backoff, $callback);
    }

    private static final void scheduleRequest$lambda$1(String $host, String $path, String $method, JSONObject $params, TapBackOff $backoff, TapSdkHttp.HttpCallBack $callback) {
        Intrinsics.checkNotNullParameter((Object)$host, (String)"$host");
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        Intrinsics.checkNotNullParameter((Object)$method, (String)"$method");
        Intrinsics.checkNotNullParameter((Object)$backoff, (String)"$backoff");
        TapNetExecutor.getExecutor().execute(() -> TapDefaultApi.scheduleRequest$lambda$1$lambda$0($host, $path, $method, $params, $backoff, $callback));
    }

    private static final void scheduleRequest$lambda$2(String $host, String $path, String $method, JSONObject $params, TapBackOff $backoff, TapSdkHttp.HttpCallBack $callback) {
        Intrinsics.checkNotNullParameter((Object)$host, (String)"$host");
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        Intrinsics.checkNotNullParameter((Object)$method, (String)"$method");
        Intrinsics.checkNotNullParameter((Object)$backoff, (String)"$backoff");
        INSTANCE.request($host, $path, $method, $params, $backoff, $callback);
    }

    private static final void onResponseSuccess$lambda$5$lambda$4(TapSdkHttp.HttpCallBack $it, TapHttpResponse $response) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Intrinsics.checkNotNullParameter((Object)$response, (String)"$response");
        JsonObject jsonObject = $response.getData();
        if (jsonObject == null) {
            jsonObject = new JsonObject(MapsKt.emptyMap());
        }
        $it.onSuccess(jsonObject);
    }

    private static final void onResponseFailure$lambda$7$lambda$6(TapSdkHttp.HttpCallBack $it, TapHttpResponseError $responseError, Throwable $throwable) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        $it.onError($responseError, $throwable);
    }
}

