/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.kit.internal.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0004\u0018\u00010\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0007JC\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\f\u001a\u00020\b2\u001e\u0010\r\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00060\u000e\"\b\u0012\u0002\b\u0003\u0018\u00010\u0006H\u0007\u00a2\u0006\u0002\u0010\u000fJ?\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u001e\u0010\r\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00060\u000e\"\b\u0012\u0002\b\u0003\u0018\u00010\u0006H\u0007\u00a2\u0006\u0002\u0010\u0010J9\u0010\u0011\u001a\u0004\u0018\u00010\u00012\b\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0013\u001a\u00020\u000b2\u0016\u0010\u0014\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000e\"\u0004\u0018\u00010\u0001H\u0007\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/taptap/sdk/kit/internal/utils/TapReflectionUtil;", "", "()V", "getFieldQuietly", "Ljava/lang/reflect/Field;", "clazz", "Ljava/lang/Class;", "fieldName", "", "className", "getMethodQuietly", "Ljava/lang/reflect/Method;", "methodName", "parameterTypes", "", "(Ljava/lang/Class;Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", "invokeMethodQuietly", "receiver", "method", "args", "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", "tap-kit_release"})
public final class TapReflectionUtil {
    @NotNull
    public static final TapReflectionUtil INSTANCE = new TapReflectionUtil();

    private TapReflectionUtil() {
    }

    @JvmStatic
    @Nullable
    public static final Field getFieldQuietly(@NotNull String className, @NotNull String fieldName) {
        Field field;
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        try {
            Class<?> clazz = Class.forName(className);
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"clazz");
            field = TapReflectionUtil.getFieldQuietly(clazz, fieldName);
        }
        catch (Exception ex) {
            field = null;
        }
        return field;
    }

    @JvmStatic
    @Nullable
    public static final Field getFieldQuietly(@NotNull Class<?> clazz, @NotNull String fieldName) {
        Field field;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        try {
            field = clazz.getField(fieldName);
        }
        catch (Exception ex) {
            field = null;
        }
        return field;
    }

    @JvmStatic
    @Nullable
    public static final Method getMethodQuietly(@NotNull Class<?> clazz, @NotNull String methodName, Class<?> ... parameterTypes) {
        Method method;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter(parameterTypes, (String)"parameterTypes");
        try {
            method = clazz.getMethod(methodName, Arrays.copyOf(parameterTypes, parameterTypes.length));
        }
        catch (NoSuchMethodException ex) {
            method = null;
        }
        return method;
    }

    @JvmStatic
    @Nullable
    public static final Method getMethodQuietly(@NotNull String className, @NotNull String methodName, Class<?> ... parameterTypes) {
        Method method;
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter(parameterTypes, (String)"parameterTypes");
        try {
            Class<?> clazz = Class.forName(className);
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"clazz");
            method = TapReflectionUtil.getMethodQuietly(clazz, methodName, Arrays.copyOf(parameterTypes, parameterTypes.length));
        }
        catch (ClassNotFoundException ex) {
            method = null;
        }
        return method;
    }

    @JvmStatic
    @Nullable
    public static final Object invokeMethodQuietly(@Nullable Object receiver, @NotNull Method method, Object ... args) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        try {
            object = method.invoke(receiver, Arrays.copyOf(args, args.length));
        }
        catch (IllegalAccessException ex) {
            object = null;
        }
        catch (InvocationTargetException ex) {
            object = null;
        }
        return object;
    }
}

