/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.kit.internal.utils.localize;

import android.content.Context;
import android.text.TextUtils;
import com.taptap.sdk.kit.internal.utils.DeviceUtils;
import com.taptap.sdk.kit.internal.utils.FileUtils;
import com.taptap.sdk.kit.internal.utils.localize.LocalizeStore;
import com.taptap.sdk.kit.internal.utils.localize.TapLanguage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public class LocalizeManager {
    private static final Map<String, LocalizeStore> localizeCache = new HashMap<String, LocalizeStore>();
    private static TapLanguage gameSelectedLang = TapLanguage.AUTO;
    public static final Set<String> supportedLangSet = new HashSet<String>();
    public static final Set<TapLanguage> supportedLangTypeSet = new HashSet<TapLanguage>();
    public static final Map<String, TapLanguage> supportedLangMap = new HashMap<String, TapLanguage>();
    public static final Map<TapLanguage, String> supportedLangStringMap = new HashMap<TapLanguage, String>();
    private static boolean isDomestic;

    public static boolean isLangSupport(String lang) {
        return supportedLangSet.contains(lang);
    }

    @Deprecated
    public static LocalizeStore getLocalizeStore(String sdkName) {
        LocalizeStore store = localizeCache.get(sdkName);
        if (store == null) {
            throw new IllegalStateException("please config localizestore(" + sdkName + ") first");
        }
        store.setPreferredLang(LocalizeManager.getPreferredLang());
        return store;
    }

    public static void configSDKLocalizeWith(int regionType) {
        isDomestic = regionType == 0;
    }

    public static void configSDKLocalize(String name, JSONObject dict, boolean domestic) {
        if (dict == null) {
            return;
        }
        LocalizeStore store = new LocalizeStore(dict, domestic);
        localizeCache.put(name, store);
        isDomestic = domestic;
    }

    public static void configSconfigSDKLocalizeDKLocalize(String name, Context context, String assetsFileName, boolean domestic) {
        JSONObject dict = null;
        try {
            String dictStr = FileUtils.loadAssetTextAsString(context, assetsFileName);
            dict = new JSONObject(dictStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LocalizeManager.configSDKLocalize(name, dict, domestic);
    }

    public static TapLanguage getPreferredLang() {
        if (gameSelectedLang != TapLanguage.AUTO) {
            return gameSelectedLang;
        }
        String curLanguageDisplayName = DeviceUtils.getCurLanguageDisplayName();
        if (!TextUtils.isEmpty((CharSequence)curLanguageDisplayName)) {
            if (curLanguageDisplayName.startsWith("zh")) {
                String displayLowCase = curLanguageDisplayName.toLowerCase(Locale.US);
                if (displayLowCase.contains("hant")) {
                    return TapLanguage.ZH_HANT;
                }
                if (displayLowCase.contains("hans")) {
                    return TapLanguage.ZH_HANS;
                }
                if (!displayLowCase.contains("cn")) {
                    return TapLanguage.ZH_HANT;
                }
                return TapLanguage.ZH_HANS;
            }
            if (curLanguageDisplayName.startsWith("en")) {
                return TapLanguage.EN;
            }
            if (curLanguageDisplayName.startsWith("ja")) {
                return TapLanguage.JA;
            }
            if (curLanguageDisplayName.startsWith("ko")) {
                return TapLanguage.KO;
            }
            if (curLanguageDisplayName.startsWith("th")) {
                return TapLanguage.TH;
            }
            if (curLanguageDisplayName.startsWith("id") || curLanguageDisplayName.startsWith("in")) {
                return TapLanguage.ID;
            }
            if (curLanguageDisplayName.startsWith("de")) {
                return TapLanguage.DE;
            }
            if (curLanguageDisplayName.startsWith("es")) {
                return TapLanguage.ES;
            }
            if (curLanguageDisplayName.startsWith("fr")) {
                return TapLanguage.FR;
            }
            if (curLanguageDisplayName.startsWith("pt")) {
                return TapLanguage.PT;
            }
            if (curLanguageDisplayName.startsWith("ru")) {
                return TapLanguage.RU;
            }
            if (curLanguageDisplayName.startsWith("tr")) {
                return TapLanguage.TR;
            }
            if (curLanguageDisplayName.startsWith("vi")) {
                return TapLanguage.VI;
            }
        }
        return isDomestic ? TapLanguage.ZH_HANS : TapLanguage.EN;
    }

    public static TapLanguage getGameSelectedLang() {
        return gameSelectedLang;
    }

    public static Locale getLocale(TapLanguage languageType) {
        switch (languageType) {
            case ZH_HANS: {
                return Locale.CHINA;
            }
            case EN: {
                return Locale.US;
            }
            case ZH_HANT: {
                return Locale.TRADITIONAL_CHINESE;
            }
            case JA: {
                return Locale.JAPAN;
            }
            case KO: {
                return Locale.KOREA;
            }
            case TH: {
                return new Locale("th");
            }
            case ID: {
                return new Locale("in");
            }
            case DE: {
                return Locale.GERMANY;
            }
            case ES: {
                return new Locale("es");
            }
            case FR: {
                return Locale.FRANCE;
            }
            case PT: {
                return new Locale("pt");
            }
            case RU: {
                return new Locale("ru");
            }
            case TR: {
                return new Locale("tr");
            }
            case VI: {
                return new Locale("vi");
            }
        }
        return LocalizeManager.getDefaultLocaleByDomestic();
    }

    public static Locale getDefaultLocaleByDomestic() {
        return isDomestic ? Locale.CHINA : Locale.US;
    }

    public static String getPreferredLanguageString() {
        return supportedLangStringMap.get((Object)LocalizeManager.getPreferredLang());
    }

    static {
        supportedLangSet.addAll(Arrays.asList("zh_hans", "zh_hant", "en", "ja", "ko", "th", "id", "de", "es", "fr", "pt", "ru", "tr", "vi"));
        supportedLangTypeSet.addAll(Arrays.asList(TapLanguage.AUTO, TapLanguage.ZH_HANS, TapLanguage.EN, TapLanguage.ZH_HANT, TapLanguage.JA, TapLanguage.KO, TapLanguage.TH, TapLanguage.ID, TapLanguage.DE, TapLanguage.ES, TapLanguage.FR, TapLanguage.PT, TapLanguage.RU, TapLanguage.TR, TapLanguage.VI));
        supportedLangMap.put("zh_hans", TapLanguage.ZH_HANS);
        supportedLangMap.put("en", TapLanguage.EN);
        supportedLangMap.put("zh_hant", TapLanguage.ZH_HANT);
        supportedLangMap.put("ja", TapLanguage.JA);
        supportedLangMap.put("ko", TapLanguage.KO);
        supportedLangMap.put("th", TapLanguage.TH);
        supportedLangMap.put("id", TapLanguage.ID);
        supportedLangMap.put("de", TapLanguage.DE);
        supportedLangMap.put("es", TapLanguage.ES);
        supportedLangMap.put("fr", TapLanguage.FR);
        supportedLangMap.put("pt", TapLanguage.PT);
        supportedLangMap.put("ru", TapLanguage.RU);
        supportedLangMap.put("tr", TapLanguage.TR);
        supportedLangMap.put("vi", TapLanguage.VI);
        supportedLangStringMap.put(TapLanguage.ZH_HANS, "zh_CN");
        supportedLangStringMap.put(TapLanguage.EN, "en_US");
        supportedLangStringMap.put(TapLanguage.ZH_HANT, "zh_TW");
        supportedLangStringMap.put(TapLanguage.JA, "ja_JP");
        supportedLangStringMap.put(TapLanguage.KO, "ko_KR");
        supportedLangStringMap.put(TapLanguage.TH, "th_TH");
        supportedLangStringMap.put(TapLanguage.ID, "id_ID");
        supportedLangStringMap.put(TapLanguage.DE, "de_DE");
        supportedLangStringMap.put(TapLanguage.ES, "es_ES");
        supportedLangStringMap.put(TapLanguage.FR, "fr_FR");
        supportedLangStringMap.put(TapLanguage.PT, "pt_PT");
        supportedLangStringMap.put(TapLanguage.RU, "ru_RU");
        supportedLangStringMap.put(TapLanguage.TR, "tr_TR");
        supportedLangStringMap.put(TapLanguage.VI, "vi_VN");
        isDomestic = true;
    }
}

