/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.kit.internal.utils.localize;

import com.taptap.sdk.kit.internal.TapLogger;
import com.taptap.sdk.kit.internal.utils.localize.LocalizeManager;
import com.taptap.sdk.kit.internal.utils.localize.TapLanguage;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class LocalizeStore {
    private static final String TAG = "LocalizeStore";
    private final HashMap<TapLanguage, JSONObject> langDictSparseArray = new HashMap();
    private TapLanguage preferredLang = TapLanguage.AUTO;
    private boolean isDomestic;

    private LocalizeStore() {
    }

    void setPreferredLang(TapLanguage lang) {
        this.preferredLang = lang;
    }

    public LocalizeStore(JSONObject dict, boolean domestic) {
        for (Map.Entry<String, TapLanguage> entry : LocalizeManager.supportedLangMap.entrySet()) {
            try {
                this.langDictSparseArray.put(entry.getValue(), dict.getJSONObject(entry.getKey()));
            }
            catch (JSONException jsonException) {
                TapLogger.logd(TAG, jsonException);
            }
        }
        this.isDomestic = domestic;
    }

    public String getStringValue(String resId) {
        try {
            TapLanguage lang = this.preferredLang;
            JSONObject dict = this.langDictSparseArray.get((Object)lang);
            if (dict == null) {
                TapLanguage tapLanguage = lang = this.isDomestic ? TapLanguage.ZH_HANS : TapLanguage.EN;
            }
            if ((dict = this.langDictSparseArray.get((Object)lang)) == null) {
                return "";
            }
            return dict.getString(resId);
        }
        catch (Exception jsonException) {
            return "";
        }
    }
}

