/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.kit.internal.identifier;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import com.taptap.sdk.kit.internal.TapLogger;
import com.taptap.sdk.kit.internal.identifier.TapIdentifierUtil;
import com.taptap.sdk.kit.internal.utils.CryptoUtils;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;

class DataUtils {
    private static final String TAG = "DataUtils";
    private static final String ENCODE_PREFIX = "_encode_identify_prefix_";

    DataUtils() {
    }

    private static String handleSecurityData(Context context, String key, String data) {
        if (TextUtils.isEmpty((CharSequence)data) || TextUtils.isEmpty((CharSequence)key)) {
            return data;
        }
        CryptoUtils utils = CryptoUtils.getInstance(context);
        if (utils != null) {
            if (data.startsWith(ENCODE_PREFIX)) {
                return utils.aesDecrypt(data.substring(ENCODE_PREFIX.length()));
            }
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
            sharedPreferences.edit().putString(key, ENCODE_PREFIX + utils.aesEncrypt(data)).apply();
            return data;
        }
        TapLogger.logd(TAG, " data should be decrypt but util is null");
        return data.startsWith(ENCODE_PREFIX) ? "" : data;
    }

    public static String getDeviceId(Context context) {
        String KEY = "tapdb_game_mobile_identify";
        String MATCHER = "__game_mobile__0__";
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        String identify = null;
        if (null != sharedPreferences) {
            try {
                identify = sharedPreferences.getString("tapdb_game_mobile_identify", null);
                if (identify != null) {
                    return DataUtils.handleSecurityData(context, "tapdb_game_mobile_identify", identify);
                }
            }
            catch (ClassCastException e) {
                e.printStackTrace();
            }
            Map all = sharedPreferences.getAll();
            String oldKey = null;
            for (String s : all.keySet()) {
                if (!s.contains("__game_mobile__0__")) continue;
                oldKey = s;
                identify = (String)all.get(s);
                break;
            }
            if (identify != null) {
                return DataUtils.handleSecurityData(context, oldKey, identify);
            }
        }
        if (identify == null) {
            identify = DataUtils.getTapDBId(TapIdentifierUtil.getAndroidID(context));
            if (TextUtils.isEmpty((CharSequence)identify) || identify.length() > 256) {
                identify = null;
            } else {
                return DataUtils.handleSecurityData(context, "tapdb_game_mobile_identify", identify);
            }
        }
        if (identify == null && !TextUtils.isEmpty((CharSequence)(identify = UUID.randomUUID().toString())) && identify.length() <= 256) {
            return DataUtils.handleSecurityData(context, "tapdb_game_mobile_identify", identify);
        }
        return null;
    }

    private static String getTapDBId(String androidId) {
        String ANID_REGEX = "^[0-9a-zA-Z]{8,16}$";
        int ANID_LENGTH = 16;
        String[] ANIDS_EXCLUDED = new String[]{"0000000000000000", "ffffffffffffffff"};
        if (null != androidId) {
            if (!androidId.matches("^[0-9a-zA-Z]{8,16}$")) {
                androidId = null;
            } else {
                int length = androidId.length();
                if (length < 16) {
                    for (int i = 0; i < 16 - length; ++i) {
                        androidId = "0" + androidId;
                    }
                }
                if (Arrays.asList(ANIDS_EXCLUDED).contains(androidId)) {
                    androidId = null;
                }
            }
        }
        return androidId != null ? androidId : UUID.randomUUID().toString();
    }
}

