/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.kit.internal.service;

import android.content.Context;
import com.google.auto.service.AutoService;
import com.taptap.sdk.kit.ITapTapOptionsInternal;
import com.taptap.sdk.kit.TapTapSdkBaseOptions;
import com.taptap.sdk.kit.internal.TapTapKit;
import com.taptap.sdk.kit.internal.identifier.TapIdentifierUtil;
import com.taptap.sdk.kit.internal.service.ITapAutoService;
import com.taptap.sdk.kit.internal.service.TapTapServices;
import com.taptap.sdk.kit.internal.store.TapDataMemoryStorage;
import com.taptap.sdk.kit.internal.utils.PlatformXUA;
import com.taptap.sdk.kit.internal.utils.localize.TapLocalizeUtil;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\b0\rH\u0016J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lcom/taptap/sdk/kit/internal/service/TapKitService;", "Lcom/taptap/sdk/kit/internal/service/ITapAutoService;", "()V", "moduleName", "", "getModuleName", "()Ljava/lang/String;", "execute", "", "context", "Landroid/content/Context;", "methodName", "parameters", "", "init", "", "baseOptions", "Lcom/taptap/sdk/kit/TapTapSdkBaseOptions;", "options", "Lcom/taptap/sdk/kit/ITapTapOptionsInternal;", "parseOptionFromString", "optionString", "Companion", "tap-kit_release"})
@AutoService(value={ITapAutoService.class})
public final class TapKitService
implements ITapAutoService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String moduleName;
    @NotNull
    private static final String METHOD_SET_OPEN_ID = "setOpenId";
    @NotNull
    private static final String METHOD_SET_GAME_USER_ID = "setGameUserId";
    @NotNull
    private static final String METHOD_DATA_MEMORY_PUT = "dataMemoryPut";
    @NotNull
    private static final String METHOD_DATA_MEMORY_GET = "dataMemoryGet";
    @NotNull
    private static final String METHOD_SET_USER_AGENT = "setUserAgent";
    @NotNull
    private static final String METHOD_SET_PREFERRED_LANGUAGE = "setPreferredLanguage";

    public TapKitService() {
        this.moduleName = "TapTapKit";
    }

    @Override
    @NotNull
    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public boolean init(@NotNull Context context, @NotNull TapTapSdkBaseOptions baseOptions, @Nullable ITapTapOptionsInternal options) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)baseOptions, (String)"baseOptions");
        ITapAutoService.DefaultImpls.init(this, context, baseOptions, options);
        TapLocalizeUtil.INSTANCE.initialize$tap_kit_release(baseOptions.getRegionType(), baseOptions.getPreferredLanguage());
        return true;
    }

    @Override
    @Nullable
    public Object execute(@NotNull Context context, @NotNull String methodName, @NotNull Map<String, ? extends Object> parameters) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        ITapAutoService.DefaultImpls.execute(this, context, methodName, parameters);
        switch (methodName) {
            case "setPreferredLanguage": {
                Object object = parameters.get("language");
                String string = object instanceof String ? (String)object : null;
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    TapLocalizeUtil.INSTANCE.setPreferredLanguage(it);
                }
                break;
            }
            case "dataMemoryPut": {
                Object object = parameters.get("key");
                String key = object instanceof String ? (String)object : null;
                Object object2 = parameters.get("value");
                String value = object2 instanceof String ? (String)object2 : null;
                object2 = key;
                if (object2 == null || object2.length() == 0) break;
                TapDataMemoryStorage.INSTANCE.put(key, value);
                return Unit.INSTANCE;
            }
            case "dataMemoryGet": {
                Object value = parameters.get("key");
                String key = value instanceof String ? (String)value : null;
                value = key;
                if (value == null || value.length() == 0) break;
                return TapDataMemoryStorage.INSTANCE.get(key);
            }
            case "setGameUserId": {
                Object value = parameters.get("gameUserId");
                String gameUserId = value instanceof String ? (String)value : null;
                TapIdentifierUtil.INSTANCE.setGameUserId$tap_kit_release(gameUserId);
                value = TapTapServices.INSTANCE.find("TapTapHeartbeat");
                if (value == null) break;
                value.execute(TapTapKit.INSTANCE.getContext(), METHOD_SET_GAME_USER_ID, MapsKt.mapOf((Pair)TuplesKt.to((Object)"gameUserId", (Object)gameUserId)));
                break;
            }
            case "setOpenId": {
                Object value = parameters.get("openId");
                String openId = value instanceof String ? (String)value : null;
                TapIdentifierUtil.INSTANCE.setOpenId$tap_kit_release(openId);
                value = openId;
                if (value == null || value.length() == 0) {
                    value = TapTapServices.INSTANCE.find("TapTapHeartbeat");
                    if (value == null) break;
                    value.execute(TapTapKit.INSTANCE.getContext(), "logout", MapsKt.emptyMap());
                    break;
                }
                value = TapTapServices.INSTANCE.find("TapTapHeartbeat");
                if (value == null) break;
                value.execute(TapTapKit.INSTANCE.getContext(), "login", MapsKt.mapOf((Pair)TuplesKt.to((Object)"openId", (Object)openId)));
                break;
            }
            case "setUserAgent": {
                Object value = parameters.get("key");
                String key = value instanceof String ? (String)value : null;
                Object object = parameters.get("value");
                value = object instanceof String ? (String)object : null;
                object = key;
                if (object == null || object.length() == 0 || (object = (CharSequence)value) == null || object.length() == 0) break;
                PlatformXUA.addUAInner$tap_kit_release(key, (String)value);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public ITapTapOptionsInternal parseOptionFromString(@NotNull String optionString) {
        Intrinsics.checkNotNullParameter((Object)optionString, (String)"optionString");
        return null;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/taptap/sdk/kit/internal/service/TapKitService$Companion;", "", "()V", "METHOD_DATA_MEMORY_GET", "", "METHOD_DATA_MEMORY_PUT", "METHOD_SET_GAME_USER_ID", "METHOD_SET_OPEN_ID", "METHOD_SET_PREFERRED_LANGUAGE", "METHOD_SET_USER_AGENT", "tap-kit_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

