/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.kit.internal.store;

import android.content.Context;
import android.support.annotation.WorkerThread;
import com.taptap.sdk.kit.internal.TapLogger;
import com.taptap.sdk.kit.internal.store.ITapData;
import com.taptap.sdk.kit.internal.store.TapDataStore;
import com.taptap.sdk.kit.internal.utils.TapOpenlogHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000 \"*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003:\u0001\"B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0017\u0010\u0016\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0017\u001a\u00028\u0000H\u0007\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u0006\u0010\u001d\u001a\u00020\tJ\u0018\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001f2\b\b\u0002\u0010 \u001a\u00020\tH\u0007J\b\u0010!\u001a\u00020\u001aH\u0003R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006#"}, d2={"Lcom/taptap/sdk/kit/internal/store/TapDataStore;", "T", "Lcom/taptap/sdk/kit/internal/store/ITapData;", "", "context", "Landroid/content/Context;", "storeFileName", "", "maxAccumulatedData", "", "mapSize", "", "(Landroid/content/Context;Ljava/lang/String;IJ)V", "accumulatedData", "Ljava/util/concurrent/CopyOnWriteArrayList;", "inFlightData", "getMapSize", "()J", "mappedByteBuffer", "Ljava/nio/MappedByteBuffer;", "getMaxAccumulatedData", "()I", "addData", "data", "(Lcom/taptap/sdk/kit/internal/store/ITapData;)Lcom/taptap/sdk/kit/internal/store/ITapData;", "clearInFlightAndStats", "", "moveToAccumulated", "", "getAccumulatedDataCount", "obtainData", "", "maxCount", "syncData", "Companion", "tap-kit_release"})
public final class TapDataStore<T extends ITapData<T>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxAccumulatedData;
    private final long mapSize;
    @Nullable
    private MappedByteBuffer mappedByteBuffer;
    @NotNull
    private CopyOnWriteArrayList<T> accumulatedData;
    @NotNull
    private final CopyOnWriteArrayList<T> inFlightData;
    @NotNull
    private static final String TAG = "TapDataStore";

    public TapDataStore(@NotNull Context context, @NotNull String storeFileName, int maxAccumulatedData, long mapSize) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storeFileName, (String)"storeFileName");
        this.maxAccumulatedData = maxAccumulatedData;
        this.mapSize = mapSize;
        this.accumulatedData = new CopyOnWriteArrayList();
        this.inFlightData = new CopyOnWriteArrayList();
        TapLogger.logd(TAG, "initialize start");
        File file = new File(context.getFilesDir(), storeFileName);
        if (!file.exists()) {
            file.createNewFile();
        }
        RandomAccessFile fileOutputStream = new RandomAccessFile(file, "rw");
        FileChannel fileChannel = fileOutputStream.getChannel();
        MappedByteBuffer map = null;
        try {
            FileChannel fileChannel2 = fileChannel;
            map = fileChannel2 != null ? fileChannel2.map(FileChannel.MapMode.READ_WRITE, 0L, this.mapSize) : null;
        }
        catch (Exception e) {
            TapLogger.logd(TAG, e);
        }
        if (map == null) {
            TapLogger.loge$default(TAG, "initialize failure MappedByteBuffer = null", null, 4, null);
        } else {
            List events = CollectionsKt.emptyList();
            try {
                int remaining = map.remaining();
                byte[] arr = new byte[remaining];
                map.get(arr);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(arr);
                ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
                Object object = objectInputStream.readObject();
                List list = object instanceof List ? (List)object : null;
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                events = list;
            }
            catch (Exception e) {
                TapLogger.logd(TAG, "If this is the first time you start, you can ignore this error message.", e);
            }
            this.accumulatedData.addAll(CollectionsKt.distinct((Iterable)events));
            this.mappedByteBuffer = map;
        }
        TapLogger.logd(TAG, "initialize end accumulatedData.size = " + this.accumulatedData.size());
    }

    public final int getMaxAccumulatedData() {
        return this.maxAccumulatedData;
    }

    public final long getMapSize() {
        return this.mapSize;
    }

    public final int getAccumulatedDataCount() {
        return this.accumulatedData.size();
    }

    @WorkerThread
    @Nullable
    public final T addData(@NotNull T data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        ITapData removed = null;
        if (this.accumulatedData.size() + this.inFlightData.size() >= this.maxAccumulatedData) {
            removed = (ITapData)CollectionsKt.removeFirst((List)this.accumulatedData);
        }
        this.accumulatedData.add(data);
        this.syncData();
        return (T)removed;
    }

    @WorkerThread
    @NotNull
    public final List<T> obtainData(int maxCount) {
        if (this.accumulatedData.size() > maxCount) {
            List<T> list = this.accumulatedData.subList(0, maxCount);
            Intrinsics.checkNotNullExpressionValue(list, (String)"accumulatedData.subList(0, maxCount)");
            List<T> tapEvents = list;
            this.inFlightData.addAll((Collection)tapEvents);
            this.accumulatedData.removeAll((Collection)tapEvents);
        } else {
            this.inFlightData.addAll((Collection)this.accumulatedData);
            this.accumulatedData.clear();
        }
        this.syncData();
        return this.inFlightData;
    }

    public static /* synthetic */ List obtainData$default(TapDataStore tapDataStore, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 200;
        }
        return tapDataStore.obtainData(n);
    }

    @WorkerThread
    public final void clearInFlightAndStats(boolean moveToAccumulated) {
        if (moveToAccumulated) {
            this.accumulatedData.addAll((Collection)this.inFlightData);
            List distinctList = CollectionsKt.distinct((Iterable)this.accumulatedData);
            this.accumulatedData.clear();
            this.accumulatedData.addAll(distinctList);
            CollectionsKt.sortWith((List)this.accumulatedData, (arg_0, arg_1) -> TapDataStore.clearInFlightAndStats$lambda$0(clearInFlightAndStats.1.INSTANCE, arg_0, arg_1));
        }
        this.inFlightData.clear();
        this.syncData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private final synchronized void syncData() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Closeable closeable = new ObjectOutputStream(byteArrayOutputStream);
            Throwable throwable = null;
            try {
                ByteBuffer byteBuffer;
                ObjectOutputStream it = (ObjectOutputStream)closeable;
                boolean bl = false;
                it.writeObject(CollectionsKt.toList((Iterable)this.accumulatedData));
                byte[] byteArray = byteArrayOutputStream.toByteArray();
                MappedByteBuffer mappedByteBuffer = this.mappedByteBuffer;
                if (byteArray.length < (mappedByteBuffer != null ? mappedByteBuffer.capacity() : 0)) {
                    MappedByteBuffer mappedByteBuffer2 = this.mappedByteBuffer;
                    if (mappedByteBuffer2 != null) {
                        mappedByteBuffer2.clear();
                    }
                    MappedByteBuffer mappedByteBuffer3 = this.mappedByteBuffer;
                    byteBuffer = mappedByteBuffer3 != null ? mappedByteBuffer3.put(byteArray) : null;
                } else {
                    TapOpenlogHelper.INSTANCE.reportTechnicalLog("store_not_enough_space", (Function0<? extends Map<String, String>>)((Function0)new Function0<Map<String, ? extends String>>(this, byteArray){
                        final /* synthetic */ TapDataStore<T> this$0;
                        final /* synthetic */ byte[] $byteArray;
                        {
                            this.this$0 = $receiver;
                            this.$byteArray = $byteArray;
                            super(0);
                        }

                        @NotNull
                        public final Map<String, String> invoke() {
                            Pair[] pairArray = new Pair[2];
                            MappedByteBuffer mappedByteBuffer = TapDataStore.access$getMappedByteBuffer$p(this.this$0);
                            pairArray[0] = TuplesKt.to((Object)"capacity", (Object)String.valueOf(mappedByteBuffer != null ? Integer.valueOf(mappedByteBuffer.capacity()) : null));
                            pairArray[1] = TuplesKt.to((Object)"byteArray", (Object)String.valueOf(this.$byteArray.length));
                            return MapsKt.mapOf((Pair[])pairArray);
                        }
                    }));
                    MappedByteBuffer mappedByteBuffer4 = this.mappedByteBuffer;
                    TapLogger.logd(TAG, "syncData failure Not enough space\uff0c capacity = " + (mappedByteBuffer4 != null ? Integer.valueOf(mappedByteBuffer4.capacity()) : null) + ", byteArray = " + byteArray.length);
                    byteBuffer = Unit.INSTANCE;
                }
                ByteBuffer byteBuffer2 = byteBuffer;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            TapLogger.logd(TAG, e);
        }
    }

    private static final int clearInFlightAndStats$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    public static final /* synthetic */ MappedByteBuffer access$getMappedByteBuffer$p(TapDataStore $this) {
        return $this.mappedByteBuffer;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/taptap/sdk/kit/internal/store/TapDataStore$Companion;", "", "()V", "TAG", "", "tap-kit_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

