/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.kit.internal.identifier;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Process;
import android.provider.Settings;
import android.support.annotation.WorkerThread;
import com.taptap.sdk.kit.internal.identifier.DataUtils;
import com.taptap.sdk.kit.internal.identifier.TapIdentifierUtil;
import com.taptap.sdk.kit.internal.identifier.content.TapGAIDUtil;
import com.taptap.sdk.kit.internal.identifier.content.TapGIDUtil;
import com.taptap.sdk.kit.internal.identifier.content.TapGameUserIdUtil;
import com.taptap.sdk.kit.internal.identifier.content.TapOAIDUtil;
import com.taptap.sdk.kit.internal.identifier.content.TapOpenIdUtil;
import java.security.MessageDigest;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001+B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u0014J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007J\b\u0010\u0018\u001a\u0004\u0018\u00010\u0004J\u0006\u0010\u0019\u001a\u00020\u0004J\b\u0010\u001a\u001a\u00020\u0004H\u0007J\b\u0010\u001b\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014J\u001c\u0010\u001d\u001a\u00020\u001e2\u0014\u0010\u001f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\u0004\u0012\u00020\u001e0 J\n\u0010!\u001a\u0004\u0018\u00010\u0004H\u0007J\u001c\u0010\"\u001a\u00020\u001e2\u0014\u0010\u001f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u001e0 J\u0017\u0010#\u001a\u00020\u001e2\b\u0010$\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b%J\u0010\u0010&\u001a\u00020\u001e2\b\u0010'\u001a\u0004\u0018\u00010\u0004J\u0017\u0010(\u001a\u00020\u001e2\b\u0010)\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b*R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/taptap/sdk/kit/internal/identifier/TapIdentifierUtil;", "", "()V", "SP_NAME", "", "androidId", "deviceId", "installUUID", "sp", "Landroid/content/SharedPreferences;", "getSp", "()Landroid/content/SharedPreferences;", "sp$delegate", "Lkotlin/Lazy;", "uniqueDeviceId", "bytesToHexString", "src", "", "getAndroidID", "context", "Landroid/content/Context;", "getDeviceId", "getGAID", "Lcom/taptap/sdk/kit/internal/identifier/TapIdentifierUtil$GAID;", "getGameUserId", "getInstallUUID", "getOAID", "getOpenId", "getUniqueDeviceId", "queryGAID", "", "block", "Lkotlin/Function1;", "queryGID", "queryOAID", "setGameUserId", "gameUserId", "setGameUserId$tap_kit_release", "setOAIDCertString", "oaidCert", "setOpenId", "openId", "setOpenId$tap_kit_release", "GAID", "tap-kit_release"})
public final class TapIdentifierUtil {
    @NotNull
    public static final TapIdentifierUtil INSTANCE = new TapIdentifierUtil();
    @NotNull
    private static final String SP_NAME = "TapSdkCore_SP";
    @NotNull
    private static final Lazy sp$delegate = LazyKt.lazy((Function0)sp.2.INSTANCE);
    @Nullable
    private static volatile String androidId;
    @NotNull
    private static volatile String uniqueDeviceId;
    @Nullable
    private static volatile String deviceId;
    @NotNull
    private static volatile String installUUID;

    private TapIdentifierUtil() {
    }

    private final SharedPreferences getSp() {
        Lazy lazy = sp$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-sp>(...)");
        return (SharedPreferences)object;
    }

    @JvmStatic
    @Nullable
    public static final String getAndroidID(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (androidId != null) {
            return androidId;
        }
        try {
            androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return androidId;
    }

    @NotNull
    public final String getUniqueDeviceId(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            if (((CharSequence)uniqueDeviceId).length() > 0) {
                return uniqueDeviceId;
            }
            PackageManager pm = context.getPackageManager();
            String packageName = context.getPackageName();
            PackageInfo packageInfo = pm.getPackageInfo(packageName, 0);
            long firstInstallTime = packageInfo.firstInstallTime;
            int pid = Process.myPid();
            String permitInfo = "" + firstInstallTime + '-' + pid;
            MessageDigest md = MessageDigest.getInstance("MD5");
            StringBuilder stringBuilder = new StringBuilder().append("v1-");
            String string = permitInfo;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            uniqueDeviceId = stringBuilder.append(this.bytesToHexString(md.digest(byArray))).toString();
            return uniqueDeviceId;
        }
        catch (Throwable e) {
            e.printStackTrace();
            uniqueDeviceId = "unknown";
            return uniqueDeviceId;
        }
    }

    @Nullable
    public final String getDeviceId(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (deviceId != null) {
            return deviceId;
        }
        deviceId = DataUtils.getDeviceId(context);
        return deviceId;
    }

    @NotNull
    public final synchronized String getInstallUUID() {
        if (((CharSequence)installUUID).length() > 0) {
            return installUUID;
        }
        String keyName = "tapsdk_install_uuid";
        String uuid = this.getSp().getString(keyName, null);
        CharSequence charSequence = uuid;
        if (!(charSequence == null || charSequence.length() == 0)) {
            installUUID = uuid;
            return uuid;
        }
        uuid = UUID.randomUUID().toString();
        this.getSp().edit().putString(keyName, uuid).apply();
        installUUID = uuid;
        return uuid;
    }

    @WorkerThread
    @Nullable
    public final String queryGID() {
        return TapGIDUtil.INSTANCE.queryGID();
    }

    public final void setOAIDCertString(@Nullable String oaidCert) {
        TapOAIDUtil.INSTANCE.setOAIDCertString(oaidCert);
    }

    public final void queryOAID(@NotNull Function1<? super String, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        TapOAIDUtil.INSTANCE.queryOAID(block);
    }

    @WorkerThread
    @NotNull
    public final String getOAID() {
        return TapOAIDUtil.INSTANCE.getOAID();
    }

    public final void queryGAID(@NotNull Function1<? super GAID, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        TapGAIDUtil.INSTANCE.queryGAID(block);
    }

    @WorkerThread
    @Nullable
    public final GAID getGAID() {
        return TapGAIDUtil.INSTANCE.getGAID();
    }

    @Nullable
    public final String getOpenId() {
        return TapOpenIdUtil.INSTANCE.getOpenId();
    }

    public final void setOpenId$tap_kit_release(@Nullable String openId) {
        TapOpenIdUtil.INSTANCE.setOpenId$tap_kit_release(openId);
    }

    @Nullable
    public final String getGameUserId() {
        return TapGameUserIdUtil.INSTANCE.getGameUserId();
    }

    public final void setGameUserId$tap_kit_release(@Nullable String gameUserId) {
        TapGameUserIdUtil.INSTANCE.setGameUserId$tap_kit_release(gameUserId);
    }

    private final String bytesToHexString(byte[] src) {
        if (src == null || src.length == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder("");
        int n = src.length;
        for (int i = 0; i < n; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    static {
        uniqueDeviceId = "";
        installUUID = "";
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\u0010\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lcom/taptap/sdk/kit/internal/identifier/TapIdentifierUtil$GAID;", "", "androidAdvertiserIdValue", "", "isTrackingLimited", "", "(Ljava/lang/String;Z)V", "getAndroidAdvertiserIdValue", "()Ljava/lang/String;", "setAndroidAdvertiserIdValue", "(Ljava/lang/String;)V", "()Z", "setTrackingLimited", "(Z)V", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "tap-kit_release"})
    public static final class GAID {
        @Nullable
        private String androidAdvertiserIdValue;
        private boolean isTrackingLimited;

        public GAID(@Nullable String androidAdvertiserIdValue, boolean isTrackingLimited) {
            this.androidAdvertiserIdValue = androidAdvertiserIdValue;
            this.isTrackingLimited = isTrackingLimited;
        }

        public /* synthetic */ GAID(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                bl = false;
            }
            this(string, bl);
        }

        @Nullable
        public final String getAndroidAdvertiserIdValue() {
            return this.androidAdvertiserIdValue;
        }

        public final void setAndroidAdvertiserIdValue(@Nullable String string) {
            this.androidAdvertiserIdValue = string;
        }

        public final boolean isTrackingLimited() {
            return this.isTrackingLimited;
        }

        public final void setTrackingLimited(boolean bl) {
            this.isTrackingLimited = bl;
        }

        @Nullable
        public final String component1() {
            return this.androidAdvertiserIdValue;
        }

        public final boolean component2() {
            return this.isTrackingLimited;
        }

        @NotNull
        public final GAID copy(@Nullable String androidAdvertiserIdValue, boolean isTrackingLimited) {
            return new GAID(androidAdvertiserIdValue, isTrackingLimited);
        }

        public static /* synthetic */ GAID copy$default(GAID gAID, String string, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = gAID.androidAdvertiserIdValue;
            }
            if ((n & 2) != 0) {
                bl = gAID.isTrackingLimited;
            }
            return gAID.copy(string, bl);
        }

        @NotNull
        public String toString() {
            return "GAID(androidAdvertiserIdValue=" + this.androidAdvertiserIdValue + ", isTrackingLimited=" + this.isTrackingLimited + ')';
        }

        public int hashCode() {
            int result = this.androidAdvertiserIdValue == null ? 0 : this.androidAdvertiserIdValue.hashCode();
            int n = this.isTrackingLimited ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GAID)) {
                return false;
            }
            GAID gAID = (GAID)other;
            if (!Intrinsics.areEqual((Object)this.androidAdvertiserIdValue, (Object)gAID.androidAdvertiserIdValue)) {
                return false;
            }
            return this.isTrackingLimited == gAID.isTrackingLimited;
        }

        public GAID() {
            this(null, false, 3, null);
        }
    }
}

