/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.kit.internal.utils.localize;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.os.LocaleList;
import android.support.annotation.PluralsRes;
import android.support.annotation.StringRes;
import com.taptap.sdk.kit.internal.TapTapKit;
import com.taptap.sdk.kit.internal.utils.DeviceUtils;
import com.taptap.sdk.kit.internal.utils.localize.ITapLanguageChangeListener;
import com.taptap.sdk.kit.internal.utils.localize.TapLanguageInternal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0007J3\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\f\"\u00020\u0001H\u0007\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0011H\u0002J\u0012\u0010\u001c\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0007J+\u0010\u001c\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\f\"\u00020\u0001H\u0007\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u00020\u0004H\u0007J\b\u0010\u001f\u001a\u00020\u0011H\u0002J\u001d\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b#J\u000e\u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\nJ\u000e\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u0013J\u000e\u0010(\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\nJ\u0012\u0010)\u001a\u0004\u0018\u00010*2\b\u0010+\u001a\u0004\u0018\u00010*R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u00020\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/taptap/sdk/kit/internal/utils/localize/TapLocalizeUtil;", "", "()V", "currentLanguage", "Lcom/taptap/sdk/kit/internal/utils/localize/TapLanguageInternal;", "isDomestic", "", "isDomestic$annotations", "languageChangeListeners", "", "Lcom/taptap/sdk/kit/internal/utils/localize/ITapLanguageChangeListener;", "collectTapLanguageChangeListeners", "", "()[Lcom/taptap/sdk/kit/internal/utils/localize/ITapLanguageChangeListener;", "dispatchLanguageChange", "", "getDefaultLocale", "Ljava/util/Locale;", "getLocalizedQuantityString", "", "id", "", "quantity", "formatArgs", "(II[Ljava/lang/Object;)Ljava/lang/String;", "getLocalizedResources", "Landroid/content/res/Resources;", "locale", "getLocalizedString", "(I[Ljava/lang/Object;)Ljava/lang/String;", "getPreferredLanguage", "getPreferredLocale", "initialize", "regionType", "preferredLanguage", "initialize$tap_kit_release", "registerLanguageChangeListener", "listener", "setPreferredLanguage", "language", "unregisterLanguageChangeListener", "wrapperContext", "Landroid/content/Context;", "context", "tap-kit_release"})
public final class TapLocalizeUtil {
    @NotNull
    public static final TapLocalizeUtil INSTANCE = new TapLocalizeUtil();
    private static boolean isDomestic = true;
    @NotNull
    private static TapLanguageInternal currentLanguage = TapLanguageInternal.AUTO;
    @NotNull
    private static final List<ITapLanguageChangeListener> languageChangeListeners = new ArrayList();

    private TapLocalizeUtil() {
    }

    @JvmStatic
    private static /* synthetic */ void isDomestic$annotations() {
    }

    public final void initialize$tap_kit_release(int regionType, @NotNull String preferredLanguage) {
        Intrinsics.checkNotNullParameter((Object)preferredLanguage, (String)"preferredLanguage");
        isDomestic = regionType == 0;
        this.setPreferredLanguage(preferredLanguage);
    }

    @JvmStatic
    @NotNull
    public static final TapLanguageInternal getPreferredLanguage() {
        if (currentLanguage == TapLanguageInternal.AUTO) {
            TapLanguageInternal tapLanguageInternal;
            String curLanguageDisplayName = DeviceUtils.getCurLanguageDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)curLanguageDisplayName, (String)"curLanguageDisplayName");
            if (StringsKt.startsWith$default((String)curLanguageDisplayName, (String)"zh", (boolean)false, (int)2, null)) {
                String string = curLanguageDisplayName;
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                String string2 = string.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
                String displayLowCase = string2;
                tapLanguageInternal = StringsKt.contains$default((CharSequence)displayLowCase, (CharSequence)"hant", (boolean)false, (int)2, null) ? TapLanguageInternal.ZH_HANT : (StringsKt.contains$default((CharSequence)displayLowCase, (CharSequence)"hans", (boolean)false, (int)2, null) ? TapLanguageInternal.ZH_HANS : (!StringsKt.contains$default((CharSequence)displayLowCase, (CharSequence)"cn", (boolean)false, (int)2, null) ? TapLanguageInternal.ZH_HANT : TapLanguageInternal.ZH_HANS));
            } else {
                tapLanguageInternal = StringsKt.startsWith$default((String)curLanguageDisplayName, (String)"en", (boolean)false, (int)2, null) ? TapLanguageInternal.EN : (StringsKt.startsWith$default((String)curLanguageDisplayName, (String)"ja", (boolean)false, (int)2, null) ? TapLanguageInternal.JA : (StringsKt.startsWith$default((String)curLanguageDisplayName, (String)"ko", (boolean)false, (int)2, null) ? TapLanguageInternal.KO : (StringsKt.startsWith$default((String)curLanguageDisplayName, (String)"th", (boolean)false, (int)2, null) ? TapLanguageInternal.TH : (StringsKt.startsWith$default((String)curLanguageDisplayName, (String)"de", (boolean)false, (int)2, null) ? TapLanguageInternal.DE : (StringsKt.startsWith$default((String)curLanguageDisplayName, (String)"es", (boolean)false, (int)2, null) ? TapLanguageInternal.ES : (StringsKt.startsWith$default((String)curLanguageDisplayName, (String)"fr", (boolean)false, (int)2, null) ? TapLanguageInternal.FR : (StringsKt.startsWith$default((String)curLanguageDisplayName, (String)"pt", (boolean)false, (int)2, null) ? TapLanguageInternal.PT : (StringsKt.startsWith$default((String)curLanguageDisplayName, (String)"ru", (boolean)false, (int)2, null) ? TapLanguageInternal.RU : (StringsKt.startsWith$default((String)curLanguageDisplayName, (String)"tr", (boolean)false, (int)2, null) ? TapLanguageInternal.TR : (StringsKt.startsWith$default((String)curLanguageDisplayName, (String)"vi", (boolean)false, (int)2, null) ? TapLanguageInternal.VI : (StringsKt.startsWith$default((String)curLanguageDisplayName, (String)"id", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)curLanguageDisplayName, (String)"in", (boolean)false, (int)2, null) ? TapLanguageInternal.ID : (isDomestic ? TapLanguageInternal.ZH_HANS : TapLanguageInternal.EN))))))))))));
            }
            return tapLanguageInternal;
        }
        return currentLanguage;
    }

    @JvmStatic
    @NotNull
    public static final String getLocalizedString(@StringRes int id) throws Resources.NotFoundException {
        String string = INSTANCE.getLocalizedResources(INSTANCE.getPreferredLocale()).getString(id);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalizedResources(ge\u2026edLocale()).getString(id)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String getLocalizedString(@StringRes int id, Object ... formatArgs) throws Resources.NotFoundException {
        Intrinsics.checkNotNullParameter((Object)formatArgs, (String)"formatArgs");
        String string = INSTANCE.getLocalizedResources(INSTANCE.getPreferredLocale()).getString(id, Arrays.copyOf(formatArgs, formatArgs.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalizedResources(ge\u2026etString(id, *formatArgs)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String getLocalizedQuantityString(@PluralsRes int id, int quantity) throws Resources.NotFoundException {
        String string = INSTANCE.getLocalizedResources(INSTANCE.getPreferredLocale()).getQuantityString(id, quantity);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalizedResources(ge\u2026ntityString(id, quantity)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String getLocalizedQuantityString(@PluralsRes int id, int quantity, Object ... formatArgs) throws Resources.NotFoundException {
        Intrinsics.checkNotNullParameter((Object)formatArgs, (String)"formatArgs");
        String string = INSTANCE.getLocalizedResources(INSTANCE.getPreferredLocale()).getQuantityString(id, quantity, Arrays.copyOf(formatArgs, formatArgs.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalizedResources(ge\u2026d, quantity, *formatArgs)");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerLanguageChangeListener(@NotNull ITapLanguageChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        List<ITapLanguageChangeListener> list = languageChangeListeners;
        synchronized (list) {
            boolean bl = false;
            boolean bl2 = languageChangeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterLanguageChangeListener(@NotNull ITapLanguageChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        List<ITapLanguageChangeListener> list = languageChangeListeners;
        synchronized (list) {
            boolean bl = false;
            boolean bl2 = languageChangeListeners.remove(listener);
        }
    }

    public final void setPreferredLanguage(@NotNull String language) {
        TapLanguageInternal languageInternal;
        block5: {
            TapLanguageInternal tapLanguageInternal;
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            TapLanguageInternal[] tapLanguageInternalArray = TapLanguageInternal.values();
            int n = tapLanguageInternalArray.length;
            for (int i = 0; i < n; ++i) {
                TapLanguageInternal tapLanguageInternal2;
                TapLanguageInternal it = tapLanguageInternal2 = tapLanguageInternalArray[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getLanguage(), (Object)language)) continue;
                tapLanguageInternal = tapLanguageInternal2;
                break block5;
            }
            tapLanguageInternal = languageInternal = null;
        }
        if (languageInternal == null) {
            TapLanguageInternal tapLanguageInternal = languageInternal = isDomestic ? TapLanguageInternal.ZH_HANS : TapLanguageInternal.EN;
        }
        if (languageInternal != currentLanguage) {
            currentLanguage = languageInternal;
            try {
                boolean bl = false;
                INSTANCE.dispatchLanguageChange();
                Object object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
        }
    }

    @Nullable
    public final Context wrapperContext(@Nullable Context context) {
        if (context == null) {
            return null;
        }
        Configuration configuration = context.getResources().getConfiguration();
        if (Build.VERSION.SDK_INT >= 24) {
            Locale[] localeArray = new Locale[]{this.getPreferredLocale()};
            configuration.setLocales(new LocaleList(localeArray));
        } else {
            configuration.setLocale(this.getPreferredLocale());
        }
        return context.createConfigurationContext(configuration);
    }

    private final void dispatchLanguageChange() {
        ITapLanguageChangeListener[] callbacks = this.collectTapLanguageChangeListeners();
        if (callbacks != null) {
            int n = callbacks.length;
            for (int i = 0; i < n; ++i) {
                callbacks[i].onLanguageChange(isDomestic, currentLanguage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ITapLanguageChangeListener[] collectTapLanguageChangeListeners() {
        ITapLanguageChangeListener[] listeners = null;
        List<ITapLanguageChangeListener> list = languageChangeListeners;
        synchronized (list) {
            boolean bl = false;
            if (languageChangeListeners.size() > 0) {
                Collection $this$toTypedArray$iv = languageChangeListeners;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                listeners = thisCollection$iv.toArray(new ITapLanguageChangeListener[0]);
            }
            Unit unit = Unit.INSTANCE;
        }
        return listeners;
    }

    private final Locale getPreferredLocale() {
        Locale locale;
        switch (WhenMappings.$EnumSwitchMapping$0[TapLocalizeUtil.getPreferredLanguage().ordinal()]) {
            case 1: {
                locale = this.getDefaultLocale();
                break;
            }
            case 2: {
                Locale locale2 = Locale.SIMPLIFIED_CHINESE;
                locale = locale2;
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"SIMPLIFIED_CHINESE");
                break;
            }
            case 3: {
                Locale locale3 = Locale.TRADITIONAL_CHINESE;
                locale = locale3;
                Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"TRADITIONAL_CHINESE");
                break;
            }
            case 4: {
                Locale locale4 = Locale.ENGLISH;
                locale = locale4;
                Intrinsics.checkNotNullExpressionValue((Object)locale4, (String)"ENGLISH");
                break;
            }
            case 5: {
                Locale locale5 = Locale.JAPANESE;
                locale = locale5;
                Intrinsics.checkNotNullExpressionValue((Object)locale5, (String)"JAPANESE");
                break;
            }
            case 6: {
                Locale locale6 = Locale.KOREAN;
                locale = locale6;
                Intrinsics.checkNotNullExpressionValue((Object)locale6, (String)"KOREAN");
                break;
            }
            case 7: {
                locale = new Locale("th");
                break;
            }
            case 8: {
                Locale locale7 = Locale.GERMAN;
                locale = locale7;
                Intrinsics.checkNotNullExpressionValue((Object)locale7, (String)"GERMAN");
                break;
            }
            case 9: {
                locale = new Locale("pt");
                break;
            }
            case 10: {
                locale = new Locale("vi");
                break;
            }
            case 11: {
                locale = new Locale("id");
                break;
            }
            case 12: {
                locale = new Locale("es");
                break;
            }
            case 13: {
                Locale locale8 = Locale.FRENCH;
                locale = locale8;
                Intrinsics.checkNotNullExpressionValue((Object)locale8, (String)"FRENCH");
                break;
            }
            case 14: {
                locale = new Locale("ru");
                break;
            }
            case 15: {
                locale = new Locale("tr");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return locale;
    }

    private final Locale getDefaultLocale() {
        Locale locale;
        if (isDomestic) {
            Locale locale2 = Locale.SIMPLIFIED_CHINESE;
            locale = locale2;
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"{\n            Locale.SIMPLIFIED_CHINESE\n        }");
        } else {
            Locale locale3 = Locale.ENGLISH;
            locale = locale3;
            Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"{\n            Locale.ENGLISH\n        }");
        }
        return locale;
    }

    private final Resources getLocalizedResources(Locale locale) {
        Resources resources = TapTapKit.INSTANCE.getContext().getResources();
        Configuration config = new Configuration(resources.getConfiguration());
        config.setLocale(locale);
        Resources resources2 = TapTapKit.INSTANCE.getContext().createConfigurationContext(config).getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources2, (String)"TapTapKit.context.create\u2026Context(config).resources");
        return resources2;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TapLanguageInternal.values().length];
            try {
                nArray[TapLanguageInternal.AUTO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TapLanguageInternal.ZH_HANS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TapLanguageInternal.ZH_HANT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TapLanguageInternal.EN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TapLanguageInternal.JA.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TapLanguageInternal.KO.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TapLanguageInternal.TH.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TapLanguageInternal.DE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TapLanguageInternal.PT.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TapLanguageInternal.VI.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TapLanguageInternal.ID.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TapLanguageInternal.ES.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TapLanguageInternal.FR.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TapLanguageInternal.RU.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TapLanguageInternal.TR.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

