/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.login.internal;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import com.taptap.sdk.kit.ITapTapOptionsInternal;
import com.taptap.sdk.kit.internal.TapLogger;
import com.taptap.sdk.kit.internal.callback.TapTapCallback;
import com.taptap.sdk.kit.internal.exception.TapTapException;
import com.taptap.sdk.kit.internal.identifier.TapIdentifierUtil;
import com.taptap.sdk.kit.internal.service.ITapAutoService;
import com.taptap.sdk.kit.internal.service.TapTapServices;
import com.taptap.sdk.login.AccessToken;
import com.taptap.sdk.login.R;
import com.taptap.sdk.login.TapTapAccount;
import com.taptap.sdk.login.internal.AccountManager;
import com.taptap.sdk.login.internal.LoginActivityImpl;
import com.taptap.sdk.login.internal.LoginManager;
import com.taptap.sdk.login.internal.bean.LoginRequest;
import com.taptap.sdk.login.internal.bean.LoginResponse;
import com.taptap.sdk.login.internal.bean.Profile;
import com.taptap.sdk.login.internal.net.HttpCallback;
import com.taptap.sdk.login.internal.net.NetworkClient;
import com.taptap.sdk.login.internal.ui.LoginToastHelper;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002J7\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u001d2\u0006\u0010\u001e\u001a\u00020\f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010 J\u0018\u0010!\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\fH\u0002J\b\u0010\"\u001a\u0004\u0018\u00010\u000eJ\"\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010)J(\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020\u00072\b\u0010&\u001a\u0004\u0018\u00010'2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00180-H\u0002J(\u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u00020\u00052\b\u0010&\u001a\u0004\u0018\u00010'2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00180-H\u0002J(\u00100\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\u00072\u0006\u00101\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00132\b\u00102\u001a\u0004\u0018\u000103J/\u00104\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0004\u00a2\u0006\u0002\u00105J7\u00104\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u001d2\u0006\u0010\u001e\u001a\u00020\f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0004\u00a2\u0006\u0002\u0010 J\u0006\u00106\u001a\u00020\u0018J\u0010\u00107\u001a\u00020\u00182\b\u0010&\u001a\u0004\u0018\u00010'J\u0018\u00108\u001a\u00020\u00182\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u00109\u001a\u00020:J3\u0010;\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00070\u001d2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010<\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010=R\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u000f@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006>"}, d2={"Lcom/taptap/sdk/login/internal/LoginManager;", "", "()V", "authCallback", "Lcom/taptap/sdk/kit/internal/callback/TapTapCallback;", "Lcom/taptap/sdk/login/AccessToken;", "<set-?>", "", "clientId", "getClientId", "()Ljava/lang/String;", "isInitialized", "", "loginCallback", "Lcom/taptap/sdk/login/TapTapAccount;", "Lcom/taptap/sdk/login/internal/net/NetworkClient;", "networkClient", "getNetworkClient", "()Lcom/taptap/sdk/login/internal/net/NetworkClient;", "", "regionType", "getRegionType", "()I", "assertInitialized", "", "authWithScope", "activity", "Landroid/app/Activity;", "scopes", "", "isPreApproved", "callback", "(Landroid/app/Activity;[Ljava/lang/String;ZLcom/taptap/sdk/kit/internal/callback/TapTapCallback;)V", "generateInfo", "getCurrentTapAccount", "handleLoginResponse", "context", "Landroid/content/Context;", "request", "Lcom/taptap/sdk/login/internal/bean/LoginRequest;", "response", "Lcom/taptap/sdk/login/internal/bean/LoginResponse;", "handleLoginWithCode", "code", "onSuccessCallback", "Lkotlin/Function0;", "handleLoginWithToken", "token", "init", "clientToken", "options", "Lcom/taptap/sdk/kit/ITapTapOptionsInternal;", "loginWithScope", "(Landroid/app/Activity;[Ljava/lang/String;Lcom/taptap/sdk/kit/internal/callback/TapTapCallback;)V", "logout", "notifyCancel", "notifyFail", "exception", "Lcom/taptap/sdk/kit/internal/exception/TapTapException;", "startLoginProcess", "isAuth", "(Landroid/app/Activity;[Ljava/lang/String;ZZ)V", "tap-login_release"})
public final class LoginManager {
    @NotNull
    public static final LoginManager INSTANCE = new LoginManager();
    private static NetworkClient networkClient;
    private static String clientId;
    private static int regionType;
    private static boolean isInitialized;
    @Nullable
    private static TapTapCallback<TapTapAccount> loginCallback;
    @Nullable
    private static TapTapCallback<AccessToken> authCallback;

    private LoginManager() {
    }

    @NotNull
    public final NetworkClient getNetworkClient() {
        NetworkClient networkClient = LoginManager.networkClient;
        if (networkClient != null) {
            return networkClient;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"networkClient");
        return null;
    }

    @NotNull
    public final String getClientId() {
        String string = clientId;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"clientId");
        return null;
    }

    public final int getRegionType() {
        return regionType;
    }

    public final void init(@NotNull String clientId, @NotNull String clientToken, int regionType, @Nullable ITapTapOptionsInternal options) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)clientToken, (String)"clientToken");
        if (isInitialized) {
            TapLogger.logd((String)"TapLogin", (String)"LoginManager is already initialized, do not init again");
            return;
        }
        AccountManager.INSTANCE.init();
        LoginManager.clientId = clientId;
        LoginManager.regionType = regionType;
        networkClient = new NetworkClient(clientId, regionType);
        this.getNetworkClient().refreshToken((Function1<? super AccessToken, Unit>)((Function1)init.1.INSTANCE), (Function1<? super Throwable, Unit>)((Function1)init.2.INSTANCE));
        isInitialized = true;
    }

    public final void authWithScope(@NotNull Activity activity, @NotNull String[] scopes, boolean isPreApproved, @NotNull TapTapCallback<AccessToken> callback) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)scopes, (String)"scopes");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.assertInitialized();
        if (authCallback != null) {
            callback.onFail(new TapTapException("Another auth request is in progress"));
            return;
        }
        authCallback = callback;
        this.startLoginProcess(activity, scopes, isPreApproved, true);
    }

    public final void loginWithScope(@NotNull Activity activity, @NotNull String[] scopes, @NotNull TapTapCallback<TapTapAccount> callback) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)scopes, (String)"scopes");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.loginWithScope(activity, scopes, false, callback);
    }

    public final void loginWithScope(@NotNull Activity activity, @NotNull String[] scopes, boolean isPreApproved, @NotNull TapTapCallback<TapTapAccount> callback) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)scopes, (String)"scopes");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.assertInitialized();
        if (loginCallback != null) {
            callback.onFail(new TapTapException("Another login request is in progress"));
            return;
        }
        if (scopes.length == 0) {
            callback.onFail(new TapTapException("Scope cannot be empty"));
            return;
        }
        loginCallback = callback;
        this.startLoginProcess(activity, scopes, isPreApproved, false);
    }

    private final void startLoginProcess(Activity activity, String[] scopes, boolean isPreApproved, boolean isAuth) {
        List requestScope = ArraysKt.toMutableList((Object[])scopes);
        if (!isAuth) {
            ITapAutoService iTapAutoService = TapTapServices.INSTANCE.find("TapTapCompliance");
            Object object = iTapAutoService != null ? iTapAutoService.execute((Context)activity, "getAgeRangeScope", MapsKt.emptyMap()) : null;
            String string = object instanceof String ? (String)object : null;
            if (string != null) {
                String it = string;
                boolean bl = false;
                if (!requestScope.contains(it)) {
                    requestScope.add(it);
                }
            }
        }
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        Collection $this$toTypedArray$iv = requestScope;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        LoginRequest request = new LoginRequest(string, this.getClientId(), thisCollection$iv.toArray(new String[0]), "4.3.1", this.generateInfo(activity, isPreApproved), regionType, isPreApproved, null, null, null, null, null, null, null, isAuth, 16256, null);
        LoginActivityImpl.Companion.startLoginActivity((Context)activity, request);
    }

    public final void handleLoginResponse(@NotNull Context context, @Nullable LoginRequest request, @Nullable LoginResponse response) {
        block10: {
            Unit unit;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (request == null || response == null || !Intrinsics.areEqual((Object)request.getState(), (Object)response.getId())) {
                this.notifyFail(request, new TapTapException("Fail to login"));
                return;
            }
            if (response.getCancel()) {
                this.notifyCancel(request);
                return;
            }
            CharSequence charSequence = response.getErrorMessage();
            if (!(charSequence == null || charSequence.length() == 0)) {
                if (Intrinsics.areEqual((Object)response.getErrorMessage(), (Object)"access_denied")) {
                    this.notifyCancel(request);
                } else {
                    String string = response.getErrorMessage();
                    if (string == null) {
                        string = "Fail to login";
                    }
                    this.notifyFail(request, new TapTapException(string));
                }
                return;
            }
            Function0 onSuccessCallback2 = (Function0)new Function0<Unit>(response, context){
                final /* synthetic */ LoginResponse $response;
                final /* synthetic */ Context $context;
                {
                    this.$response = $response;
                    this.$context = $context;
                    super(0);
                }

                public final void invoke() {
                    block3: {
                        String string2 = this.$response.getServerUri();
                        if (string2 == null) break block3;
                        String string3 = string2;
                        Context context = this.$context;
                        String it = string3;
                        boolean bl = false;
                        try {
                            String name;
                            Uri rawUri = Uri.parse((String)it);
                            String string4 = name = rawUri.getQueryParameter("name");
                            if (string4 != null) {
                                String it2 = string4;
                                boolean bl2 = false;
                                Context context2 = context.getApplicationContext();
                                Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
                                Object[] objectArray = new Object[]{name};
                                String string5 = context.getResources().getString(R.string.login_account_logged_tip, objectArray);
                                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"context.resources.getStr\u2026account_logged_tip, name)");
                                LoginToastHelper.INSTANCE.showToast(context2, string5);
                            }
                        }
                        catch (Exception exception) {
                        }
                    }
                }
            };
            String string = response.getCode();
            if (string != null) {
                String it = string;
                boolean bl = false;
                INSTANCE.handleLoginWithCode(it, request, (Function0<Unit>)onSuccessCallback2);
                unit = Unit.INSTANCE;
            } else {
                AccessToken accessToken = response.getToken();
                if (accessToken != null) {
                    AccessToken it = accessToken;
                    boolean bl = false;
                    INSTANCE.handleLoginWithToken(it, request, (Function0<Unit>)onSuccessCallback2);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }
            if (unit != null) break block10;
            LoginManager $this$handleLoginResponse_u24lambda_u243 = this;
            boolean bl = false;
            $this$handleLoginResponse_u24lambda_u243.notifyFail(request, new TapTapException("Fail to login"));
        }
    }

    private final void handleLoginWithCode(String code, LoginRequest request, Function0<Unit> onSuccessCallback2) {
        Object object = request;
        if (object == null || (object = ((LoginRequest)object).getCodeVerifier()) == null) {
            object = "";
        }
        Object codeVerifier = object;
        this.getNetworkClient().loginWithCode(code, (String)codeVerifier, (TapTapCallback<AccessToken>)new HttpCallback<AccessToken>(request, onSuccessCallback2){
            final /* synthetic */ LoginRequest $request;
            final /* synthetic */ Function0<Unit> $onSuccessCallback;
            {
                this.$request = $request;
                this.$onSuccessCallback = $onSuccessCallback;
            }

            public void onSuccess(@NotNull AccessToken result) {
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                LoginManager.access$handleLoginWithToken(LoginManager.INSTANCE, result, this.$request, this.$onSuccessCallback);
            }

            public void onFail(@NotNull TapTapException exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                LoginManager.INSTANCE.notifyFail(this.$request, new TapTapException("Fail to login"));
            }
        });
    }

    private final void handleLoginWithToken(AccessToken token, LoginRequest request, Function0<Unit> onSuccessCallback2) {
        boolean isAuth;
        LoginRequest loginRequest = request;
        boolean bl = isAuth = loginRequest != null ? loginRequest.isAuth() : false;
        if (isAuth) {
            TapTapCallback<AccessToken> tapTapCallback = authCallback;
            if (tapTapCallback != null) {
                tapTapCallback.onSuccess((Object)token);
            }
            authCallback = null;
            return;
        }
        this.getNetworkClient().fetchProfile(token, new HttpCallback<Profile>(token, onSuccessCallback2, request){
            final /* synthetic */ AccessToken $token;
            final /* synthetic */ Function0<Unit> $onSuccessCallback;
            final /* synthetic */ LoginRequest $request;
            {
                this.$token = $token;
                this.$onSuccessCallback = $onSuccessCallback;
                this.$request = $request;
            }

            public void onSuccess(@NotNull Profile result) {
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                TapTapAccount account = new TapTapAccount(this.$token, result.getOpenId(), result.getUnionId(), result.getName(), result.getAvatar(), result.getEmail());
                AccountManager.INSTANCE.setAccount(account);
                this.$onSuccessCallback.invoke();
                TapTapCallback tapTapCallback = LoginManager.access$getLoginCallback$p();
                if (tapTapCallback != null) {
                    tapTapCallback.onSuccess((Object)account);
                }
                LoginManager.access$setLoginCallback$p(null);
            }

            public void onFail(@NotNull TapTapException exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                LoginManager.INSTANCE.notifyFail(this.$request, new TapTapException("Fail to fetch profile"));
            }
        });
    }

    @Nullable
    public final TapTapAccount getCurrentTapAccount() {
        this.assertInitialized();
        return AccountManager.INSTANCE.getAccount();
    }

    public final void logout() {
        this.assertInitialized();
        AccountManager.INSTANCE.clearCache();
    }

    public final void notifyCancel(@Nullable LoginRequest request) {
        boolean isAuth;
        LoginRequest loginRequest = request;
        boolean bl = isAuth = loginRequest != null ? loginRequest.isAuth() : false;
        if (isAuth) {
            TapTapCallback<AccessToken> tapTapCallback = authCallback;
            if (tapTapCallback != null) {
                tapTapCallback.onCancel();
            }
            authCallback = null;
        } else {
            TapTapCallback<TapTapAccount> tapTapCallback = loginCallback;
            if (tapTapCallback != null) {
                tapTapCallback.onCancel();
            }
            loginCallback = null;
        }
    }

    public final void notifyFail(@Nullable LoginRequest request, @NotNull TapTapException exception) {
        boolean isAuth;
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        LoginRequest loginRequest = request;
        boolean bl = isAuth = loginRequest != null ? loginRequest.isAuth() : false;
        if (isAuth) {
            TapTapCallback<AccessToken> tapTapCallback = authCallback;
            if (tapTapCallback != null) {
                tapTapCallback.onFail(exception);
            }
            authCallback = null;
        } else {
            TapTapCallback<TapTapAccount> tapTapCallback = loginCallback;
            if (tapTapCallback != null) {
                tapTapCallback.onFail(exception);
            }
            loginCallback = null;
        }
    }

    private final void assertInitialized() {
        if (!isInitialized) {
            throw new TapTapException("TapLogin has not been initialized!");
        }
    }

    private final String generateInfo(Activity activity, boolean isPreApproved) {
        String orientation = activity.getResources().getConfiguration().orientation == 1 ? "vertical" : "horizontal";
        return "biz_source==GAME&client_id=" + this.getClientId() + "&uuid=" + TapIdentifierUtil.INSTANCE.getInstallUUID() + "&name=TapLoginAndroid&orientation=" + orientation + "&version=4.3.1&version_code=403010000&preapproved=" + (isPreApproved ? 1 : 0);
    }

    public static final /* synthetic */ void access$handleLoginWithToken(LoginManager $this, AccessToken token, LoginRequest request, Function0 onSuccessCallback2) {
        $this.handleLoginWithToken(token, request, (Function0<Unit>)onSuccessCallback2);
    }

    public static final /* synthetic */ TapTapCallback access$getLoginCallback$p() {
        return loginCallback;
    }

    public static final /* synthetic */ void access$setLoginCallback$p(TapTapCallback tapTapCallback) {
        loginCallback = tapTapCallback;
    }
}

