/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.login.internal;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.webkit.CookieManager;
import com.taptap.sdk.compliance.api.ComplianceService;
import com.taptap.sdk.initializer.api.check.TapSdkChecker;
import com.taptap.sdk.initializer.api.model.RegionType;
import com.taptap.sdk.kit.internal.TapLogger;
import com.taptap.sdk.kit.internal.TapTapKit;
import com.taptap.sdk.kit.internal.callback.TapTapCallback;
import com.taptap.sdk.kit.internal.exception.TapTapException;
import com.taptap.sdk.kit.internal.extensions.StringExtKt;
import com.taptap.sdk.kit.internal.identifier.TapIdentifierUtil;
import com.taptap.sdk.login.AccessToken;
import com.taptap.sdk.login.R;
import com.taptap.sdk.login.TapFirstPartyLoginOptions;
import com.taptap.sdk.login.TapTapAccount;
import com.taptap.sdk.login.TapTapAccountInternal;
import com.taptap.sdk.login.TapTapAccountInternalKt;
import com.taptap.sdk.login.internal.AccountManager;
import com.taptap.sdk.login.internal.LoginActivityImpl;
import com.taptap.sdk.login.internal.LoginEntrance;
import com.taptap.sdk.login.internal.LoginManager$special$;
import com.taptap.sdk.login.internal.LoginTracker;
import com.taptap.sdk.login.internal.TapLoginInternal;
import com.taptap.sdk.login.internal.bean.LoginRequest;
import com.taptap.sdk.login.internal.bean.LoginResponse;
import com.taptap.sdk.login.internal.handlers.web.WebLoginFragment;
import com.taptap.sdk.login.internal.net.LoginCallback;
import com.taptap.sdk.login.internal.net.NetworkClient;
import com.taptap.sdk.login.internal.ui.LoginToastHelper;
import com.taptap.sdk.servicemanager.utils.ServiceManagerComponent;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010%\u001a\u00020&H\u0002J3\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00070+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0000\u00a2\u0006\u0004\b-\u0010.J\b\u0010/\u001a\u00020&H\u0002J&\u00100\u001a\u00020\u00072\u0006\u0010(\u001a\u00020)2\u0006\u00101\u001a\u00020\u00192\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u000703H\u0002J\u0016\u00104\u001a\u00020\u00072\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u000703H\u0002J\b\u00106\u001a\u0004\u0018\u00010\u001cJ\r\u00107\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b8J\r\u00109\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b:J\b\u0010;\u001a\u00020\u0007H\u0002J\"\u0010<\u001a\u00020&2\u0006\u0010=\u001a\u00020>2\b\u0010?\u001a\u0004\u0018\u00010@2\b\u0010A\u001a\u0004\u0018\u00010BJ(\u0010C\u001a\u00020&2\u0006\u0010D\u001a\u00020\u00072\b\u0010?\u001a\u0004\u0018\u00010@2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020&0FH\u0002J\u0016\u0010G\u001a\u00020&2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020!J7\u0010H\u001a\u00020&2\u0006\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00070+2\u0006\u0010I\u001a\u00020J2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0004\u00a2\u0006\u0002\u0010KJ\u0006\u0010L\u001a\u00020&J\u0010\u0010M\u001a\u00020&2\b\u0010?\u001a\u0004\u0018\u00010@J\u0018\u0010N\u001a\u00020&2\b\u0010?\u001a\u0004\u0018\u00010@2\u0006\u0010O\u001a\u00020PJ\u0010\u0010Q\u001a\u00020&2\b\u0010?\u001a\u0004\u0018\u00010@J\u0010\u0010R\u001a\u00020&2\b\u0010(\u001a\u0004\u0018\u00010)J3\u0010S\u001a\u00020&2\u0006\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00070+2\u0006\u0010I\u001a\u00020J2\u0006\u0010T\u001a\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010UR\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u000b\u001a\u0004\u0018\u00010\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0011\u001a\u00020\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u001d@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001e\u0010\"\u001a\u00020!2\u0006\u0010\u0006\u001a\u00020!@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u0006V"}, d2={"Lcom/taptap/sdk/login/internal/LoginManager;", "", "()V", "authCallback", "Lcom/taptap/sdk/kit/internal/callback/TapTapCallback;", "Lcom/taptap/sdk/login/AccessToken;", "<set-?>", "", "clientId", "getClientId", "()Ljava/lang/String;", "complianceService", "Lcom/taptap/sdk/compliance/api/ComplianceService;", "getComplianceService", "()Lcom/taptap/sdk/compliance/api/ComplianceService;", "complianceService$delegate", "Lkotlin/Lazy;", "currentLoginEntrance", "Lcom/taptap/sdk/login/internal/LoginEntrance;", "getCurrentLoginEntrance$tap_login_release", "()Lcom/taptap/sdk/login/internal/LoginEntrance;", "setCurrentLoginEntrance$tap_login_release", "(Lcom/taptap/sdk/login/internal/LoginEntrance;)V", "currentSessionId", "isHandlingResponse", "", "isInitialized", "loginCallback", "Lcom/taptap/sdk/login/TapTapAccount;", "Lcom/taptap/sdk/login/internal/net/NetworkClient;", "networkClient", "getNetworkClient", "()Lcom/taptap/sdk/login/internal/net/NetworkClient;", "Lcom/taptap/sdk/initializer/api/model/RegionType;", "regionType", "getRegionType", "()Lcom/taptap/sdk/initializer/api/model/RegionType;", "assertInitialized", "", "authWithScope", "activity", "Landroid/app/Activity;", "scopes", "", "callback", "authWithScope$tap_login_release", "(Landroid/app/Activity;[Ljava/lang/String;Lcom/taptap/sdk/kit/internal/callback/TapTapCallback;)V", "clearLoginDomainCookies", "generateInfo", "isPreApproved", "requestScope", "", "generateTrackInfo", "requestedScope", "getCurrentTapAccount", "getLoginType", "getLoginType$tap_login_release", "getSessionId", "getSessionId$tap_login_release", "getWebUrl", "handleLoginResponse", "context", "Landroid/content/Context;", "request", "Lcom/taptap/sdk/login/internal/bean/LoginRequest;", "response", "Lcom/taptap/sdk/login/internal/bean/LoginResponse;", "handleLoginWithCode", "code", "onSuccessCallback", "Lkotlin/Function0;", "init", "loginWithScope", "options", "Lcom/taptap/sdk/login/TapFirstPartyLoginOptions;", "(Landroid/app/Activity;[Ljava/lang/String;Lcom/taptap/sdk/login/TapFirstPartyLoginOptions;Lcom/taptap/sdk/kit/internal/callback/TapTapCallback;)V", "logout", "notifyCancel", "notifyFail", "exception", "Lcom/taptap/sdk/kit/internal/exception/TapTapException;", "onActivityDestroy", "onBackPressed", "startLoginProcess", "isAuth", "(Landroid/app/Activity;[Ljava/lang/String;Lcom/taptap/sdk/login/TapFirstPartyLoginOptions;Z)V", "tap-login_release"})
public final class LoginManager {
    @NotNull
    public static final LoginManager INSTANCE = new LoginManager();
    private static NetworkClient networkClient;
    private static String clientId;
    @NotNull
    private static RegionType regionType;
    private static boolean isInitialized;
    private static boolean isHandlingResponse;
    @Nullable
    private static TapTapCallback<TapTapAccount> loginCallback;
    @Nullable
    private static TapTapCallback<AccessToken> authCallback;
    @NotNull
    private static final Lazy complianceService$delegate;
    @NotNull
    private static volatile String currentSessionId;
    @NotNull
    private static LoginEntrance currentLoginEntrance;

    private LoginManager() {
    }

    @NotNull
    public final NetworkClient getNetworkClient() {
        NetworkClient networkClient = LoginManager.networkClient;
        if (networkClient != null) {
            return networkClient;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"networkClient");
        return null;
    }

    @NotNull
    public final String getClientId() {
        String string = clientId;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"clientId");
        return null;
    }

    @NotNull
    public final RegionType getRegionType() {
        return regionType;
    }

    private final ComplianceService getComplianceService() {
        Lazy lazy = complianceService$delegate;
        return (ComplianceService)lazy.getValue();
    }

    @NotNull
    public final LoginEntrance getCurrentLoginEntrance$tap_login_release() {
        return currentLoginEntrance;
    }

    public final void setCurrentLoginEntrance$tap_login_release(@NotNull LoginEntrance loginEntrance) {
        Intrinsics.checkNotNullParameter((Object)((Object)loginEntrance), (String)"<set-?>");
        currentLoginEntrance = loginEntrance;
    }

    public final void init(@NotNull String clientId, @NotNull RegionType regionType) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)regionType, (String)"regionType");
        if (isInitialized) {
            TapLogger.logd((String)"TapLogin", (String)"LoginManager is already initialized, do not init again");
            return;
        }
        AccountManager.INSTANCE.init();
        LoginManager.clientId = clientId;
        LoginManager.regionType = regionType;
        networkClient = new NetworkClient();
        this.getNetworkClient().refreshToken();
        isInitialized = true;
    }

    public final void authWithScope$tap_login_release(@NotNull Activity activity, @NotNull String[] scopes, @NotNull TapTapCallback<AccessToken> callback) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)scopes, (String)"scopes");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.assertInitialized();
        if (authCallback != null) {
            callback.onFail(new TapTapException("Another auth request is in progress"));
            return;
        }
        authCallback = callback;
        currentSessionId = StringExtKt.generateSessionId();
        this.startLoginProcess(activity, scopes, new TapFirstPartyLoginOptions.Builder().build(), true);
    }

    public final void loginWithScope(@NotNull Activity activity, @NotNull String[] scopes, @NotNull TapFirstPartyLoginOptions options, @NotNull TapTapCallback<TapTapAccount> callback) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)scopes, (String)"scopes");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (!TapSdkChecker.INSTANCE.checkInitialize()) {
            return;
        }
        this.assertInitialized();
        if (loginCallback != null) {
            callback.onFail(new TapTapException("Another login request is in progress"));
            return;
        }
        currentSessionId = StringExtKt.generateSessionId();
        LoginTracker.INSTANCE.trackFuncStart$tap_login_release("loginWithScopes", this.getSessionId$tap_login_release());
        if (scopes.length == 0) {
            LoginTracker.INSTANCE.trackFail$tap_login_release("loginWithScopes", this.getSessionId$tap_login_release(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"login_type", (Object)this.getLoginType$tap_login_release())), -1, "Scope is empty");
            callback.onFail(new TapTapException("Scope cannot be empty"));
            return;
        }
        loginCallback = callback;
        this.startLoginProcess(activity, scopes, options, false);
    }

    private final void startLoginProcess(Activity activity, String[] scopes, TapFirstPartyLoginOptions options, boolean isAuth) {
        String string;
        List requestScope = ArraysKt.toMutableList((Object[])scopes);
        if (!isAuth) {
            Object object = this.getComplianceService();
            if (object != null && (object = object.getAgeRangeScope()) != null) {
                Object scope = object;
                boolean bl = false;
                if (!requestScope.contains(scope)) {
                    requestScope.add(scope);
                }
            }
        }
        String string2 = UUID.randomUUID().toString();
        String string3 = this.getClientId();
        Collection $this$toTypedArray$iv = requestScope;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        String $this$startLoginProcess_u24lambda_u241 = string = this.generateInfo(activity, options.isPreApproved(), requestScope);
        boolean bl = false;
        TapLogger.logi((String)"TapLoginLog", (String)("request.info=" + $this$startLoginProcess_u24lambda_u241));
        String string4 = string;
        string = this.generateTrackInfo(requestScope);
        RegionType regionType = LoginManager.regionType;
        boolean bl2 = options.isPreApproved();
        String string5 = options.getPreferLoginType();
        String string6 = options.getPhoneVerifyToken();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString()");
        LoginRequest request = new LoginRequest(string2, string3, stringArray, "4.5.9", string4, string, regionType, bl2, string6, string5, null, null, null, null, null, isAuth, 31744, null);
        LoginActivityImpl.Companion.startLoginActivity((Context)activity, request);
    }

    public final void handleLoginResponse(@NotNull Context context, @Nullable LoginRequest request, @Nullable LoginResponse response) {
        block10: {
            Unit unit;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (request == null || response == null || !Intrinsics.areEqual((Object)request.getState(), (Object)response.getId())) {
                this.notifyFail(request, new TapTapException("Fail to login"));
                return;
            }
            if (response.getCancel()) {
                this.notifyCancel(request);
                return;
            }
            CharSequence charSequence = response.getErrorMessage();
            if (!(charSequence == null || charSequence.length() == 0)) {
                if (Intrinsics.areEqual((Object)response.getErrorMessage(), (Object)"access_denied")) {
                    this.notifyCancel(request);
                } else {
                    String string = response.getErrorMessage();
                    if (string == null) {
                        string = "Fail to login";
                    }
                    this.notifyFail(request, new TapTapException(string));
                }
                return;
            }
            Function0 onSuccessCallback2 = (Function0)new Function0<Unit>(response, context){
                final /* synthetic */ LoginResponse $response;
                final /* synthetic */ Context $context;
                {
                    this.$response = $response;
                    this.$context = $context;
                    super(0);
                }

                public final void invoke() {
                    block3: {
                        String string2 = this.$response.getServerUri();
                        if (string2 == null) break block3;
                        String string3 = string2;
                        Context context = this.$context;
                        String it = string3;
                        boolean bl = false;
                        try {
                            String name;
                            Uri rawUri = Uri.parse((String)it);
                            String string4 = name = rawUri.getQueryParameter("name");
                            if (string4 != null) {
                                String it2 = string4;
                                boolean bl2 = false;
                                Context context2 = context.getApplicationContext();
                                Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
                                Object[] objectArray = new Object[]{name};
                                String string5 = context.getResources().getString(R.string.login_account_logged_tip, objectArray);
                                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"context.resources.getStr\u2026account_logged_tip, name)");
                                LoginToastHelper.INSTANCE.showToast(context2, string5);
                            }
                        }
                        catch (Exception exception) {
                        }
                    }
                }
            };
            String string = response.getCode();
            if (string != null) {
                String it = string;
                boolean bl = false;
                isHandlingResponse = true;
                INSTANCE.handleLoginWithCode(it, request, (Function0<Unit>)onSuccessCallback2);
                unit = Unit.INSTANCE;
            } else {
                AccessToken accessToken = response.getToken();
                if (accessToken != null) {
                    AccessToken it = accessToken;
                    boolean bl = false;
                    isHandlingResponse = true;
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            }
            if (unit != null) break block10;
            LoginManager $this$handleLoginResponse_u24lambda_u244 = this;
            boolean bl = false;
            $this$handleLoginResponse_u24lambda_u244.notifyFail(request, new TapTapException("Fail to login"));
        }
    }

    private final void handleLoginWithCode(String code, LoginRequest request, Function0<Unit> onSuccessCallback2) {
        Object object = request;
        if (object == null || (object = ((LoginRequest)object).getTrackInfo()) == null) {
            object = "";
        }
        LoginTracker.INSTANCE.trackAuthCode$tap_login_release((String)object);
        Object object2 = request;
        if (object2 == null || (object2 = ((LoginRequest)object2).getCodeVerifier()) == null) {
            object2 = "";
        }
        Object codeVerifier = object2;
        this.getNetworkClient().loginWithCode(code, (String)codeVerifier, (TapTapCallback<TapTapAccountInternal>)new LoginCallback<TapTapAccountInternal>(request, onSuccessCallback2){
            final /* synthetic */ LoginRequest $request;
            final /* synthetic */ Function0<Unit> $onSuccessCallback;
            {
                this.$request = $request;
                this.$onSuccessCallback = $onSuccessCallback;
            }

            public void onSuccess(@NotNull TapTapAccountInternal result) {
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                LoginManager.access$setHandlingResponse$p(false);
                LoginRequest loginRequest = this.$request;
                if (Intrinsics.areEqual((Object)(loginRequest != null ? Boolean.valueOf(loginRequest.isAuth()) : null), (Object)true)) {
                    TapTapCallback tapTapCallback = LoginManager.access$getAuthCallback$p();
                    if (tapTapCallback != null) {
                        tapTapCallback.onSuccess((Object)result.getSdkToken());
                    }
                    LoginManager.access$setAuthCallback$p(null);
                } else {
                    TapTapAccount account = TapTapAccountInternalKt.toTapAccount((TapTapAccountInternal)result);
                    AccountManager.INSTANCE.setAccount(account);
                    AccountManager.INSTANCE.setAccountInternal$tap_login_release(result);
                    TapLoginInternal.INSTANCE.notifyLoginStatusChange(200001);
                    this.$onSuccessCallback.invoke();
                    LoginTracker.INSTANCE.trackSuccess$tap_login_release("loginWithScopes", LoginManager.INSTANCE.getSessionId$tap_login_release(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"login_type", (Object)LoginManager.INSTANCE.getLoginType$tap_login_release())));
                    LoginManager.access$setHandlingResponse$p(false);
                    TapTapCallback tapTapCallback = LoginManager.access$getLoginCallback$p();
                    if (tapTapCallback != null) {
                        tapTapCallback.onSuccess((Object)account);
                    }
                    LoginManager.access$setLoginCallback$p(null);
                }
            }

            public void onFail(@NotNull TapTapException exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                LoginManager.INSTANCE.notifyFail(this.$request, new TapTapException("Fail to login"));
            }
        });
    }

    @Nullable
    public final TapTapAccount getCurrentTapAccount() {
        this.assertInitialized();
        return AccountManager.INSTANCE.getAccount();
    }

    public final void logout() {
        this.assertInitialized();
        AccountManager.INSTANCE.clearCache();
        this.clearLoginDomainCookies();
        TapLoginInternal.INSTANCE.notifyLoginStatusChange(200004);
        this.clearLoginDomainCookies();
    }

    private final String getWebUrl() {
        return WhenMappings.$EnumSwitchMapping$0[regionType.ordinal()] == 1 ? (TapTapKit.INSTANCE.isRND() ? "https://accounts.xdrnd.cn/authorize" : "https://accounts.taptap.cn/authorize") : (TapTapKit.INSTANCE.isRND() ? "https://accounts-io.xdrnd.com/authorize" : "https://www.taptapauth.com/authorize");
    }

    private final void clearLoginDomainCookies() {
        block2: {
            Iterable iterable;
            String[] stringArray;
            String currentWebUrl = this.getWebUrl();
            CookieManager cookieManager = CookieManager.getInstance();
            String cookies = cookieManager.getCookie(currentWebUrl);
            Object object = cookies;
            if (object == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{";"}), (boolean)false, (int)0, (int)6, null)) == null) break block2;
            Iterable $this$onEach$iv = (Iterable)object;
            boolean $i$f$onEach = false;
            Iterable $this$onEach_u24lambda_u2416$iv = iterable = $this$onEach$iv;
            boolean bl = false;
            for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
                Iterable iterable2;
                String cookie = (String)element$iv;
                boolean bl2 = false;
                String[] stringArray2 = new String[]{"="};
                List cookieParts = StringsKt.split$default((CharSequence)cookie, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
                Iterable $this$onEach$iv2 = cookieParts;
                boolean $i$f$onEach2 = false;
                Iterable $this$onEach_u24lambda_u2416$iv2 = iterable2 = $this$onEach$iv2;
                $i$a$-apply-CollectionsKt___CollectionsKt$onEach$1$iv = false;
                for (Object element$iv2 : $this$onEach_u24lambda_u2416$iv2) {
                    String it = (String)element$iv2;
                    boolean bl3 = false;
                    cookieManager.setCookie(currentWebUrl, ((Object)StringsKt.trim((CharSequence)((String)cookieParts.get(0)))).toString() + "=;Max-Age=0");
                }
            }
            List cfr_ignored_0 = (List)iterable;
        }
    }

    public final void notifyCancel(@Nullable LoginRequest request) {
        boolean isAuth;
        isHandlingResponse = false;
        LoginRequest loginRequest = request;
        boolean bl = isAuth = loginRequest != null ? loginRequest.isAuth() : false;
        if (isAuth) {
            TapTapCallback<AccessToken> tapTapCallback = authCallback;
            if (tapTapCallback != null) {
                tapTapCallback.onCancel();
            }
            authCallback = null;
        } else {
            TapLoginInternal.INSTANCE.notifyLoginStatusChange(200003);
            TapTapCallback<TapTapAccount> tapTapCallback = loginCallback;
            if (tapTapCallback != null) {
                TapTapCallback<TapTapAccount> it = tapTapCallback;
                boolean bl2 = false;
                LoginTracker.INSTANCE.trackCancel$tap_login_release("loginWithScopes", INSTANCE.getSessionId$tap_login_release(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"login_type", (Object)INSTANCE.getLoginType$tap_login_release())));
                it.onCancel();
            }
            loginCallback = null;
        }
    }

    public final void onBackPressed(@Nullable Activity activity) {
        block1: {
            Activity activity2 = activity;
            if (activity2 == null || (activity2 = activity2.getFragmentManager()) == null || (activity2 = activity2.findFragmentByTag("login_fragment")) == null) break block1;
            Activity it = activity2;
            boolean bl = false;
            if (it instanceof WebLoginFragment) {
                ((WebLoginFragment)it).onBackPressed();
            }
        }
    }

    public final void onActivityDestroy(@Nullable LoginRequest request) {
        if (!isHandlingResponse) {
            this.notifyCancel(request);
        }
    }

    public final void notifyFail(@Nullable LoginRequest request, @NotNull TapTapException exception) {
        boolean isAuth;
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        isHandlingResponse = false;
        LoginRequest loginRequest = request;
        boolean bl = isAuth = loginRequest != null ? loginRequest.isAuth() : false;
        if (isAuth) {
            TapTapCallback<AccessToken> tapTapCallback = authCallback;
            if (tapTapCallback != null) {
                tapTapCallback.onFail(exception);
            }
            authCallback = null;
        } else {
            TapLoginInternal.INSTANCE.notifyLoginStatusChange(200002);
            TapTapCallback<TapTapAccount> tapTapCallback = loginCallback;
            if (tapTapCallback != null) {
                TapTapCallback<TapTapAccount> it = tapTapCallback;
                boolean bl2 = false;
                LoginTracker.INSTANCE.trackFail$tap_login_release("loginWithScopes", INSTANCE.getSessionId$tap_login_release(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"login_type", (Object)INSTANCE.getLoginType$tap_login_release())), -1, exception.getMessage());
                it.onFail(exception);
            }
            loginCallback = null;
        }
    }

    private final void assertInitialized() {
        if (!isInitialized) {
            throw new TapTapException("TapLogin has not been initialized!");
        }
    }

    @NotNull
    public final String getLoginType$tap_login_release() {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$1[currentLoginEntrance.ordinal()]) {
            case 1: {
                string = "cloud";
                break;
            }
            case 2: {
                string = "mobile_client";
                break;
            }
            case 3: {
                string = "embedded_web";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final String generateTrackInfo(List<String> requestedScope) {
        JSONObject jSONObject;
        JSONObject $this$generateTrackInfo_u24lambda_u2410 = jSONObject = new JSONObject();
        boolean bl = false;
        $this$generateTrackInfo_u24lambda_u2410.put("scopes", (Object)CollectionsKt.joinToString$default((Iterable)requestedScope, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        $this$generateTrackInfo_u24lambda_u2410.put("session_id", (Object)INSTANCE.getSessionId$tap_login_release());
        $this$generateTrackInfo_u24lambda_u2410.put("session_type", (Object)"tapsdk");
        $this$generateTrackInfo_u24lambda_u2410.put("tapsdk_client_id", (Object)INSTANCE.getClientId());
        $this$generateTrackInfo_u24lambda_u2410.put("tapsdk_login_type", (Object)INSTANCE.getLoginType$tap_login_release());
        String string = jSONObject.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JSONObject().apply {\n   \u2026e())\n        }.toString()");
        return string;
    }

    @NotNull
    public final String getSessionId$tap_login_release() {
        CharSequence charSequence;
        CharSequence charSequence2 = currentSessionId;
        if (charSequence2.length() == 0) {
            String string;
            boolean bl = false;
            String $this$getSessionId_u24lambda_u2412_u24lambda_u2411 = string = StringExtKt.generateSessionId();
            boolean bl2 = false;
            currentSessionId = $this$getSessionId_u24lambda_u2412_u24lambda_u2411;
            charSequence = string;
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    private final String generateInfo(Activity activity, boolean isPreApproved, List<String> requestScope) {
        String orientation = activity.getResources().getConfiguration().orientation == 1 ? "vertical" : "horizontal";
        return "biz_source=GAME&client_id=" + this.getClientId() + "&uuid=" + TapIdentifierUtil.INSTANCE.getInstallUUID() + "&name=TapLoginAndroid&scopes=" + CollectionsKt.joinToString$default((Iterable)requestScope, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + "&session_id=" + this.getSessionId$tap_login_release() + "&session_type=tapsdk&tapsdk_login_type=" + this.getLoginType$tap_login_release() + "&orientation=" + orientation + "&version=4.5.9&version_code=405090000&preapproved=" + (isPreApproved ? 1 : 0);
    }

    public static final /* synthetic */ void access$setHandlingResponse$p(boolean bl) {
        isHandlingResponse = bl;
    }

    public static final /* synthetic */ TapTapCallback access$getAuthCallback$p() {
        return authCallback;
    }

    public static final /* synthetic */ void access$setAuthCallback$p(TapTapCallback tapTapCallback) {
        authCallback = tapTapCallback;
    }

    public static final /* synthetic */ TapTapCallback access$getLoginCallback$p() {
        return loginCallback;
    }

    public static final /* synthetic */ void access$setLoginCallback$p(TapTapCallback tapTapCallback) {
        loginCallback = tapTapCallback;
    }

    static {
        regionType = RegionType.CN;
        ServiceManagerComponent this_$iv = ServiceManagerComponent.INSTANCE;
        boolean $i$f$injectOrNull = false;
        complianceService$delegate = LazyKt.lazy((Function0)special$$inlined$injectOrNull$1.INSTANCE);
        currentSessionId = "";
        currentLoginEntrance = LoginEntrance.WEB;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[RegionType.values().length];
            try {
                nArray[RegionType.CN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[LoginEntrance.values().length];
            try {
                nArray[LoginEntrance.CLOUD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoginEntrance.CLIENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoginEntrance.WEB.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

