/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.login.internal.util;

import android.text.TextUtils;
import android.util.Base64;
import com.taptap.sdk.kit.internal.http.TapHttpUtil;
import com.taptap.sdk.kit.internal.http.TapTime;
import com.taptap.sdk.login.internal.util.CodeUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J\u0010\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u0004J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\u00042\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u0004H\u0002J\b\u0010\u000f\u001a\u00020\u0004H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/taptap/sdk/login/internal/util/CodeUtil;", "", "()V", "getAuthorization", "", "urlString", "method", "kid", "macKey", "getCodeChallenge", "codeVerifier", "getEncodeStr", "signCode", "", "getSignCode", "getTime", "tap-login_release"})
public final class CodeUtil {
    @NotNull
    public static final CodeUtil INSTANCE = new CodeUtil();

    private CodeUtil() {
    }

    @Nullable
    public final String getCodeChallenge(@NotNull String codeVerifier) {
        Intrinsics.checkNotNullParameter((Object)codeVerifier, (String)"codeVerifier");
        return this.getEncodeStr(this.getSignCode(codeVerifier));
    }

    @Nullable
    public final String getAuthorization(@NotNull String urlString, @NotNull String method, @NotNull String kid, @NotNull String macKey) {
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)kid, (String)"kid");
        Intrinsics.checkNotNullParameter((Object)macKey, (String)"macKey");
        try {
            URL url = new URL(urlString);
            String time = this.getTime();
            String randomStr = TapHttpUtil.INSTANCE.getRandomString(5);
            String host = url.getHost();
            CharSequence charSequence = urlString;
            Intrinsics.checkNotNullExpressionValue((Object)host, (String)"host");
            String string2 = urlString.substring(StringsKt.lastIndexOf$default((CharSequence)charSequence, (String)host, (int)0, (boolean)false, (int)6, null) + host.length());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            String uri = string2;
            String port = StringsKt.startsWith$default((String)urlString, (String)"https", (boolean)false, (int)2, null) ? "443" : "80";
            if (((CharSequence)host).length() == 0 || ((CharSequence)uri).length() == 0) {
                throw new IllegalArgumentException("Cannot parse url " + urlString);
            }
            String sign = TapHttpUtil.INSTANCE.secret(macKey, time + '\n' + randomStr + '\n' + method + '\n' + uri + '\n' + host + '\n' + port + "\n\n", "HmacSHA1");
            Object[] objectArray = new Pair[]{new Pair((Object)"id", (Object)kid), new Pair((Object)"ts", (Object)time), new Pair((Object)"nonce", (Object)randomStr), new Pair((Object)"mac", (Object)sign)};
            Object[] authPairs = objectArray;
            return "MAC " + ArraysKt.joinToString$default((Object[])authPairs, (CharSequence)",", null, null, (int)0, null, (Function1)getAuthorization.1.INSTANCE, (int)30, null);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private final String getTime() {
        Locale locale = Locale.US;
        String string2 = "%010d";
        Object[] objectArray = new Object[]{TapTime.INSTANCE.getCurrentTimeInMillis() / (long)1000};
        String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(locale, format, *args)");
        return string3;
    }

    private final String getEncodeStr(byte[] signCode) {
        if (signCode == null) {
            return null;
        }
        byte[] encoded = Base64.encode((byte[])signCode, (int)11);
        Intrinsics.checkNotNullExpressionValue((Object)encoded, (String)"encoded");
        return new String(encoded, Charsets.UTF_8);
    }

    private final byte[] getSignCode(String codeVerifier) {
        byte[] signCode = null;
        if (TextUtils.isEmpty((CharSequence)codeVerifier)) {
            return null;
        }
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("SHA-256");
            String string2 = codeVerifier;
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            digest.update(byArray);
            signCode = digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return signCode;
    }
}

