/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.openlog.internal;

import android.content.Context;
import com.taptap.sdk.kit.internal.identifier.TapIdentifierUtil;
import com.taptap.sdk.kit.internal.utils.DeviceUtils;
import com.taptap.sdk.kit.internal.utils.NetworkUtil;
import com.taptap.sdk.kit.internal.utils.localize.LocalizeManager;
import com.taptap.sdk.openlog.internal.TapOpenlogInner;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u001c\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/taptap/sdk/openlog/internal/TapOpenlogParameterKit;", "", "()V", "PARAM_PN", "", "PARAM_TAPSDK_PROJECT", "sessionUUID", "obtainDynamicProperties", "", "context", "Landroid/content/Context;", "sdkProject", "obtainGeneralProperties", "tap-openlog_release"})
public final class TapOpenlogParameterKit {
    @NotNull
    public static final TapOpenlogParameterKit INSTANCE = new TapOpenlogParameterKit();
    @NotNull
    private static final String PARAM_PN = "TapSDK";
    @NotNull
    private static final String PARAM_TAPSDK_PROJECT = "TapSDKCore";
    @NotNull
    private static final String sessionUUID;

    private TapOpenlogParameterKit() {
    }

    @NotNull
    public final Map<String, String> obtainGeneralProperties(@NotNull Context context) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Map it = map = (Map)new LinkedHashMap();
        boolean bl = false;
        it.put("timezone", TimeZone.getDefault().getID());
        it.put("app_package_name", context.getPackageName());
        it.put("app_version", DeviceUtils.getPackageVersion((Context)context));
        it.put("app_version_code", String.valueOf(DeviceUtils.getPackageVersionCode((Context)context)));
        it.put("pn", PARAM_PN);
        it.put("track_code", "1");
        it.put("sdk_locale", LocalizeManager.getPreferredLanguageString());
        it.put("device_id", TapIdentifierUtil.INSTANCE.getDeviceId(context));
        it.put("install_uuid", TapIdentifierUtil.INSTANCE.getInstallUUID());
        it.put("android_id", TapIdentifierUtil.getAndroidID((Context)context));
        it.put("dv", DeviceUtils.getManufacturer());
        it.put("md", DeviceUtils.getModel());
        it.put("cpu", DeviceUtils.getCpuInfo());
        it.put("cpu_abis", DeviceUtils.getCpuABIS());
        it.put("os", DeviceUtils.getPlatform());
        it.put("sv", DeviceUtils.getOS());
        int[] nArray = DeviceUtils.getDeviceSize((Context)context);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getDeviceSize(context)");
        int[] size = nArray;
        it.put("width", String.valueOf(size[0]));
        it.put("height", String.valueOf(size[1]));
        it.put("total_rom", String.valueOf(DeviceUtils.getDeviceTotalRom((Context)context)));
        it.put("total_ram", String.valueOf(DeviceUtils.getDeviceTotalRam((Context)context)));
        it.put("hardware", DeviceUtils.getCPUHardware());
        it.put("p_session_id", sessionUUID);
        return map;
    }

    @NotNull
    public final Map<String, String> obtainDynamicProperties(@NotNull Context context, @NotNull String sdkProject) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sdkProject, (String)"sdkProject");
        Map it = map = (Map)new LinkedHashMap();
        boolean bl = false;
        it.put("tapsdk_project", sdkProject);
        it.put("t_log_id", UUID.randomUUID().toString());
        it.put("timestamp", String.valueOf(System.currentTimeMillis()));
        if (TapOpenlogInner.INSTANCE.getRegionType$tap_openlog_release() == 0) {
            it.put("oaid", TapIdentifierUtil.INSTANCE.getOAID());
        }
        Map map2 = it;
        String string = "gid";
        String string2 = TapIdentifierUtil.INSTANCE.queryGID();
        if (string2 == null) {
            string2 = "";
        }
        String string3 = string2;
        map2.put(string, string3);
        it.put("rom", String.valueOf(DeviceUtils.getRemainingRomSize()));
        it.put("ram", String.valueOf(DeviceUtils.getRemainingRamSize((Context)context)));
        it.put("open_id", TapIdentifierUtil.INSTANCE.getOpenId());
        it.put("network_type", NetworkUtil.getConnectedType((Context)context));
        it.put("mobile_type", NetworkUtil.getNetworkType((Context)context));
        return map;
    }

    static {
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        sessionUUID = string;
    }
}

