/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.openlog.internal.log;

import android.net.Uri;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Base64;
import com.taptap.sdk.kit.internal.TapLogger;
import com.taptap.sdk.kit.internal.TapTapKit;
import com.taptap.sdk.kit.internal.store.ITapData;
import com.taptap.sdk.kit.internal.store.TapDataStore;
import com.taptap.sdk.kit.internal.utils.PlatformXUA;
import com.taptap.sdk.openlog.internal.TapOpenlogInner;
import com.taptap.sdk.openlog.internal.bean.TapLog;
import com.taptap.sdk.openlog.internal.bean.TapLogGroup;
import com.taptap.sdk.openlog.internal.log.BaseTapLogQueue;
import com.taptap.sdk.openlog.internal.log.TapLogStoreBean;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.serialization.BinaryFormat;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.protobuf.ProtoBuf;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0010 \n\u0002\b\u0002\b \u0018\u0000 #2\u00020\u0001:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000eH\u0007J\r\u0010\u001c\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001dJ\b\u0010\u001e\u001a\u00020\u001aH\u0005J\b\u0010\u001f\u001a\u00020\u0014H&J\u0016\u0010 \u001a\u00020!2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\"H\u0005R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR!\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0013\u001a\u00020\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0012\u0010\u0017\u001a\u00020\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016\u00a8\u0006$"}, d2={"Lcom/taptap/sdk/openlog/internal/log/BaseTapLogQueue;", "", "()V", "flushRunnable", "Ljava/lang/Runnable;", "scheduledFuture", "Ljava/util/concurrent/ScheduledFuture;", "singleThreadExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "getSingleThreadExecutor$tap_openlog_release", "()Ljava/util/concurrent/ScheduledExecutorService;", "store", "Lcom/taptap/sdk/kit/internal/store/TapDataStore;", "Lcom/taptap/sdk/openlog/internal/log/TapLogStoreBean;", "getStore", "()Lcom/taptap/sdk/kit/internal/store/TapDataStore;", "store$delegate", "Lkotlin/Lazy;", "tag", "", "getTag", "()Ljava/lang/String;", "urlPath", "getUrlPath", "add", "", "data", "flush", "flush$tap_openlog_release", "flushAndWait", "getHost", "report", "", "", "Companion", "tap-openlog_release"})
public abstract class BaseTapLogQueue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ScheduledFuture<?> scheduledFuture;
    @NotNull
    private final Lazy store$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TapDataStore<TapLogStoreBean>>(this){
        final /* synthetic */ BaseTapLogQueue this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final TapDataStore<TapLogStoreBean> invoke() {
            return new TapDataStore(TapTapKit.INSTANCE.getContext(), this.this$0.getTag() + "_persistedData", 1000, 0xA00000L);
        }
    }));
    @NotNull
    private final Runnable flushRunnable = () -> BaseTapLogQueue.flushRunnable$lambda$0(this);
    private final ScheduledExecutorService singleThreadExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(this){
        @NotNull
        private final AtomicInteger count;
        final /* synthetic */ BaseTapLogQueue this$0;
        {
            this.this$0 = $receiver;
            this.count = new AtomicInteger(1);
        }

        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            return new Thread(r, this.this$0.getTag() + "Task #" + this.count.getAndIncrement());
        }
    });
    private static final int NUM_LOG_EVENTS_TO_TRY_TO_FLUSH_AFTER = 50;
    private static final int FLUSH_PERIOD_IN_SECONDS = 15;

    @NotNull
    public abstract String getTag();

    @NotNull
    public abstract String getUrlPath();

    @NotNull
    public abstract String getHost();

    private final TapDataStore<TapLogStoreBean> getStore() {
        Lazy lazy = this.store$delegate;
        return (TapDataStore)lazy.getValue();
    }

    public final ScheduledExecutorService getSingleThreadExecutor$tap_openlog_release() {
        return this.singleThreadExecutor;
    }

    @WorkerThread
    public final void add(@NotNull TapLogStoreBean data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.getStore().addData((ITapData)data);
        if (!TapOpenlogInner.INSTANCE.isInitialized()) {
            return;
        }
        if (this.getStore().getAccumulatedDataCount() >= 50) {
            this.flushAndWait();
        } else if (this.scheduledFuture == null) {
            this.scheduledFuture = this.singleThreadExecutor.schedule(this.flushRunnable, 15L, TimeUnit.SECONDS);
        }
    }

    public final void flush$tap_openlog_release() {
        TapLogger.logd((String)this.getTag(), (String)"flush");
        this.singleThreadExecutor.execute(() -> BaseTapLogQueue.flush$lambda$1(this));
    }

    @WorkerThread
    protected final void flushAndWait() {
        List reportedData = TapDataStore.obtainData$default(this.getStore(), (int)0, (int)1, null);
        if (reportedData.isEmpty()) {
            return;
        }
        try {
            boolean success = this.report(reportedData);
            if (success) {
                this.getStore().clearInFlightAndStats(false);
                if (this.getStore().getAccumulatedDataCount() >= 50 && this.scheduledFuture == null) {
                    this.scheduledFuture = this.singleThreadExecutor.schedule(this.flushRunnable, 0L, TimeUnit.SECONDS);
                }
            } else {
                TapLogger.logd((String)this.getTag(), (String)("report failure\n" + reportedData));
                this.getStore().clearInFlightAndStats(true);
            }
        }
        catch (Exception e) {
            TapLogger.logd((String)this.getTag(), (String)"report failure", (Throwable)e);
            this.getStore().clearInFlightAndStats(true);
        }
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    protected final boolean report(@NotNull List<TapLogStoreBean> data) throws Exception {
        void $this$sortedBy$iv;
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(data, (String)"data");
        TapLogger.logd((String)this.getTag(), (String)("report start " + data.size() + " logs"));
        String string = new Uri.Builder().scheme("https").authority(this.getHost()).path(this.getUrlPath()).appendQueryParameter("client_id", TapOpenlogInner.INSTANCE.getClientId$tap_openlog_release()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Builder().scheme(\"https\"\u2026nner.clientId).toString()");
        String urlString = string;
        TapLogGroup logGroup = new TapLogGroup(null, 1, null);
        Iterable iterable = data;
        List<TapLog> list = logGroup.getLogs();
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TapLogStoreBean tapLogStoreBean = (TapLogStoreBean)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getLog());
        }
        list.addAll((List)destination$iv$iv);
        BinaryFormat $this$encodeToByteArray$iv = (BinaryFormat)ProtoBuf.Default;
        boolean $i$f$encodeToByteArray = false;
        SerializersModule $this$serializer$iv$iv = $this$encodeToByteArray$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(TapLogGroup.class));
        boolean $i$f$cast = false;
        Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
        byte[] originalContent = $this$encodeToByteArray$iv.encodeToByteArray((SerializationStrategy)$this$cast$iv$iv$iv, (Object)logGroup);
        byte[] compressContent = null;
        try {
            LZ4Compressor compressor = LZ4Factory.fastestJavaInstance().fastCompressor();
            byte[] byArray = compressor.compress(originalContent);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"compressor.compress(originalContent)");
            compressContent = byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        URL httpURL = new URL(urlString);
        URLConnection uRLConnection = httpURL.openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection urlConnection = (HttpURLConnection)uRLConnection;
        urlConnection.setDoOutput(true);
        urlConnection.setRequestMethod("POST");
        urlConnection.setConnectTimeout(10000);
        urlConnection.setReadTimeout(10000);
        urlConnection.setUseCaches(false);
        Map headers = new LinkedHashMap();
        headers.put("User-Agent", PlatformXUA.INSTANCE.getTrackUA());
        headers.put("Accept", "*/*");
        headers.put("Content-Type", "application/x-protobuf");
        headers.put("x-log-apiversion", "0.6.0");
        headers.put("x-log-compresstype", "lz4");
        headers.put("x-log-signaturemethod", "hmac-sha1");
        headers.put("x-log-timestamp", String.valueOf(System.currentTimeMillis()));
        byte[] byArray = MessageDigest.getInstance("MD5").digest(compressContent);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getInstance(\"MD5\").digest(compressContent)");
        String contentMD52 = ArraysKt.joinToString$default((byte[])byArray, (CharSequence)"", null, null, (int)0, null, (Function1)report.contentMD5.1.INSTANCE, (int)30, null);
        headers.put("Content-MD5", contentMD52);
        headers.put("x-log-bodyrawsize", String.valueOf(originalContent.length));
        Iterable $this$filter$iv = headers.keySet();
        boolean $i$f$filter = false;
        Iterable iterable2 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)it, (String)"x-log", (boolean)false, (int)2, null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$sortedBy = false;
        String headersMessage2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            /*
             * WARNING - void declaration
             */
            public final int compare(T a, T b) {
                void var3_3;
                String it = (String)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it);
                it = (String)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)var3_3));
            }
        }), (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>((Map<String, String>)headers){
            final /* synthetic */ Map<String, String> $headers;
            {
                this.$headers = $headers;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it + ':' + this.$headers.get(it);
            }
        }), (int)30, null);
        String message = "POST\n" + contentMD52 + "\napplication/x-protobuf\n" + headersMessage2 + '\n' + urlConnection.getURL().getPath();
        Mac $this$report_u24lambda_u246 = Mac.getInstance("HmacSHA1");
        boolean $i$a$-run-BaseTapLogQueue$report$32 = false;
        String clientToken = TapOpenlogInner.INSTANCE.getClientToken$tap_openlog_release();
        if (!TextUtils.isEmpty((CharSequence)clientToken)) {
            byte[] byArray2 = clientToken.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
            $this$report_u24lambda_u246.init(new SecretKeySpec(byArray2, "HmacSHA1"));
        }
        byte[] byArray3 = message.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"this as java.lang.String).getBytes(charset)");
        String signature = Base64.encodeToString((byte[])$this$report_u24lambda_u246.doFinal(byArray3), (int)2);
        headers.put("Authorization", "LOG " + TapOpenlogInner.INSTANCE.getClientId$tap_openlog_release() + ':' + signature);
        Object $this$forEach$iv = headers.keySet();
        boolean $i$f$forEach = false;
        Iterator $i$a$-run-BaseTapLogQueue$report$32 = $this$forEach$iv.iterator();
        while ($i$a$-run-BaseTapLogQueue$report$32.hasNext()) {
            Object element$iv = $i$a$-run-BaseTapLogQueue$report$32.next();
            String it = (String)element$iv;
            boolean bl = false;
            urlConnection.addRequestProperty(it, (String)headers.get(it));
        }
        Object $this$report_u24lambda_u248 = $this$forEach$iv = urlConnection.getOutputStream();
        boolean bl = false;
        ((OutputStream)$this$report_u24lambda_u248).write(compressContent);
        ((OutputStream)$this$report_u24lambda_u248).flush();
        int responseCode = urlConnection.getResponseCode();
        urlConnection.disconnect();
        return 200 <= responseCode ? responseCode < 300 : false;
    }

    private static final void flushRunnable$lambda$0(BaseTapLogQueue this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.scheduledFuture = null;
        this$0.flushAndWait();
    }

    private static final void flush$lambda$1(BaseTapLogQueue this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.flushAndWait();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/taptap/sdk/openlog/internal/log/BaseTapLogQueue$Companion;", "", "()V", "FLUSH_PERIOD_IN_SECONDS", "", "NUM_LOG_EVENTS_TO_TRY_TO_FLUSH_AFTER", "tap-openlog_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

