/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.openlog.internal.log;

import com.taptap.sdk.kit.internal.http.TapHttpUtil;
import com.taptap.sdk.kit.internal.http.hanlder.ITapHttpSign;
import com.taptap.sdk.kit.internal.utils.PlatformXUA;
import com.taptap.sdk.openlog.internal.TapOpenlogInner;
import com.taptap.sdk.openlog.internal.log.TapHttpSignOpenlog;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J,\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/taptap/sdk/openlog/internal/log/TapHttpSignOpenlog;", "Lcom/taptap/sdk/kit/internal/http/hanlder/ITapHttpSign;", "()V", "getFixQueryParams", "", "", "getHeaders", "moduleName", "moduleVersion", "method", "handle", "", "data", "Lcom/taptap/sdk/kit/internal/http/hanlder/ITapHttpSign$HandleData;", "tap-openlog_release"})
public final class TapHttpSignOpenlog
implements ITapHttpSign {
    @NotNull
    public Map<String, String> getFixQueryParams() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"client_id", (Object)TapOpenlogInner.INSTANCE.getClientId$tap_openlog_release())};
        return MapsKt.mutableMapOf((Pair[])pairArray);
    }

    @NotNull
    public Map<String, String> getHeaders(@NotNull String moduleName, @NotNull String moduleVersion, @NotNull String method) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)moduleVersion, (String)"moduleVersion");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        String string = method;
        if (Intrinsics.areEqual((Object)string, (Object)"POST")) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"User-Agent", (Object)PlatformXUA.getTrackUA()), TuplesKt.to((Object)"Accept", (Object)"*/*"), TuplesKt.to((Object)"x-log-apiversion", (Object)"0.6.0"), TuplesKt.to((Object)"x-log-compresstype", (Object)"lz4"), TuplesKt.to((Object)"x-log-signaturemethod", (Object)"hmac-sha1"), TuplesKt.to((Object)"x-log-timestamp", (Object)String.valueOf(System.currentTimeMillis()))};
            map = MapsKt.mutableMapOf((Pair[])pairArray);
        } else {
            map = Intrinsics.areEqual((Object)string, (Object)"GET") ? (Map)new LinkedHashMap() : (Map)new LinkedHashMap();
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public void handle(@NotNull ITapHttpSign.HandleData data) {
        void $this$sortedBy$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String path = new URL(data.getUrl()).getPath();
        byte[] byArray = MessageDigest.getInstance("MD5").digest(data.getCompressContent());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getInstance(\"MD5\").digest(data.compressContent)");
        String contentMD52 = ArraysKt.joinToString$default((byte[])byArray, (CharSequence)"", null, null, (int)0, null, (Function1)handle.contentMD5.1.INSTANCE, (int)30, null);
        data.getHeaders().put("Content-MD5", contentMD52);
        data.getHeaders().put("x-log-bodyrawsize", String.valueOf(data.getContent().length));
        Iterable $this$filter$iv = data.getHeaders().keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)it, (String)"x-log", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        String headersMessage2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            /*
             * WARNING - void declaration
             */
            public final int compare(T a, T b) {
                void var3_3;
                String it = (String)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it);
                it = (String)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)var3_3));
            }
        }), (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(data){
            final /* synthetic */ ITapHttpSign.HandleData $data;
            {
                this.$data = $data;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it + ':' + (String)this.$data.getHeaders().get(it);
            }
        }), (int)30, null);
        String stringToSign = data.getMethod() + '\n' + contentMD52 + "\napplication/x-protobuf\n" + headersMessage2 + '\n' + path;
        String signature = TapHttpUtil.INSTANCE.secret(TapOpenlogInner.INSTANCE.getClientToken$tap_openlog_release(), stringToSign, "HmacSHA1");
        data.getHeaders().put("Authorization", "LOG " + TapOpenlogInner.INSTANCE.getClientId$tap_openlog_release() + ':' + signature);
    }
}

