/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.openlog.internal.log;

import android.support.annotation.WorkerThread;
import com.taptap.sdk.kit.internal.TapLogger;
import com.taptap.sdk.kit.internal.TapTapKit;
import com.taptap.sdk.kit.internal.http.TapHttp;
import com.taptap.sdk.kit.internal.http.TapHttpExtKt;
import com.taptap.sdk.kit.internal.http.TapLogInterceptor;
import com.taptap.sdk.kit.internal.http.call.ITapHttpCall;
import com.taptap.sdk.kit.internal.http.hanlder.ITapHttpCompress;
import com.taptap.sdk.kit.internal.http.hanlder.ITapHttpSign;
import com.taptap.sdk.kit.internal.http.param.AbsTapHttpParam;
import com.taptap.sdk.kit.internal.json.TapJson;
import com.taptap.sdk.kit.internal.store.ITapData;
import com.taptap.sdk.kit.internal.store.TapDataStore;
import com.taptap.sdk.openlog.internal.TapOpenlogInner;
import com.taptap.sdk.openlog.internal.bean.TapLog;
import com.taptap.sdk.openlog.internal.bean.TapLogGroup;
import com.taptap.sdk.openlog.internal.log.TapHttpCompressLz4;
import com.taptap.sdk.openlog.internal.log.TapHttpSignOpenlog;
import com.taptap.sdk.openlog.internal.log.TapLogStoreBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlinx.serialization.BinaryFormat;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.protobuf.ProtoBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0010 \n\u0002\b\u0002\b \u0018\u0000 (2\u00020\u0001:\u0001(B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0014H\u0007J\r\u0010!\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b\"J\b\u0010#\u001a\u00020\u001fH\u0005J\b\u0010$\u001a\u00020\u0019H&J\u0016\u0010%\u001a\u00020&2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00140'H\u0005R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R!\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\n\u001a\u0004\b\u0015\u0010\u0016R\u0012\u0010\u0018\u001a\u00020\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0012\u0010\u001c\u001a\u00020\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001b\u00a8\u0006)"}, d2={"Lcom/taptap/sdk/openlog/internal/log/BaseTapLogQueue;", "", "()V", "flushRunnable", "Ljava/lang/Runnable;", "http", "Lcom/taptap/sdk/kit/internal/http/TapHttp;", "getHttp", "()Lcom/taptap/sdk/kit/internal/http/TapHttp;", "http$delegate", "Lkotlin/Lazy;", "scheduledFuture", "Ljava/util/concurrent/ScheduledFuture;", "singleThreadExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "getSingleThreadExecutor$tap_openlog_release", "()Ljava/util/concurrent/ScheduledExecutorService;", "store", "Lcom/taptap/sdk/kit/internal/store/TapDataStore;", "Lcom/taptap/sdk/openlog/internal/log/TapLogStoreBean;", "getStore", "()Lcom/taptap/sdk/kit/internal/store/TapDataStore;", "store$delegate", "tag", "", "getTag", "()Ljava/lang/String;", "urlPath", "getUrlPath", "add", "", "data", "flush", "flush$tap_openlog_release", "flushAndWait", "getHost", "report", "", "", "Companion", "tap-openlog_release"})
public abstract class BaseTapLogQueue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ScheduledFuture<?> scheduledFuture;
    @NotNull
    private final Lazy store$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TapDataStore<TapLogStoreBean>>(this){
        final /* synthetic */ BaseTapLogQueue this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final TapDataStore<TapLogStoreBean> invoke() {
            return new TapDataStore(TapTapKit.INSTANCE.getContext(), this.this$0.getTag() + "_persistedData", 1000, 0xA00000L);
        }
    }));
    @NotNull
    private final Lazy http$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TapHttp>(this){
        final /* synthetic */ BaseTapLogQueue this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final TapHttp invoke() {
            return TapHttp.Companion.newBuilder("TapSDKCore", "4.3.1").domain(this.this$0.getHost()).signHandler((ITapHttpSign)new TapHttpSignOpenlog()).compressHandler((ITapHttpCompress)new TapHttpCompressLz4()).debugLogLevel(TapLogInterceptor.Level.HEADERS).setTechnicalLogEnable(false).build();
        }
    }));
    @NotNull
    private final Runnable flushRunnable = () -> BaseTapLogQueue.flushRunnable$lambda$0(this);
    private final ScheduledExecutorService singleThreadExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(this){
        @NotNull
        private final AtomicInteger count;
        final /* synthetic */ BaseTapLogQueue this$0;
        {
            this.this$0 = $receiver;
            this.count = new AtomicInteger(1);
        }

        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            return new Thread(r, this.this$0.getTag() + "Task #" + this.count.getAndIncrement());
        }
    });
    private static final int NUM_LOG_EVENTS_TO_TRY_TO_FLUSH_AFTER = 50;
    private static final int FLUSH_PERIOD_IN_SECONDS = 15;

    @NotNull
    public abstract String getTag();

    @NotNull
    public abstract String getUrlPath();

    @NotNull
    public abstract String getHost();

    private final TapDataStore<TapLogStoreBean> getStore() {
        Lazy lazy = this.store$delegate;
        return (TapDataStore)lazy.getValue();
    }

    private final TapHttp getHttp() {
        Lazy lazy = this.http$delegate;
        return (TapHttp)lazy.getValue();
    }

    public final ScheduledExecutorService getSingleThreadExecutor$tap_openlog_release() {
        return this.singleThreadExecutor;
    }

    @WorkerThread
    public final void add(@NotNull TapLogStoreBean data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.getStore().addData((ITapData)data);
        if (!TapOpenlogInner.INSTANCE.isInitialized()) {
            return;
        }
        if (this.getStore().getAccumulatedDataCount() >= 50) {
            this.flushAndWait();
        } else if (this.scheduledFuture == null) {
            this.scheduledFuture = this.singleThreadExecutor.schedule(this.flushRunnable, 15L, TimeUnit.SECONDS);
        }
    }

    public final void flush$tap_openlog_release() {
        TapLogger.logd((String)this.getTag(), (String)"flush");
        this.singleThreadExecutor.execute(() -> BaseTapLogQueue.flush$lambda$1(this));
    }

    @WorkerThread
    protected final void flushAndWait() {
        block9: {
            List reportedData = TapDataStore.obtainData$default(this.getStore(), (int)0, (int)1, null);
            if (reportedData.isEmpty()) {
                return;
            }
            try {
                boolean success = this.report(reportedData);
                if (success) {
                    if (TapTapKit.INSTANCE.isRND()) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("TapOpenlog report " + reportedData.size() + " logs \u2193 \u2193 \u2193\n");
                        Iterable $this$forEach$iv = reportedData;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            String string;
                            TapLogStoreBean it = (TapLogStoreBean)element$iv;
                            boolean bl = false;
                            TapJson this_$iv = TapJson.INSTANCE;
                            boolean $i$f$encodeToString = false;
                            try {
                                StringFormat $this$encodeToString$iv$iv = (StringFormat)this_$iv.getJson();
                                boolean $i$f$encodeToString2 = false;
                                SerializersModule $this$serializer$iv$iv$iv = $this$encodeToString$iv$iv.getSerializersModule();
                                boolean $i$f$serializer = false;
                                KSerializer $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv, (KType)Reflection.typeOf(TapLogStoreBean.class));
                                boolean $i$f$cast = false;
                                Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
                                string = $this$encodeToString$iv$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv$iv, (Object)it);
                            }
                            catch (Exception e$iv) {
                                TapLogger.loge$default((String)"TapJson", null, (Throwable)e$iv, (int)2, null);
                                string = null;
                            }
                            String jsonStr = string;
                            sb.append(jsonStr + '\n');
                        }
                        TapLogger.logd((String)this.getTag(), (String)sb.toString());
                    }
                    this.getStore().clearInFlightAndStats(false);
                    if (this.getStore().getAccumulatedDataCount() >= 50 && this.scheduledFuture == null) {
                        this.scheduledFuture = this.singleThreadExecutor.schedule(this.flushRunnable, 0L, TimeUnit.SECONDS);
                    }
                    break block9;
                }
                TapLogger.logd((String)this.getTag(), (String)("report failure\n" + reportedData));
                this.getStore().clearInFlightAndStats(true);
            }
            catch (Exception e) {
                TapLogger.logd((String)this.getTag(), (String)"report failure", (Throwable)e);
                this.getStore().clearInFlightAndStats(true);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    protected final boolean report(@NotNull List<TapLogStoreBean> data) throws Exception {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(data, (String)"data");
        TapLogger.logd((String)this.getTag(), (String)("report start " + data.size() + " logs"));
        TapLogGroup logGroup = new TapLogGroup(null, 1, null);
        Iterable iterable = data;
        List<TapLog> list = logGroup.getLogs();
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TapLogStoreBean tapLogStoreBean = (TapLogStoreBean)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getLog());
        }
        list.addAll((List)destination$iv$iv);
        Object result2 = ITapHttpCall.DefaultImpls.executeResult-IoAF18A$default((ITapHttpCall)((ITapHttpCall)TapHttpExtKt.toOpenLogCall((AbsTapHttpParam)((AbsTapHttpParam)this.getHttp().postProtobuf(this.getUrlPath(), (Function0)new Function0<byte[]>(logGroup){
            final /* synthetic */ TapLogGroup $logGroup;
            {
                this.$logGroup = $logGroup;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final byte[] invoke() {
                void $this$encodeToByteArray$iv;
                BinaryFormat binaryFormat = (BinaryFormat)ProtoBuf.Default;
                TapLogGroup value$iv = this.$logGroup;
                boolean $i$f$encodeToByteArray = false;
                SerializersModule $this$serializer$iv$iv = $this$encodeToByteArray$iv.getSerializersModule();
                boolean $i$f$serializer = false;
                KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(TapLogGroup.class));
                boolean $i$f$cast = false;
                Intrinsics.checkNotNull((Object)$this$cast$iv$iv$iv, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<T of kotlinx.serialization.internal.Platform_commonKt.cast>");
                return $this$encodeToByteArray$iv.encodeToByteArray((SerializationStrategy)$this$cast$iv$iv$iv, (Object)value$iv);
            }
        })))), (long)0L, (int)1, null);
        return Result.isSuccess-impl((Object)result2);
    }

    private static final void flushRunnable$lambda$0(BaseTapLogQueue this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.scheduledFuture = null;
        this$0.flushAndWait();
    }

    private static final void flush$lambda$1(BaseTapLogQueue this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.flushAndWait();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/taptap/sdk/openlog/internal/log/BaseTapLogQueue$Companion;", "", "()V", "FLUSH_PERIOD_IN_SECONDS", "", "NUM_LOG_EVENTS_TO_TRY_TO_FLUSH_AFTER", "tap-openlog_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

