/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.openlog;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import com.taptap.sdk.base.utils.lifecycle.TapActivityLifecycleCallbacks;
import com.taptap.sdk.base.utils.lifecycle.TapActivityLifecycleTracker;
import com.taptap.sdk.initializer.api.model.RegionType;
import com.taptap.sdk.initializer.api.option.TapTapSdkOptions;
import com.taptap.sdk.kit.internal.TapLogger;
import com.taptap.sdk.kit.internal.openlog.ITapOpenlog;
import com.taptap.sdk.openlog.TapTapOpenlogSdk;
import com.taptap.sdk.openlog.internal.OpenLogImpl;
import com.taptap.sdk.openlog.internal.TapOpenLogRemote;
import com.taptap.sdk.openlog.utils.JsonUtils;
import com.taptap.sdk.openlog.utils.OpenlogExtrasUtils;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000U\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003*\u0001\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)J\u0016\u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020\u00142\u0006\u0010,\u001a\u00020-J\u0006\u0010.\u001a\u00020)J\u0006\u0010\u001e\u001a\u00020)J\b\u0010/\u001a\u00020'H\u0002J\u0010\u00100\u001a\u00020'2\b\u00101\u001a\u0004\u0018\u00010\u0004J\u0006\u00102\u001a\u00020'J\u0018\u00103\u001a\u0004\u0018\u0001042\u0006\u00105\u001a\u00020\u00042\u0006\u00106\u001a\u00020\u0004J\u000e\u00107\u001a\u00020'2\u0006\u00108\u001a\u00020\u0004J\u001c\u00107\u001a\u00020'2\u0014\u00109\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010:J\b\u0010;\u001a\u00020'H\u0002J\b\u0010<\u001a\u00020'H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R+\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00048@@@X\u0080\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR+\u0010\u0010\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00048@@@X\u0080\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u000f\u001a\u0004\b\u0011\u0010\u000b\"\u0004\b\u0012\u0010\rR+\u0010\u0015\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u00148@@@X\u0080\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u000f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010 \u001a\u00020\u001f2\u0006\u0010\b\u001a\u00020\u001f8@@@X\u0080\u008e\u0002\u00a2\u0006\u0012\n\u0004\b%\u0010\u000f\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u0006="}, d2={"Lcom/taptap/sdk/openlog/TapTapOpenlogSdk;", "", "()V", "TAG", "", "activityLifecycleCallbacks", "com/taptap/sdk/openlog/TapTapOpenlogSdk$activityLifecycleCallbacks$1", "Lcom/taptap/sdk/openlog/TapTapOpenlogSdk$activityLifecycleCallbacks$1;", "<set-?>", "clientId", "getClientId$tap_openlog_release", "()Ljava/lang/String;", "setClientId$tap_openlog_release", "(Ljava/lang/String;)V", "clientId$delegate", "Lkotlin/properties/ReadWriteProperty;", "clientToken", "getClientToken$tap_openlog_release", "setClientToken$tap_openlog_release", "clientToken$delegate", "Landroid/content/Context;", "context", "getContext$tap_openlog_release", "()Landroid/content/Context;", "setContext$tap_openlog_release", "(Landroid/content/Context;)V", "context$delegate", "currentOpenId", "heartbeatEnabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isHeartbeatStarted", "Lcom/taptap/sdk/initializer/api/model/RegionType;", "region", "getRegion$tap_openlog_release", "()Lcom/taptap/sdk/initializer/api/model/RegionType;", "setRegion$tap_openlog_release", "(Lcom/taptap/sdk/initializer/api/model/RegionType;)V", "region$delegate", "enableHeartbeat", "", "enabled", "", "initialize", "ctx", "options", "Lcom/taptap/sdk/initializer/api/option/TapTapSdkOptions;", "isHeartbeatEnabled", "loadNativeLibrary", "login", "openId", "logout", "obtainOpenlog", "Lcom/taptap/sdk/kit/internal/openlog/ITapOpenlog;", "project", "version", "setExtraAppDurationParams", "jsonStr", "extras", "", "start", "stop", "tap-openlog_release"})
public final class TapTapOpenlogSdk {
    @NotNull
    public static final TapTapOpenlogSdk INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final String TAG = "OpenLogInitializeTask";
    @NotNull
    private static final ReadWriteProperty context$delegate;
    @NotNull
    private static final ReadWriteProperty region$delegate;
    @NotNull
    private static final ReadWriteProperty clientId$delegate;
    @NotNull
    private static final ReadWriteProperty clientToken$delegate;
    @NotNull
    private static final AtomicBoolean isHeartbeatStarted;
    @NotNull
    private static final AtomicBoolean heartbeatEnabled;
    @Nullable
    private static String currentOpenId;
    @NotNull
    private static final activityLifecycleCallbacks.1 activityLifecycleCallbacks;

    private TapTapOpenlogSdk() {
    }

    @NotNull
    public final Context getContext$tap_openlog_release() {
        return (Context)context$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public final void setContext$tap_openlog_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"<set-?>");
        context$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)context);
    }

    @NotNull
    public final RegionType getRegion$tap_openlog_release() {
        return (RegionType)region$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    public final void setRegion$tap_openlog_release(@NotNull RegionType regionType) {
        Intrinsics.checkNotNullParameter((Object)regionType, (String)"<set-?>");
        region$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)regionType);
    }

    @NotNull
    public final String getClientId$tap_openlog_release() {
        return (String)clientId$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    public final void setClientId$tap_openlog_release(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        clientId$delegate.setValue((Object)this, $$delegatedProperties[2], (Object)string);
    }

    @NotNull
    public final String getClientToken$tap_openlog_release() {
        return (String)clientToken$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    public final void setClientToken$tap_openlog_release(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        clientToken$delegate.setValue((Object)this, $$delegatedProperties[3], (Object)string);
    }

    public final void initialize(@NotNull Context ctx, @NotNull TapTapSdkOptions options) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.setContext$tap_openlog_release(ctx);
        this.setRegion$tap_openlog_release(options.getRegion());
        this.setClientId$tap_openlog_release(options.getClientId());
        this.setClientToken$tap_openlog_release(options.getClientToken());
        this.loadNativeLibrary();
        TapOpenLogRemote.INSTANCE.onAppStarted(JsonUtils.INSTANCE.stringify(OpenlogExtrasUtils.INSTANCE.getConfig(this.getContext$tap_openlog_release())));
    }

    private final void loadNativeLibrary() {
        try {
            System.loadLibrary("tapsdkcore");
            TapLogger.logd((String)TAG, (String)"initialize end");
        }
        catch (Throwable e) {
            TapLogger.loge((String)TAG, (String)"initialize failure", (Throwable)e);
        }
    }

    public final void enableHeartbeat(boolean enabled) {
        if (this.isHeartbeatEnabled() == enabled) {
            return;
        }
        heartbeatEnabled.set(enabled);
        if (enabled) {
            this.start();
        } else {
            this.stop();
        }
    }

    private final void start() {
        if (!this.isHeartbeatEnabled() || this.isHeartbeatStarted()) {
            return;
        }
        TapActivityLifecycleTracker.INSTANCE.registerActivityLifecycleCallbacks((TapActivityLifecycleCallbacks)activityLifecycleCallbacks);
        isHeartbeatStarted.set(TapOpenLogRemote.INSTANCE.onAppStarted(JsonUtils.INSTANCE.stringify(OpenlogExtrasUtils.INSTANCE.getConfig(this.getContext$tap_openlog_release()))) == 0);
        String[] stringArray = new String[]{"app_duration"};
        String string = new JSONArray((Object)stringArray).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JSONArray(arrayOf(\"app_duration\")).toString()");
        TapOpenLogRemote.INSTANCE.enableModules(string);
    }

    private final void stop() {
        TapActivityLifecycleTracker.INSTANCE.unregisterActivityLifecycleCallbacks((TapActivityLifecycleCallbacks)activityLifecycleCallbacks);
        isHeartbeatStarted.set(false);
        String[] stringArray = new String[]{"app_duration"};
        String string = new JSONArray((Object)stringArray).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JSONArray(arrayOf(\"app_duration\")).toString()");
        TapOpenLogRemote.INSTANCE.disableModules(string);
    }

    public final boolean isHeartbeatStarted() {
        return isHeartbeatStarted.get();
    }

    public final boolean isHeartbeatEnabled() {
        return heartbeatEnabled.get();
    }

    public final void login(@Nullable String openId) {
        CharSequence charSequence = openId;
        if (charSequence == null || charSequence.length() == 0) {
            TapLogger.logd((String)TAG, (String)("openId \u975e\u6cd5, openId = " + openId));
            return;
        }
        if (Intrinsics.areEqual((Object)currentOpenId, (Object)openId)) {
            TapLogger.logd((String)TAG, (String)("openId \u4e0e\u5f53\u524d\u4e00\u81f4 currentOpenId = " + currentOpenId + " , openId = " + openId));
            return;
        }
        currentOpenId = openId;
        TapOpenLogRemote.INSTANCE.onLogin(JsonUtils.INSTANCE.stringify(MapsKt.mapOf((Pair)TuplesKt.to((Object)"open_id", (Object)openId))));
    }

    public final void logout() {
        currentOpenId = null;
        TapOpenLogRemote.INSTANCE.onLogout();
    }

    public final void setExtraAppDurationParams(@NotNull Map<String, ? extends Object> extras) {
        Intrinsics.checkNotNullParameter(extras, (String)"extras");
        TapOpenLogRemote.INSTANCE.setExtraAppDurationParams(JsonUtils.INSTANCE.stringify(extras));
    }

    public final void setExtraAppDurationParams(@NotNull String jsonStr) {
        Intrinsics.checkNotNullParameter((Object)jsonStr, (String)"jsonStr");
        TapOpenLogRemote.INSTANCE.setExtraAppDurationParams(jsonStr);
    }

    @Nullable
    public final ITapOpenlog obtainOpenlog(@NotNull String project, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return new OpenLogImpl(project, version);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(TapTapOpenlogSdk.class, "context", "getContext$tap_openlog_release()Landroid/content/Context;", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(TapTapOpenlogSdk.class, "region", "getRegion$tap_openlog_release()Lcom/taptap/sdk/initializer/api/model/RegionType;", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(TapTapOpenlogSdk.class, "clientId", "getClientId$tap_openlog_release()Ljava/lang/String;", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(TapTapOpenlogSdk.class, "clientToken", "getClientToken$tap_openlog_release()Ljava/lang/String;", 0)))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new TapTapOpenlogSdk();
        context$delegate = Delegates.INSTANCE.notNull();
        region$delegate = Delegates.INSTANCE.notNull();
        clientId$delegate = Delegates.INSTANCE.notNull();
        clientToken$delegate = Delegates.INSTANCE.notNull();
        isHeartbeatStarted = new AtomicBoolean(false);
        heartbeatEnabled = new AtomicBoolean(false);
        activityLifecycleCallbacks = new TapActivityLifecycleCallbacks(){

            public void onForeground(@NotNull Context context) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                TapActivityLifecycleCallbacks.DefaultImpls.onForeground((TapActivityLifecycleCallbacks)this, (Context)context);
                if (TapTapOpenlogSdk.INSTANCE.isHeartbeatEnabled()) {
                    TapOpenLogRemote.INSTANCE.onForeground();
                }
            }

            public void onBackground(@NotNull Context context) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                TapActivityLifecycleCallbacks.DefaultImpls.onBackground((TapActivityLifecycleCallbacks)this, (Context)context);
                if (TapTapOpenlogSdk.INSTANCE.isHeartbeatEnabled()) {
                    TapOpenLogRemote.INSTANCE.onBackground();
                }
            }

            public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
                TapActivityLifecycleCallbacks.DefaultImpls.onActivityCreated((TapActivityLifecycleCallbacks)this, (Activity)activity, (Bundle)savedInstanceState);
            }

            public void onActivityDestroyed(@NotNull Activity activity) {
                TapActivityLifecycleCallbacks.DefaultImpls.onActivityDestroyed((TapActivityLifecycleCallbacks)this, (Activity)activity);
            }

            public void onActivityPaused(@NotNull Activity activity) {
                TapActivityLifecycleCallbacks.DefaultImpls.onActivityPaused((TapActivityLifecycleCallbacks)this, (Activity)activity);
            }

            public void onActivityResumed(@NotNull Activity activity) {
                TapActivityLifecycleCallbacks.DefaultImpls.onActivityResumed((TapActivityLifecycleCallbacks)this, (Activity)activity);
            }

            public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
                TapActivityLifecycleCallbacks.DefaultImpls.onActivitySaveInstanceState((TapActivityLifecycleCallbacks)this, (Activity)activity, (Bundle)outState);
            }

            public void onActivityStarted(@NotNull Activity activity) {
                TapActivityLifecycleCallbacks.DefaultImpls.onActivityStarted((TapActivityLifecycleCallbacks)this, (Activity)activity);
            }

            public void onActivityStopped(@NotNull Activity activity) {
                TapActivityLifecycleCallbacks.DefaultImpls.onActivityStopped((TapActivityLifecycleCallbacks)this, (Activity)activity);
            }
        };
    }
}

