/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.openlog.utils;

import android.content.Context;
import com.taptap.sdk.common.services.GidService;
import com.taptap.sdk.core.DBService;
import com.taptap.sdk.initializer.api.model.RegionType;
import com.taptap.sdk.kit.internal.TapTapKit;
import com.taptap.sdk.kit.internal.identifier.TapIdentifierUtil;
import com.taptap.sdk.kit.internal.utils.DeviceUtils;
import com.taptap.sdk.kit.internal.utils.NetworkUtil;
import com.taptap.sdk.kit.internal.utils.PlatformXUA;
import com.taptap.sdk.kit.internal.utils.localize.TapLocalizeUtil;
import com.taptap.sdk.openlog.TapTapOpenlogSdk;
import com.taptap.sdk.servicemanager.ServiceManager;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u00102\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000103H\u0002J\u001c\u00104\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0001032\u0006\u00105\u001a\u000206J\u0018\u00107\u001a\u00020\u00042\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u0004H\u0002J\u0014\u0010;\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u000103J\b\u0010<\u001a\u00020\u0004H\u0002J\u0016\u0010=\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040>H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u0004\u0018\u00010/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u0004\u0018\u000101X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/taptap/sdk/openlog/utils/OpenlogExtrasUtils;", "", "()V", "PARAM_ANDROID_ID", "", "PARAM_APP_PACKAGE_NAME", "PARAM_APP_VERSION", "PARAM_APP_VERSION_CODE", "PARAM_CLIENT_ID", "PARAM_CLIENT_TOKEN", "PARAM_COMMON_OPEN_ID", "PARAM_CPU", "PARAM_CPU_ABIS", "PARAM_DATA_DIR", "PARAM_DEVICE_ID", "PARAM_DV", "PARAM_ENABLE_AUTO_TEST_LOG", "PARAM_ENV", "PARAM_GAID", "PARAM_GAME_USER_ID", "PARAM_GID", "PARAM_HARDWARE", "PARAM_HEIGHT", "PARAM_INSTALL_UUID", "PARAM_LOG_LEVEL", "PARAM_LOG_TO_CONSOLE", "PARAM_MD", "PARAM_MOBILE_TYPE", "PARAM_NETWORK_TYPE", "PARAM_OAID", "PARAM_OPEN_ID", "PARAM_OS", "PARAM_PLATFORM", "PARAM_PN", "PARAM_RAM", "PARAM_REGION", "PARAM_ROM", "PARAM_SDK_LOCALE", "PARAM_SV", "PARAM_TAPSDK_ARTIFACT", "PARAM_TIMEZONE", "PARAM_TOTAL_RAM", "PARAM_TOTAL_ROM", "PARAM_UA", "PARAM_WIDTH", "PATH_DATA_DIR", "dbService", "Lcom/taptap/sdk/core/DBService;", "gidService", "Lcom/taptap/sdk/common/services/GidService;", "getCommonExtras", "", "getConfig", "context", "Landroid/content/Context;", "getDataDir", "filesDir", "Ljava/io/File;", "path", "getDynamicExtras", "getEnvironment", "getOAIDorGAID", "Lkotlin/Pair;", "tap-openlog_release"})
public final class OpenlogExtrasUtils {
    @NotNull
    public static final OpenlogExtrasUtils INSTANCE = new OpenlogExtrasUtils();
    @NotNull
    private static final String PARAM_TIMEZONE = "timezone";
    @NotNull
    private static final String PARAM_APP_PACKAGE_NAME = "app_package_name";
    @NotNull
    private static final String PARAM_APP_VERSION = "app_version";
    @NotNull
    private static final String PARAM_APP_VERSION_CODE = "app_version_code";
    @NotNull
    private static final String PARAM_PN = "pn";
    @NotNull
    private static final String PARAM_PLATFORM = "platform";
    @NotNull
    private static final String PARAM_SDK_LOCALE = "sdk_locale";
    @NotNull
    private static final String PARAM_DEVICE_ID = "device_id";
    @NotNull
    private static final String PARAM_INSTALL_UUID = "install_uuid";
    @NotNull
    private static final String PARAM_ANDROID_ID = "android_id";
    @NotNull
    private static final String PARAM_DV = "dv";
    @NotNull
    private static final String PARAM_MD = "md";
    @NotNull
    private static final String PARAM_CPU = "cpu";
    @NotNull
    private static final String PARAM_CPU_ABIS = "cpu_abis";
    @NotNull
    private static final String PARAM_OS = "os";
    @NotNull
    private static final String PARAM_SV = "sv";
    @NotNull
    private static final String PARAM_WIDTH = "width";
    @NotNull
    private static final String PARAM_HEIGHT = "height";
    @NotNull
    private static final String PARAM_TOTAL_ROM = "total_rom";
    @NotNull
    private static final String PARAM_TOTAL_RAM = "total_ram";
    @NotNull
    private static final String PARAM_HARDWARE = "hardware";
    @NotNull
    private static final String PARAM_REGION = "region";
    @NotNull
    private static final String PARAM_LOG_TO_CONSOLE = "log_to_console";
    @NotNull
    private static final String PARAM_LOG_LEVEL = "log_level";
    @NotNull
    private static final String PARAM_TAPSDK_ARTIFACT = "tapsdk_artifact";
    @NotNull
    private static final String PARAM_ENV = "env";
    @NotNull
    private static final String PARAM_UA = "ua";
    @NotNull
    private static final String PARAM_CLIENT_ID = "client_id";
    @NotNull
    private static final String PARAM_CLIENT_TOKEN = "client_token";
    @NotNull
    private static final String PARAM_DATA_DIR = "data_dir";
    @NotNull
    private static final String PATH_DATA_DIR = "tapsdk";
    @NotNull
    public static final String PARAM_COMMON_OPEN_ID = "open_id";
    @NotNull
    private static final String PARAM_GAME_USER_ID = "game_user_id";
    @NotNull
    private static final String PARAM_GID = "gid";
    @NotNull
    private static final String PARAM_ROM = "rom";
    @NotNull
    private static final String PARAM_RAM = "ram";
    @NotNull
    private static final String PARAM_OPEN_ID = "open_id";
    @NotNull
    private static final String PARAM_NETWORK_TYPE = "network_type";
    @NotNull
    private static final String PARAM_MOBILE_TYPE = "mobile_type";
    @NotNull
    private static final String PARAM_OAID = "oaid";
    @NotNull
    private static final String PARAM_GAID = "gaid";
    @NotNull
    private static final String PARAM_ENABLE_AUTO_TEST_LOG = "enable_auto_test_log";
    @Nullable
    private static final DBService dbService = (DBService)ServiceManager.Companion.getService(DBService.class);
    @Nullable
    private static final GidService gidService = (GidService)ServiceManager.Companion.getService(GidService.class);

    private OpenlogExtrasUtils() {
    }

    @NotNull
    public final Map<String, Object> getConfig(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Pair[] pairArray = new Pair[12];
        pairArray[0] = TuplesKt.to((Object)PARAM_REGION, (Object)(TapTapKit.INSTANCE.isRND() ? 2 : TapTapOpenlogSdk.INSTANCE.getRegion$tap_openlog_release().getCode()));
        pairArray[1] = TuplesKt.to((Object)PARAM_LOG_TO_CONSOLE, (Object)0);
        pairArray[2] = TuplesKt.to((Object)PARAM_LOG_LEVEL, (Object)1);
        pairArray[3] = TuplesKt.to((Object)PARAM_ENABLE_AUTO_TEST_LOG, (Object)1);
        File file = context.getFilesDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"context.filesDir");
        pairArray[4] = TuplesKt.to((Object)PARAM_DATA_DIR, (Object)this.getDataDir(file, PATH_DATA_DIR));
        pairArray[5] = TuplesKt.to((Object)PARAM_ENV, (Object)this.getEnvironment());
        pairArray[6] = TuplesKt.to((Object)PARAM_PLATFORM, (Object)"Android");
        pairArray[7] = TuplesKt.to((Object)PARAM_UA, (Object)PlatformXUA.getTrackUA());
        pairArray[8] = TuplesKt.to((Object)PARAM_CLIENT_ID, (Object)TapTapOpenlogSdk.INSTANCE.getClientId$tap_openlog_release());
        pairArray[9] = TuplesKt.to((Object)PARAM_CLIENT_TOKEN, (Object)TapTapOpenlogSdk.INSTANCE.getClientToken$tap_openlog_release());
        pairArray[10] = TuplesKt.to((Object)"common", this.getCommonExtras());
        pairArray[11] = TuplesKt.to((Object)"app_duration", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"tapsdk_version", (Object)"4.5.9")));
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final Map<String, Object> getCommonExtras() {
        Map raw;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)PARAM_APP_PACKAGE_NAME, (Object)TapTapOpenlogSdk.INSTANCE.getContext$tap_openlog_release().getPackageName()), TuplesKt.to((Object)PARAM_APP_VERSION, (Object)DeviceUtils.getPackageVersion((Context)TapTapOpenlogSdk.INSTANCE.getContext$tap_openlog_release())), TuplesKt.to((Object)PARAM_APP_VERSION_CODE, (Object)String.valueOf(DeviceUtils.getPackageVersionCode((Context)TapTapOpenlogSdk.INSTANCE.getContext$tap_openlog_release()))), TuplesKt.to((Object)PARAM_PN, (Object)"TapSDK"), TuplesKt.to((Object)PARAM_PLATFORM, (Object)"Android"), TuplesKt.to((Object)PARAM_DEVICE_ID, (Object)TapIdentifierUtil.INSTANCE.getDeviceId(TapTapOpenlogSdk.INSTANCE.getContext$tap_openlog_release())), TuplesKt.to((Object)PARAM_INSTALL_UUID, (Object)TapIdentifierUtil.INSTANCE.getInstallUUID()), TuplesKt.to((Object)PARAM_ANDROID_ID, (Object)TapIdentifierUtil.getAndroidID((Context)TapTapOpenlogSdk.INSTANCE.getContext$tap_openlog_release())), TuplesKt.to((Object)PARAM_DV, (Object)DeviceUtils.getManufacturer()), TuplesKt.to((Object)PARAM_MD, (Object)DeviceUtils.getModel()), TuplesKt.to((Object)PARAM_CPU, (Object)DeviceUtils.getCpuInfo()), TuplesKt.to((Object)PARAM_CPU_ABIS, (Object)DeviceUtils.getCpuABIS()), TuplesKt.to((Object)PARAM_OS, (Object)DeviceUtils.getPlatform()), TuplesKt.to((Object)PARAM_SV, (Object)DeviceUtils.getOS()), TuplesKt.to((Object)PARAM_WIDTH, (Object)String.valueOf(DeviceUtils.getDeviceSize((Context)TapTapOpenlogSdk.INSTANCE.getContext$tap_openlog_release())[0])), TuplesKt.to((Object)PARAM_HEIGHT, (Object)String.valueOf(DeviceUtils.getDeviceSize((Context)TapTapOpenlogSdk.INSTANCE.getContext$tap_openlog_release())[1])), TuplesKt.to((Object)PARAM_TOTAL_ROM, (Object)String.valueOf(DeviceUtils.getDeviceTotalRom((Context)TapTapOpenlogSdk.INSTANCE.getContext$tap_openlog_release()))), TuplesKt.to((Object)PARAM_TOTAL_RAM, (Object)String.valueOf(DeviceUtils.getDeviceTotalRam((Context)TapTapOpenlogSdk.INSTANCE.getContext$tap_openlog_release()))), TuplesKt.to((Object)PARAM_HARDWARE, (Object)DeviceUtils.getCPUHardware()), TuplesKt.to((Object)PARAM_SDK_LOCALE, (Object)TapLocalizeUtil.getPreferredLanguage().getLanguage()), TuplesKt.to((Object)"open_id", (Object)TapIdentifierUtil.INSTANCE.getOpenId())};
        Map $this$filterValues$iv = raw = MapsKt.mapOf((Pair[])pairArray);
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            String value = (String)entry$iv.getValue();
            boolean bl = false;
            if (!(value != null)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return result$iv;
    }

    @NotNull
    public final Map<String, Object> getDynamicExtras() {
        Map raw;
        Pair[] pairArray = new Pair[11];
        pairArray[0] = TuplesKt.to((Object)PARAM_TIMEZONE, (Object)TimeZone.getDefault().getID());
        pairArray[1] = TuplesKt.to((Object)PARAM_TAPSDK_ARTIFACT, (Object)PlatformXUA.getTrackSDKArtifact());
        pairArray[2] = this.getOAIDorGAID();
        pairArray[3] = TuplesKt.to((Object)PARAM_GAME_USER_ID, (Object)TapIdentifierUtil.INSTANCE.getGameUserId());
        pairArray[4] = TuplesKt.to((Object)"open_id", (Object)TapIdentifierUtil.INSTANCE.getOpenId());
        GidService gidService = OpenlogExtrasUtils.gidService;
        pairArray[5] = TuplesKt.to((Object)PARAM_GID, (Object)(gidService != null ? gidService.getCurrentGid() : null));
        pairArray[6] = TuplesKt.to((Object)PARAM_ROM, (Object)String.valueOf(DeviceUtils.getRemainingRomSize()));
        pairArray[7] = TuplesKt.to((Object)PARAM_RAM, (Object)String.valueOf(DeviceUtils.getRemainingRamSize((Context)TapTapOpenlogSdk.INSTANCE.getContext$tap_openlog_release())));
        pairArray[8] = TuplesKt.to((Object)PARAM_NETWORK_TYPE, (Object)NetworkUtil.getConnectedType((Context)TapTapOpenlogSdk.INSTANCE.getContext$tap_openlog_release()));
        pairArray[9] = TuplesKt.to((Object)PARAM_MOBILE_TYPE, (Object)NetworkUtil.getNetworkType((Context)TapTapOpenlogSdk.INSTANCE.getContext$tap_openlog_release()));
        pairArray[10] = TuplesKt.to((Object)PARAM_SDK_LOCALE, (Object)TapLocalizeUtil.getPreferredLanguage().getLanguage());
        Map $this$filterValues$iv = raw = MapsKt.mapOf((Pair[])pairArray);
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            String value = (String)entry$iv.getValue();
            boolean bl = false;
            if (!(value != null)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return result$iv;
    }

    private final Pair<String, String> getOAIDorGAID() {
        Pair pair;
        switch (WhenMappings.$EnumSwitchMapping$0[TapTapOpenlogSdk.INSTANCE.getRegion$tap_openlog_release().ordinal()]) {
            case 1: {
                DBService dBService = dbService;
                pair = TuplesKt.to((Object)PARAM_OAID, (Object)(dBService != null ? dBService.getCurrentOAID() : null));
                break;
            }
            case 2: {
                DBService dBService = dbService;
                pair = TuplesKt.to((Object)PARAM_GAID, (Object)(dBService != null ? dBService.getCurrentGAID() : null));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return pair;
    }

    private final String getDataDir(File filesDir, String path) {
        File dir = new File(filesDir, path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String string = dir.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dir.absolutePath");
        return string;
    }

    private final String getEnvironment() {
        return DeviceUtils.isRunInSandbox() ? "sandbox" : (DeviceUtils.isRunInCloud() ? "cloud" : "local");
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RegionType.values().length];
            try {
                nArray[RegionType.CN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RegionType.GLOBAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

