/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.openlog.internal;

import com.taptap.sdk.initializer.api.model.RegionType;
import com.taptap.sdk.kit.internal.TapLogger;
import com.taptap.sdk.kit.internal.openlog.ITapOpenlog;
import com.taptap.sdk.openlog.TapTapOpenlogSdk;
import com.taptap.sdk.openlog.internal.TapOpenLogRemote;
import com.taptap.sdk.openlog.utils.JsonUtils;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u000eH\u0016J&\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/taptap/sdk/openlog/internal/OpenLogImpl;", "Lcom/taptap/sdk/kit/internal/openlog/ITapOpenlog;", "project", "", "version", "(Ljava/lang/String;Ljava/lang/String;)V", "isTechLogDisable", "", "region", "Lcom/taptap/sdk/initializer/api/model/RegionType;", "reportBusinessLog", "", "action", "properties", "", "reportTechnicalLog", "Companion", "tap-openlog_release"})
public final class OpenLogImpl
implements ITapOpenlog {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String project;
    @NotNull
    private final String version;
    @NotNull
    private static final String TAG = "TapTapOpenlog";

    public OpenLogImpl(@NotNull String project, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.project = project;
        this.version = version;
    }

    public void reportBusinessLog(@NotNull String action, @NotNull Map<String, String> properties) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"action", (Object)action), TuplesKt.to((Object)"tapsdk_project", (Object)this.project), TuplesKt.to((Object)"tapsdk_version", (Object)this.version)};
        Map logMap = MapsKt.plus(properties, (Map)MapsKt.mapOf((Pair[])pairArray));
        TapLogger.logi((String)"Tag-Openlog", (String)JsonUtils.INSTANCE.stringify(logMap));
        TapOpenLogRemote.INSTANCE.sendOpenlog("tapsdk", JsonUtils.INSTANCE.stringify(logMap));
    }

    public void reportTechnicalLog(@NotNull String action, @NotNull Map<String, String> properties) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        if (this.isTechLogDisable(TapTapOpenlogSdk.INSTANCE.getRegion$tap_openlog_release(), this.project)) {
            TapLogger.logi((String)TAG, (String)('[' + this.project + "] Technology log is not supported"));
            return;
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"action", (Object)action), TuplesKt.to((Object)"args", (Object)new JSONObject(properties).toString()), TuplesKt.to((Object)"tapsdk_project", (Object)this.project), TuplesKt.to((Object)"tapsdk_version", (Object)this.version)};
        TapOpenLogRemote.INSTANCE.sendOpenlog("tapsdk-apm", JsonUtils.INSTANCE.stringify(MapsKt.mapOf((Pair[])pairArray)));
    }

    private final boolean isTechLogDisable(RegionType region, String project) {
        return region == RegionType.CN && !Intrinsics.areEqual((Object)project, (Object)"TapPayment");
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/taptap/sdk/openlog/internal/OpenLogImpl$Companion;", "", "()V", "TAG", "", "tap-openlog_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

