/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.share;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import com.taptap.sdk.initializer.api.check.TapSdkChecker;
import com.taptap.sdk.kit.internal.extensions.StringExtKt;
import com.taptap.sdk.share.TapTapShareBuilder;
import com.taptap.sdk.share.internal.ShareTracker;
import com.taptap.sdk.share.utils.TapShareServiceManager;
import com.taptap.sdk.share.utils.TapTapShareUtil;
import java.util.ArrayList;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u001a\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nj\n\u0012\u0004\u0012\u00020\u000b\u0018\u0001`\fH\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/taptap/sdk/share/TapTapShare;", "", "builder", "Lcom/taptap/sdk/share/TapTapShareBuilder;", "(Lcom/taptap/sdk/share/TapTapShareBuilder;)V", "checkUri", "", "activity", "Landroid/app/Activity;", "imageUris", "Ljava/util/ArrayList;", "Landroid/net/Uri;", "Lkotlin/collections/ArrayList;", "share", "", "verifyEnv", "tap-share_release"})
public final class TapTapShare {
    @Nullable
    private final TapTapShareBuilder builder;

    public TapTapShare(@Nullable TapTapShareBuilder builder) {
        this.builder = builder;
    }

    public final int share(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (!TapSdkChecker.INSTANCE.checkInitialize()) {
            return -2;
        }
        ShareTracker.trackStart("share", StringExtKt.generateSessionId(), new HashMap());
        int code = this.verifyEnv(activity);
        if (code != 0) {
            try {
                Uri uri = null;
                TapTapShareBuilder tapTapShareBuilder = this.builder;
                Intrinsics.checkNotNull((Object)tapTapShareBuilder);
                if (tapTapShareBuilder.getFailUrl() != null) {
                    Uri uri2 = Uri.parse((String)this.builder.getFailUrl());
                    Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"parse(builder.failUrl)");
                    uri = uri2;
                } else {
                    String url = TapShareServiceManager.getUrl();
                    Uri uri3 = Uri.parse((String)url);
                    Intrinsics.checkNotNullExpressionValue((Object)uri3, (String)"parse(url)");
                    uri = uri3;
                }
                Intent intent = new Intent("android.intent.action.VIEW", uri);
                activity.startActivity(intent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return code;
        }
        Intent shareIntent = new Intent();
        shareIntent.setAction("android.intent.action.SEND_MULTIPLE");
        shareIntent.setPackage("com.taptap");
        if (this.builder != null) {
            shareIntent.putExtra("android.intent.extra.TEXT", this.builder.getTapParamsString());
            this.checkUri(activity, this.builder.getImageUris());
            shareIntent.putParcelableArrayListExtra("android.intent.extra.STREAM", this.builder.getImageUris());
        }
        shareIntent.setType("image/*");
        activity.startActivity(shareIntent);
        return 0;
    }

    private final void checkUri(Activity activity, ArrayList<Uri> imageUris) {
        block1: {
            ArrayList<Uri> arrayList = imageUris;
            if (arrayList == null) break block1;
            Iterable $this$forEach$iv = arrayList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Uri it = (Uri)element$iv;
                boolean bl = false;
                activity.grantUriPermission("com.taptap", it, 1);
            }
        }
    }

    private final int verifyEnv(Activity activity) {
        return !TapTapShareUtil.checkTapTapInstall(activity) ? -1 : (!TapTapShareUtil.checkTapTapSupportShare(activity) ? -2 : 0);
    }
}

