/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.themis.lite;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;

public class LogUtil {
    public static final String TAG = "ThemisLite";
    private static boolean isDebug = false;

    public static void init(@NonNull Context context) {
    }

    public static void info(String msg) {
        if (isDebug) {
            Log.i((String)TAG, (String)msg);
        }
    }

    public static void err(String msg) {
        if (isDebug) {
            Log.e((String)TAG, (String)msg);
        }
    }

    public static void debug(String msg) {
        if (isDebug) {
            Log.d((String)TAG, (String)msg);
        }
    }

    public static void warn(String msg) {
        if (isDebug) {
            Log.w((String)TAG, (String)msg);
        }
    }

    public static void verbose(String msg) {
        if (isDebug) {
            Log.v((String)TAG, (String)msg);
        }
    }

    public static void err(String msg, Throwable throwable) {
        if (isDebug) {
            Log.e((String)TAG, (String)msg, (Throwable)throwable);
        }
    }

    public static void info(String format, Object ... args) {
        if (isDebug) {
            Log.i((String)TAG, (String)String.format(format, args));
        }
    }

    public static void debug(String format, Object ... args) {
        if (isDebug) {
            Log.d((String)TAG, (String)String.format(format, args));
        }
    }

    public static void warn(String format, Object ... args) {
        if (isDebug) {
            Log.w((String)TAG, (String)String.format(format, args));
        }
    }

    public static void verbose(String format, Object ... args) {
        if (isDebug) {
            Log.v((String)TAG, (String)String.format(format, args));
        }
    }

    public static void err(String format, Object ... args) {
        if (isDebug) {
            Log.e((String)TAG, (String)String.format(format, args));
        }
    }
}

