/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.update.download;

import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import com.taptap.sdk.update.download.DownloadContextListener;
import com.taptap.sdk.update.download.DownloadListener;
import com.taptap.sdk.update.download.DownloadTask;
import com.taptap.sdk.update.download.OkDownload;
import com.taptap.sdk.update.download.core.Util;
import com.taptap.sdk.update.download.core.cause.EndCause;
import com.taptap.sdk.update.download.core.listener.DownloadListener2;
import com.taptap.sdk.update.download.core.listener.DownloadListenerBunch;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class DownloadContext {
    private static final String TAG = "DownloadContext";
    private static final Executor SERIAL_EXECUTOR = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 30L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory("OkDownload Serial", false));
    private final DownloadTask[] tasks;
    volatile boolean started = false;
    final DownloadContextListener contextListener;
    private final QueueSet set;
    private Handler uiHandler;

    DownloadContext(DownloadTask[] tasks, DownloadContextListener contextListener, QueueSet set, Handler uiHandler) {
        this(tasks, contextListener, set);
        this.uiHandler = uiHandler;
    }

    DownloadContext(DownloadTask[] tasks, DownloadContextListener contextListener, QueueSet set) {
        this.tasks = tasks;
        this.contextListener = contextListener;
        this.set = set;
    }

    public boolean isStarted() {
        return this.started;
    }

    public DownloadTask[] getTasks() {
        return this.tasks;
    }

    public void startOnSerial(DownloadListener listener) {
        this.start(listener, true);
    }

    public void startOnParallel(DownloadListener listener) {
        this.start(listener, false);
    }

    public void start(DownloadListener listener, boolean isSerial) {
        long startTime = SystemClock.uptimeMillis();
        Util.d(TAG, "start " + isSerial);
        this.started = true;
        final DownloadListener targetListener = this.contextListener != null ? new DownloadListenerBunch.Builder().append(listener).append(new QueueAttachListener(this, this.contextListener, this.tasks.length)).build() : listener;
        if (isSerial) {
            final ArrayList scheduleTaskList = new ArrayList();
            Collections.addAll(scheduleTaskList, this.tasks);
            Collections.sort(scheduleTaskList);
            this.executeOnSerialExecutor(new Runnable(){

                @Override
                public void run() {
                    for (DownloadTask task : scheduleTaskList) {
                        if (!DownloadContext.this.isStarted()) {
                            DownloadContext.this.callbackQueueEndOnSerialLoop(task.isAutoCallbackToUIThread());
                            break;
                        }
                        task.execute(targetListener);
                    }
                }
            });
        } else {
            DownloadTask.enqueue(this.tasks, targetListener);
        }
        Util.d(TAG, "start finish " + isSerial + " " + (SystemClock.uptimeMillis() - startTime) + "ms");
    }

    public AlterContext alter() {
        return new AlterContext(this);
    }

    public void stop() {
        if (this.started) {
            OkDownload.with().downloadDispatcher().cancel(this.tasks);
        }
        this.started = false;
    }

    private void callbackQueueEndOnSerialLoop(boolean isAutoCallbackToUIThread) {
        if (this.contextListener == null) {
            return;
        }
        if (isAutoCallbackToUIThread) {
            if (this.uiHandler == null) {
                this.uiHandler = new Handler(Looper.getMainLooper());
            }
            this.uiHandler.post(new Runnable(){

                @Override
                public void run() {
                    DownloadContext.this.contextListener.queueEnd(DownloadContext.this);
                }
            });
        } else {
            this.contextListener.queueEnd(this);
        }
    }

    void executeOnSerialExecutor(Runnable runnable) {
        SERIAL_EXECUTOR.execute(runnable);
    }

    public Builder toBuilder() {
        return new Builder(this.set, new ArrayList<DownloadTask>(Arrays.asList(this.tasks))).setListener(this.contextListener);
    }

    public static class AlterContext {
        private final DownloadContext context;

        AlterContext(DownloadContext context) {
            this.context = context;
        }

        public AlterContext replaceTask(DownloadTask oldTask, DownloadTask newTask) {
            DownloadTask[] tasks = this.context.tasks;
            for (int i = 0; i < tasks.length; ++i) {
                DownloadTask task = tasks[i];
                if (task != oldTask) continue;
                tasks[i] = newTask;
            }
            return this;
        }
    }

    static class QueueAttachListener
    extends DownloadListener2 {
        private final AtomicInteger remainCount;
        private final DownloadContextListener contextListener;
        private final DownloadContext hostContext;

        QueueAttachListener(DownloadContext context, DownloadContextListener contextListener, int taskCount) {
            this.remainCount = new AtomicInteger(taskCount);
            this.contextListener = contextListener;
            this.hostContext = context;
        }

        @Override
        public void taskStart(DownloadTask task) {
        }

        @Override
        public void taskEnd(DownloadTask task, EndCause cause, Exception realCause) {
            int remainCount = this.remainCount.decrementAndGet();
            this.contextListener.taskEnd(this.hostContext, task, cause, realCause, remainCount);
            if (remainCount <= 0) {
                this.contextListener.queueEnd(this.hostContext);
                Util.d(DownloadContext.TAG, "taskEnd and remainCount " + remainCount);
            }
        }
    }

    public static class QueueSet {
        private Map<String, List<String>> headerMapFields;
        private Uri uri;
        private Integer readBufferSize;
        private Integer flushBufferSize;
        private Integer syncBufferSize;
        private Integer syncBufferIntervalMillis;
        private Boolean autoCallbackToUIThread;
        private Integer minIntervalMillisCallbackProcess;
        private Boolean passIfAlreadyCompleted;
        private Boolean wifiRequired;
        private Object tag;

        public Map<String, List<String>> getHeaderMapFields() {
            return this.headerMapFields;
        }

        public void setHeaderMapFields(Map<String, List<String>> headerMapFields) {
            this.headerMapFields = headerMapFields;
        }

        public Uri getDirUri() {
            return this.uri;
        }

        public QueueSet setParentPathUri(Uri uri) {
            this.uri = uri;
            return this;
        }

        public QueueSet setParentPathFile(File parentPathFile) {
            if (parentPathFile.isFile()) {
                throw new IllegalArgumentException("parent path only accept directory path");
            }
            this.uri = Uri.fromFile((File)parentPathFile);
            return this;
        }

        public QueueSet setParentPath(String parentPath) {
            return this.setParentPathFile(new File(parentPath));
        }

        public int getReadBufferSize() {
            return this.readBufferSize == null ? 4096 : this.readBufferSize;
        }

        public QueueSet setReadBufferSize(int readBufferSize) {
            this.readBufferSize = readBufferSize;
            return this;
        }

        public QueueSet setWifiRequired(Boolean wifiRequired) {
            this.wifiRequired = wifiRequired;
            return this;
        }

        public boolean isWifiRequired() {
            return this.wifiRequired == null ? false : this.wifiRequired;
        }

        public int getFlushBufferSize() {
            return this.flushBufferSize == null ? 16384 : this.flushBufferSize;
        }

        public QueueSet setFlushBufferSize(int flushBufferSize) {
            this.flushBufferSize = flushBufferSize;
            return this;
        }

        public int getSyncBufferSize() {
            return this.syncBufferSize == null ? 65536 : this.syncBufferSize;
        }

        public QueueSet setSyncBufferSize(int syncBufferSize) {
            this.syncBufferSize = syncBufferSize;
            return this;
        }

        public int getSyncBufferIntervalMillis() {
            return this.syncBufferIntervalMillis == null ? 2000 : this.syncBufferIntervalMillis;
        }

        public QueueSet setSyncBufferIntervalMillis(int syncBufferIntervalMillis) {
            this.syncBufferIntervalMillis = syncBufferIntervalMillis;
            return this;
        }

        public boolean isAutoCallbackToUIThread() {
            return this.autoCallbackToUIThread == null ? true : this.autoCallbackToUIThread;
        }

        public QueueSet setAutoCallbackToUIThread(Boolean autoCallbackToUIThread) {
            this.autoCallbackToUIThread = autoCallbackToUIThread;
            return this;
        }

        public int getMinIntervalMillisCallbackProcess() {
            return this.minIntervalMillisCallbackProcess == null ? 3000 : this.minIntervalMillisCallbackProcess;
        }

        public QueueSet setMinIntervalMillisCallbackProcess(Integer minIntervalMillisCallbackProcess) {
            this.minIntervalMillisCallbackProcess = minIntervalMillisCallbackProcess;
            return this;
        }

        public Object getTag() {
            return this.tag;
        }

        public QueueSet setTag(Object tag) {
            this.tag = tag;
            return this;
        }

        public boolean isPassIfAlreadyCompleted() {
            return this.passIfAlreadyCompleted == null ? true : this.passIfAlreadyCompleted;
        }

        public QueueSet setPassIfAlreadyCompleted(boolean passIfAlreadyCompleted) {
            this.passIfAlreadyCompleted = passIfAlreadyCompleted;
            return this;
        }

        public Builder commit() {
            return new Builder(this);
        }
    }

    public static class Builder {
        final ArrayList<DownloadTask> boundTaskList;
        private final QueueSet set;
        private DownloadContextListener listener;

        public Builder() {
            this(new QueueSet());
        }

        public Builder(QueueSet set) {
            this(set, new ArrayList<DownloadTask>());
        }

        public Builder(QueueSet set, ArrayList<DownloadTask> taskArrayList) {
            this.set = set;
            this.boundTaskList = taskArrayList;
        }

        public Builder setListener(DownloadContextListener listener) {
            this.listener = listener;
            return this;
        }

        public Builder bindSetTask(DownloadTask task) {
            int index = this.boundTaskList.indexOf(task);
            if (index >= 0) {
                this.boundTaskList.set(index, task);
            } else {
                this.boundTaskList.add(task);
            }
            return this;
        }

        public DownloadTask bind(String url) {
            if (this.set.uri == null) {
                throw new IllegalArgumentException("If you want to bind only with url, you have to provide parentPath on QueueSet!");
            }
            return this.bind(new DownloadTask.Builder(url, this.set.uri).setFilenameFromResponse(true));
        }

        public DownloadTask bind(DownloadTask.Builder taskBuilder) {
            if (this.set.headerMapFields != null) {
                taskBuilder.setHeaderMapFields(this.set.headerMapFields);
            }
            if (this.set.readBufferSize != null) {
                taskBuilder.setReadBufferSize(this.set.readBufferSize);
            }
            if (this.set.flushBufferSize != null) {
                taskBuilder.setFlushBufferSize(this.set.flushBufferSize);
            }
            if (this.set.syncBufferSize != null) {
                taskBuilder.setSyncBufferSize(this.set.syncBufferSize);
            }
            if (this.set.wifiRequired != null) {
                taskBuilder.setWifiRequired(this.set.wifiRequired);
            }
            if (this.set.syncBufferIntervalMillis != null) {
                taskBuilder.setSyncBufferIntervalMillis(this.set.syncBufferIntervalMillis);
            }
            if (this.set.autoCallbackToUIThread != null) {
                taskBuilder.setAutoCallbackToUIThread(this.set.autoCallbackToUIThread);
            }
            if (this.set.minIntervalMillisCallbackProcess != null) {
                taskBuilder.setMinIntervalMillisCallbackProcess(this.set.minIntervalMillisCallbackProcess);
            }
            if (this.set.passIfAlreadyCompleted != null) {
                taskBuilder.setPassIfAlreadyCompleted(this.set.passIfAlreadyCompleted);
            }
            DownloadTask task = taskBuilder.build();
            if (this.set.tag != null) {
                task.setTag(this.set.tag);
            }
            this.boundTaskList.add(task);
            return task;
        }

        public void unbind(DownloadTask task) {
            this.boundTaskList.remove(task);
        }

        public void unbind(int id2) {
            List list = (List)this.boundTaskList.clone();
            for (DownloadTask task : list) {
                if (task.getId() != id2) continue;
                this.boundTaskList.remove(task);
            }
        }

        public DownloadContext build() {
            DownloadTask[] tasks = new DownloadTask[this.boundTaskList.size()];
            return new DownloadContext(this.boundTaskList.toArray(tasks), this.listener, this.set);
        }
    }
}

