/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.update.download;

import android.net.Uri;
import android.support.annotation.IntRange;
import android.util.SparseArray;
import com.taptap.sdk.update.download.DownloadListener;
import com.taptap.sdk.update.download.OkDownload;
import com.taptap.sdk.update.download.core.IdentifiedTask;
import com.taptap.sdk.update.download.core.Util;
import com.taptap.sdk.update.download.core.breakpoint.BreakpointInfo;
import com.taptap.sdk.update.download.core.download.DownloadStrategy;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class DownloadTask
extends IdentifiedTask
implements Comparable<DownloadTask> {
    private final int id;
    private final String url;
    private final Uri uri;
    private final Map<String, List<String>> headerMapFields;
    private BreakpointInfo info;
    private final int priority;
    private final int readBufferSize;
    private final int flushBufferSize;
    private final int syncBufferSize;
    private final int syncBufferIntervalMills;
    private final Integer connectionCount;
    private final Boolean isPreAllocateLength;
    private final boolean passIfAlreadyCompleted;
    private final boolean autoCallbackToUIThread;
    private final int minIntervalMillisCallbackProcess;
    private volatile DownloadListener listener;
    private volatile SparseArray<Object> keyTagMap;
    private Object tag;
    private final boolean wifiRequired;
    private final AtomicLong lastCallbackProcessTimestamp;
    private final boolean filenameFromResponse;
    private final DownloadStrategy.FilenameHolder filenameHolder;
    private final File providedPathFile;
    private final File directoryFile;
    private File targetFile;
    private String redirectLocation;

    public DownloadTask(String url, Uri uri, int priority, int readBufferSize, int flushBufferSize, int syncBufferSize, int syncBufferIntervalMills, boolean autoCallbackToUIThread, int minIntervalMillisCallbackProcess, Map<String, List<String>> headerMapFields, String filename, boolean passIfAlreadyCompleted, boolean wifiRequired, Boolean filenameFromResponse, Integer connectionCount, Boolean isPreAllocateLength) {
        this.url = url;
        this.uri = uri;
        this.priority = priority;
        this.readBufferSize = readBufferSize;
        this.flushBufferSize = flushBufferSize;
        this.syncBufferSize = syncBufferSize;
        this.syncBufferIntervalMills = syncBufferIntervalMills;
        this.autoCallbackToUIThread = autoCallbackToUIThread;
        this.minIntervalMillisCallbackProcess = minIntervalMillisCallbackProcess;
        this.headerMapFields = headerMapFields;
        this.lastCallbackProcessTimestamp = new AtomicLong();
        this.passIfAlreadyCompleted = passIfAlreadyCompleted;
        this.wifiRequired = wifiRequired;
        this.connectionCount = connectionCount;
        this.isPreAllocateLength = isPreAllocateLength;
        if (Util.isUriFileScheme(uri)) {
            File file = new File(uri.getPath());
            if (filenameFromResponse != null) {
                if (filenameFromResponse.booleanValue()) {
                    if (file.exists() && file.isFile()) {
                        throw new IllegalArgumentException("If you want filename from response please make sure you provide path is directory " + file.getPath());
                    }
                    if (!Util.isEmpty(filename)) {
                        Util.w("DownloadTask", "Discard filename[" + filename + "] because you set filenameFromResponse=true");
                        filename = null;
                    }
                    this.directoryFile = file;
                } else {
                    if (file.exists() && file.isDirectory() && Util.isEmpty(filename)) {
                        throw new IllegalArgumentException("If you don't want filename from response please make sure you have already provided valid filename or not directory path " + file.getPath());
                    }
                    if (Util.isEmpty(filename)) {
                        filename = file.getName();
                        this.directoryFile = Util.getParentFile(file);
                    } else {
                        this.directoryFile = file;
                    }
                }
            } else if (file.exists() && file.isDirectory()) {
                filenameFromResponse = true;
                this.directoryFile = file;
            } else {
                filenameFromResponse = false;
                if (file.exists()) {
                    if (!Util.isEmpty(filename) && !file.getName().equals(filename)) {
                        throw new IllegalArgumentException("Uri already provided filename!");
                    }
                    filename = file.getName();
                    this.directoryFile = Util.getParentFile(file);
                } else if (Util.isEmpty(filename)) {
                    filename = file.getName();
                    this.directoryFile = Util.getParentFile(file);
                } else {
                    this.directoryFile = file;
                }
            }
            this.filenameFromResponse = filenameFromResponse;
        } else {
            this.filenameFromResponse = false;
            this.directoryFile = new File(uri.getPath());
        }
        if (Util.isEmpty(filename)) {
            this.filenameHolder = new DownloadStrategy.FilenameHolder();
            this.providedPathFile = this.directoryFile;
        } else {
            this.filenameHolder = new DownloadStrategy.FilenameHolder(filename);
            this.providedPathFile = this.targetFile = new File(this.directoryFile, filename);
        }
        this.id = OkDownload.with().breakpointStore().findOrCreateId(this);
    }

    public boolean isFilenameFromResponse() {
        return this.filenameFromResponse;
    }

    public Map<String, List<String>> getHeaderMapFields() {
        return this.headerMapFields;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getFilename() {
        return this.filenameHolder.get();
    }

    public boolean isPassIfAlreadyCompleted() {
        return this.passIfAlreadyCompleted;
    }

    public boolean isWifiRequired() {
        return this.wifiRequired;
    }

    public DownloadStrategy.FilenameHolder getFilenameHolder() {
        return this.filenameHolder;
    }

    public Uri getUri() {
        return this.uri;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public void setRedirectLocation(String redirectUrl) {
        this.redirectLocation = redirectUrl;
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    @Override
    protected File getProvidedPathFile() {
        return this.providedPathFile;
    }

    @Override
    public File getParentFile() {
        return this.directoryFile;
    }

    public File getFile() {
        String filename = this.filenameHolder.get();
        if (filename == null) {
            return null;
        }
        if (this.targetFile == null) {
            this.targetFile = new File(this.directoryFile, filename);
        }
        return this.targetFile;
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public int getFlushBufferSize() {
        return this.flushBufferSize;
    }

    public int getSyncBufferSize() {
        return this.syncBufferSize;
    }

    public int getSyncBufferIntervalMills() {
        return this.syncBufferIntervalMills;
    }

    public boolean isAutoCallbackToUIThread() {
        return this.autoCallbackToUIThread;
    }

    public int getMinIntervalMillisCallbackProcess() {
        return this.minIntervalMillisCallbackProcess;
    }

    public Integer getSetConnectionCount() {
        return this.connectionCount;
    }

    public Boolean getSetPreAllocateLength() {
        return this.isPreAllocateLength;
    }

    public int getConnectionCount() {
        if (this.info == null) {
            return 0;
        }
        return this.info.getBlockCount();
    }

    public Object getTag(int key) {
        return this.keyTagMap == null ? null : this.keyTagMap.get(key);
    }

    public Object getTag() {
        return this.tag;
    }

    public BreakpointInfo getInfo() {
        if (this.info == null) {
            this.info = OkDownload.with().breakpointStore().get(this.id);
        }
        return this.info;
    }

    long getLastCallbackProcessTs() {
        return this.lastCallbackProcessTimestamp.get();
    }

    void setLastCallbackProcessTs(long lastCallbackProcessTimestamp) {
        this.lastCallbackProcessTimestamp.set(lastCallbackProcessTimestamp);
    }

    void setBreakpointInfo(BreakpointInfo info) {
        this.info = info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DownloadTask addTag(int key, Object value) {
        if (this.keyTagMap == null) {
            DownloadTask downloadTask = this;
            synchronized (downloadTask) {
                if (this.keyTagMap == null) {
                    this.keyTagMap = new SparseArray();
                }
            }
        }
        this.keyTagMap.put(key, value);
        return this;
    }

    public synchronized void removeTag(int key) {
        if (this.keyTagMap != null) {
            this.keyTagMap.remove(key);
        }
    }

    public synchronized void removeTag() {
        this.tag = null;
    }

    public void setTag(Object tag) {
        this.tag = tag;
    }

    public void replaceListener(DownloadListener listener) {
        this.listener = listener;
    }

    public static void enqueue(DownloadTask[] tasks, DownloadListener listener) {
        for (DownloadTask task : tasks) {
            task.listener = listener;
        }
        OkDownload.with().downloadDispatcher().enqueue(tasks);
    }

    public void enqueue(DownloadListener listener) {
        this.listener = listener;
        OkDownload.with().downloadDispatcher().enqueue(this);
    }

    public void execute(DownloadListener listener) {
        this.listener = listener;
        OkDownload.with().downloadDispatcher().execute(this);
    }

    public void cancel() {
        OkDownload.with().downloadDispatcher().cancel(this);
    }

    public static void cancel(DownloadTask[] tasks) {
        OkDownload.with().downloadDispatcher().cancel(tasks);
    }

    public DownloadListener getListener() {
        return this.listener;
    }

    public int getPriority() {
        return this.priority;
    }

    public Builder toBuilder(String anotherUrl, Uri anotherUri) {
        Builder builder = new Builder(anotherUrl, anotherUri).setPriority(this.priority).setReadBufferSize(this.readBufferSize).setFlushBufferSize(this.flushBufferSize).setSyncBufferSize(this.syncBufferSize).setSyncBufferIntervalMillis(this.syncBufferIntervalMills).setAutoCallbackToUIThread(this.autoCallbackToUIThread).setMinIntervalMillisCallbackProcess(this.minIntervalMillisCallbackProcess).setHeaderMapFields(this.headerMapFields).setPassIfAlreadyCompleted(this.passIfAlreadyCompleted);
        if (Util.isUriFileScheme(anotherUri) && !new File(anotherUri.getPath()).isFile() && Util.isUriFileScheme(this.uri) && this.filenameHolder.get() != null && !new File(this.uri.getPath()).getName().equals(this.filenameHolder.get())) {
            builder.setFilename(this.filenameHolder.get());
        }
        return builder;
    }

    public Builder toBuilder() {
        return this.toBuilder(this.url, this.uri);
    }

    public void setTags(DownloadTask oldTask) {
        this.tag = oldTask.tag;
        this.keyTagMap = oldTask.keyTagMap;
    }

    @Override
    public int compareTo(DownloadTask o) {
        return o.getPriority() - this.getPriority();
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof DownloadTask) {
            DownloadTask another = (DownloadTask)obj;
            if (this.getTag() != null && another.getTag() != null) {
                return this.getTag().equals(another.getTag());
            }
            if (another.id == this.id) {
                return true;
            }
            return this.compareIgnoreId(another);
        }
        return false;
    }

    public int hashCode() {
        return (this.url + this.providedPathFile.toString() + this.filenameHolder.get()).hashCode();
    }

    public String toString() {
        return super.toString() + "@" + this.id + "@" + this.url + "@" + this.directoryFile.toString() + "/" + this.filenameHolder.get();
    }

    public static MockTaskForCompare mockTaskForCompare(int id2) {
        return new MockTaskForCompare(id2);
    }

    public MockTaskForCompare mock(int id2) {
        return new MockTaskForCompare(id2, this);
    }

    public static class MockTaskForCompare
    extends IdentifiedTask {
        final int id;
        final String url;
        final File providedPathFile;
        final String filename;
        final File parentFile;

        public MockTaskForCompare(int id2) {
            this.id = id2;
            this.url = "";
            this.providedPathFile = EMPTY_FILE;
            this.filename = null;
            this.parentFile = EMPTY_FILE;
        }

        public MockTaskForCompare(int id2, DownloadTask task) {
            this.id = id2;
            this.url = task.url;
            this.parentFile = task.getParentFile();
            this.providedPathFile = task.providedPathFile;
            this.filename = task.getFilename();
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public String getUrl() {
            return this.url;
        }

        @Override
        protected File getProvidedPathFile() {
            return this.providedPathFile;
        }

        @Override
        public File getParentFile() {
            return this.parentFile;
        }

        @Override
        public String getFilename() {
            return this.filename;
        }
    }

    public static class TaskHideWrapper {
        public static long getLastCallbackProcessTs(DownloadTask task) {
            return task.getLastCallbackProcessTs();
        }

        public static void setLastCallbackProcessTs(DownloadTask task, long lastCallbackProcessTimestamp) {
            task.setLastCallbackProcessTs(lastCallbackProcessTimestamp);
        }

        public static void setBreakpointInfo(DownloadTask task, BreakpointInfo info) {
            task.setBreakpointInfo(info);
        }
    }

    public static class Builder {
        final String url;
        final Uri uri;
        private volatile Map<String, List<String>> headerMapFields;
        private int priority;
        public static final int DEFAULT_READ_BUFFER_SIZE = 4096;
        private int readBufferSize = 4096;
        public static final int DEFAULT_FLUSH_BUFFER_SIZE = 16384;
        private int flushBufferSize = 16384;
        public static final int DEFAULT_SYNC_BUFFER_SIZE = 65536;
        private int syncBufferSize = 65536;
        public static final int DEFAULT_SYNC_BUFFER_INTERVAL_MILLIS = 2000;
        private int syncBufferIntervalMillis = 2000;
        public static final boolean DEFAULT_AUTO_CALLBACK_TO_UI_THREAD = true;
        private boolean autoCallbackToUIThread = true;
        public static final int DEFAULT_MIN_INTERVAL_MILLIS_CALLBACK_PROCESS = 3000;
        private int minIntervalMillisCallbackProcess = 3000;
        private String filename;
        public static final boolean DEFAULT_PASS_IF_ALREADY_COMPLETED = true;
        private boolean passIfAlreadyCompleted = true;
        public static final boolean DEFAULT_IS_WIFI_REQUIRED = false;
        private boolean isWifiRequired = false;
        private Boolean isFilenameFromResponse;
        private Integer connectionCount;
        private Boolean isPreAllocateLength;

        public Builder(String url, String parentPath, String filename) {
            this(url, Uri.fromFile((File)new File(parentPath)));
            if (Util.isEmpty(filename)) {
                this.isFilenameFromResponse = true;
            } else {
                this.filename = filename;
            }
        }

        public Builder(String url, File file) {
            this.url = url;
            this.uri = Uri.fromFile((File)file);
        }

        public Builder(String url, Uri uri) {
            this.url = url;
            this.uri = uri;
            if (Util.isUriContentScheme(uri)) {
                this.filename = Util.getFilenameFromContentUri(uri);
            }
        }

        public Builder setPreAllocateLength(boolean preAllocateLength) {
            this.isPreAllocateLength = preAllocateLength;
            return this;
        }

        public Builder setConnectionCount(@IntRange(from=1L) int connectionCount) {
            this.connectionCount = connectionCount;
            return this;
        }

        public Builder setFilenameFromResponse(Boolean filenameFromResponse) {
            if (!Util.isUriFileScheme(this.uri)) {
                throw new IllegalArgumentException("Uri isn't file scheme we can't let filename from response");
            }
            this.isFilenameFromResponse = filenameFromResponse;
            return this;
        }

        public Builder setAutoCallbackToUIThread(boolean autoCallbackToUIThread) {
            this.autoCallbackToUIThread = autoCallbackToUIThread;
            return this;
        }

        public Builder setMinIntervalMillisCallbackProcess(int minIntervalMillisCallbackProcess) {
            this.minIntervalMillisCallbackProcess = minIntervalMillisCallbackProcess;
            return this;
        }

        public Builder setHeaderMapFields(Map<String, List<String>> headerMapFields) {
            this.headerMapFields = headerMapFields;
            return this;
        }

        public synchronized void addHeader(String key, String value) {
            List<String> valueList;
            if (this.headerMapFields == null) {
                this.headerMapFields = new HashMap<String, List<String>>();
            }
            if ((valueList = this.headerMapFields.get(key)) == null) {
                valueList = new ArrayList<String>();
                this.headerMapFields.put(key, valueList);
            }
            valueList.add(value);
        }

        public Builder setPriority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder setReadBufferSize(int readBufferSize) {
            if (readBufferSize < 0) {
                throw new IllegalArgumentException("Value must be positive!");
            }
            this.readBufferSize = readBufferSize;
            return this;
        }

        public Builder setFlushBufferSize(int flushBufferSize) {
            if (flushBufferSize < 0) {
                throw new IllegalArgumentException("Value must be positive!");
            }
            this.flushBufferSize = flushBufferSize;
            return this;
        }

        public Builder setSyncBufferSize(int syncBufferSize) {
            if (syncBufferSize < 0) {
                throw new IllegalArgumentException("Value must be positive!");
            }
            this.syncBufferSize = syncBufferSize;
            return this;
        }

        public Builder setSyncBufferIntervalMillis(int syncBufferIntervalMillis) {
            if (syncBufferIntervalMillis < 0) {
                throw new IllegalArgumentException("Value must be positive!");
            }
            this.syncBufferIntervalMillis = syncBufferIntervalMillis;
            return this;
        }

        public Builder setFilename(String filename) {
            this.filename = filename;
            return this;
        }

        public Builder setPassIfAlreadyCompleted(boolean passIfAlreadyCompleted) {
            this.passIfAlreadyCompleted = passIfAlreadyCompleted;
            return this;
        }

        public Builder setWifiRequired(boolean wifiRequired) {
            this.isWifiRequired = wifiRequired;
            return this;
        }

        public DownloadTask build() {
            return new DownloadTask(this.url, this.uri, this.priority, this.readBufferSize, this.flushBufferSize, this.syncBufferSize, this.syncBufferIntervalMillis, this.autoCallbackToUIThread, this.minIntervalMillisCallbackProcess, this.headerMapFields, this.filename, this.passIfAlreadyCompleted, this.isWifiRequired, this.isFilenameFromResponse, this.connectionCount, this.isPreAllocateLength);
        }
    }
}

