/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.update.download;

import android.annotation.SuppressLint;
import android.content.Context;
import com.taptap.sdk.update.download.DownloadMonitor;
import com.taptap.sdk.update.download.OkDownloadProvider;
import com.taptap.sdk.update.download.core.Util;
import com.taptap.sdk.update.download.core.breakpoint.BreakpointStore;
import com.taptap.sdk.update.download.core.breakpoint.DownloadStore;
import com.taptap.sdk.update.download.core.connection.DownloadConnection;
import com.taptap.sdk.update.download.core.dispatcher.CallbackDispatcher;
import com.taptap.sdk.update.download.core.dispatcher.DownloadDispatcher;
import com.taptap.sdk.update.download.core.download.DownloadStrategy;
import com.taptap.sdk.update.download.core.file.DownloadOutputStream;
import com.taptap.sdk.update.download.core.file.DownloadUriOutputStream;
import com.taptap.sdk.update.download.core.file.ProcessFileStrategy;

public class OkDownload {
    @SuppressLint(value={"StaticFieldLeak"})
    static volatile OkDownload singleton;
    private final DownloadDispatcher downloadDispatcher;
    private final CallbackDispatcher callbackDispatcher;
    private final BreakpointStore breakpointStore;
    private final DownloadConnection.Factory connectionFactory;
    private final DownloadOutputStream.Factory outputStreamFactory;
    private final ProcessFileStrategy processFileStrategy;
    private final DownloadStrategy downloadStrategy;
    private final Context context;
    DownloadMonitor monitor;

    OkDownload(Context context, DownloadDispatcher downloadDispatcher, CallbackDispatcher callbackDispatcher, DownloadStore store, DownloadConnection.Factory connectionFactory, DownloadOutputStream.Factory outputStreamFactory, ProcessFileStrategy processFileStrategy, DownloadStrategy downloadStrategy) {
        this.context = context;
        this.downloadDispatcher = downloadDispatcher;
        this.callbackDispatcher = callbackDispatcher;
        this.breakpointStore = store;
        this.connectionFactory = connectionFactory;
        this.outputStreamFactory = outputStreamFactory;
        this.processFileStrategy = processFileStrategy;
        this.downloadStrategy = downloadStrategy;
        this.downloadDispatcher.setDownloadStore(Util.createRemitDatabase(store));
    }

    public DownloadDispatcher downloadDispatcher() {
        return this.downloadDispatcher;
    }

    public CallbackDispatcher callbackDispatcher() {
        return this.callbackDispatcher;
    }

    public BreakpointStore breakpointStore() {
        return this.breakpointStore;
    }

    public DownloadConnection.Factory connectionFactory() {
        return this.connectionFactory;
    }

    public DownloadOutputStream.Factory outputStreamFactory() {
        return this.outputStreamFactory;
    }

    public ProcessFileStrategy processFileStrategy() {
        return this.processFileStrategy;
    }

    public DownloadStrategy downloadStrategy() {
        return this.downloadStrategy;
    }

    public Context context() {
        return this.context;
    }

    public void setMonitor(DownloadMonitor monitor) {
        this.monitor = monitor;
    }

    public DownloadMonitor getMonitor() {
        return this.monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OkDownload with() {
        if (singleton != null) return singleton;
        Class<OkDownload> clazz = OkDownload.class;
        synchronized (OkDownload.class) {
            if (singleton != null) return singleton;
            if (OkDownloadProvider.context == null) {
                throw new IllegalStateException("context == null");
            }
            singleton = new Builder(OkDownloadProvider.context).build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSingletonInstance(OkDownload okDownload) {
        if (singleton != null) {
            throw new IllegalArgumentException("OkDownload must be null.");
        }
        Class<OkDownload> clazz = OkDownload.class;
        synchronized (OkDownload.class) {
            if (singleton != null) {
                throw new IllegalArgumentException("OkDownload must be null.");
            }
            singleton = okDownload;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static class Builder {
        private DownloadDispatcher downloadDispatcher;
        private CallbackDispatcher callbackDispatcher;
        private DownloadStore downloadStore;
        private DownloadConnection.Factory connectionFactory;
        private ProcessFileStrategy processFileStrategy;
        private DownloadStrategy downloadStrategy;
        private DownloadOutputStream.Factory outputStreamFactory;
        private DownloadMonitor monitor;
        private final Context context;

        public Builder(Context context) {
            this.context = context.getApplicationContext();
        }

        public Builder downloadDispatcher(DownloadDispatcher downloadDispatcher) {
            this.downloadDispatcher = downloadDispatcher;
            return this;
        }

        public Builder callbackDispatcher(CallbackDispatcher callbackDispatcher) {
            this.callbackDispatcher = callbackDispatcher;
            return this;
        }

        public Builder downloadStore(DownloadStore downloadStore) {
            this.downloadStore = downloadStore;
            return this;
        }

        public Builder connectionFactory(DownloadConnection.Factory connectionFactory) {
            this.connectionFactory = connectionFactory;
            return this;
        }

        public Builder outputStreamFactory(DownloadOutputStream.Factory outputStreamFactory) {
            this.outputStreamFactory = outputStreamFactory;
            return this;
        }

        public Builder processFileStrategy(ProcessFileStrategy processFileStrategy) {
            this.processFileStrategy = processFileStrategy;
            return this;
        }

        public Builder downloadStrategy(DownloadStrategy downloadStrategy) {
            this.downloadStrategy = downloadStrategy;
            return this;
        }

        public Builder monitor(DownloadMonitor monitor) {
            this.monitor = monitor;
            return this;
        }

        public OkDownload build() {
            if (this.downloadDispatcher == null) {
                this.downloadDispatcher = new DownloadDispatcher();
            }
            if (this.callbackDispatcher == null) {
                this.callbackDispatcher = new CallbackDispatcher();
            }
            if (this.downloadStore == null) {
                this.downloadStore = Util.createDefaultDatabase(this.context);
            }
            if (this.connectionFactory == null) {
                this.connectionFactory = Util.createDefaultConnectionFactory();
            }
            if (this.outputStreamFactory == null) {
                this.outputStreamFactory = new DownloadUriOutputStream.Factory();
            }
            if (this.processFileStrategy == null) {
                this.processFileStrategy = new ProcessFileStrategy();
            }
            if (this.downloadStrategy == null) {
                this.downloadStrategy = new DownloadStrategy();
            }
            OkDownload okDownload = new OkDownload(this.context, this.downloadDispatcher, this.callbackDispatcher, this.downloadStore, this.connectionFactory, this.outputStreamFactory, this.processFileStrategy, this.downloadStrategy);
            okDownload.setMonitor(this.monitor);
            Util.d("OkDownload", "downloadStore[" + this.downloadStore + "] connectionFactory[" + this.connectionFactory);
            return okDownload;
        }
    }
}

