/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.update.download;

import com.taptap.sdk.update.download.DownloadTask;
import com.taptap.sdk.update.download.OkDownload;
import com.taptap.sdk.update.download.core.breakpoint.BreakpointInfo;
import com.taptap.sdk.update.download.core.breakpoint.BreakpointStore;
import com.taptap.sdk.update.download.core.dispatcher.DownloadDispatcher;
import java.io.File;

public class StatusUtil {
    public static boolean isSameTaskPendingOrRunning(DownloadTask task) {
        return OkDownload.with().downloadDispatcher().findSameTask(task) != null;
    }

    public static Status getStatus(DownloadTask task) {
        Status status = StatusUtil.isCompletedOrUnknown(task);
        if (status == Status.COMPLETED) {
            return Status.COMPLETED;
        }
        DownloadDispatcher dispatcher = OkDownload.with().downloadDispatcher();
        if (dispatcher.isPending(task)) {
            return Status.PENDING;
        }
        if (dispatcher.isRunning(task)) {
            return Status.RUNNING;
        }
        return status;
    }

    public static Status getStatus(String url, String parentPath, String filename) {
        return StatusUtil.getStatus(StatusUtil.createFinder(url, parentPath, filename));
    }

    public static boolean isCompleted(DownloadTask task) {
        return StatusUtil.isCompletedOrUnknown(task) == Status.COMPLETED;
    }

    public static Status isCompletedOrUnknown(DownloadTask task) {
        BreakpointStore store = OkDownload.with().breakpointStore();
        BreakpointInfo info = store.get(task.getId());
        String filename = task.getFilename();
        File parentFile = task.getParentFile();
        File targetFile = task.getFile();
        if (info != null) {
            if (!info.isChunked() && info.getTotalLength() <= 0L) {
                return Status.UNKNOWN;
            }
            if (targetFile != null && targetFile.equals(info.getFile()) && targetFile.exists() && info.getTotalOffset() == info.getTotalLength()) {
                return Status.COMPLETED;
            }
            if (filename == null && info.getFile() != null && info.getFile().exists()) {
                return Status.IDLE;
            }
            if (targetFile != null && targetFile.equals(info.getFile()) && targetFile.exists()) {
                return Status.IDLE;
            }
        } else {
            if (store.isOnlyMemoryCache() || store.isFileDirty(task.getId())) {
                return Status.UNKNOWN;
            }
            if (targetFile != null && targetFile.exists()) {
                return Status.COMPLETED;
            }
            filename = store.getResponseFilename(task.getUrl());
            if (filename != null && new File(parentFile, filename).exists()) {
                return Status.COMPLETED;
            }
        }
        return Status.UNKNOWN;
    }

    public static boolean isCompleted(String url, String parentPath, String filename) {
        return StatusUtil.isCompleted(StatusUtil.createFinder(url, parentPath, filename));
    }

    public static BreakpointInfo getCurrentInfo(String url, String parentPath, String filename) {
        return StatusUtil.getCurrentInfo(StatusUtil.createFinder(url, parentPath, filename));
    }

    public static BreakpointInfo getCurrentInfo(DownloadTask task) {
        int id2;
        BreakpointStore store = OkDownload.with().breakpointStore();
        BreakpointInfo info = store.get(id2 = store.findOrCreateId(task));
        return info == null ? null : info.copy();
    }

    static DownloadTask createFinder(String url, String parentPath, String filename) {
        return new DownloadTask.Builder(url, parentPath, filename).build();
    }

    public static enum Status {
        PENDING,
        RUNNING,
        COMPLETED,
        IDLE,
        UNKNOWN;

    }
}

