/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.update.download.core;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.StatFs;
import android.util.Log;
import com.taptap.sdk.update.download.DownloadTask;
import com.taptap.sdk.update.download.OkDownload;
import com.taptap.sdk.update.download.core.breakpoint.BlockInfo;
import com.taptap.sdk.update.download.core.breakpoint.BreakpointInfo;
import com.taptap.sdk.update.download.core.breakpoint.BreakpointStoreOnCache;
import com.taptap.sdk.update.download.core.breakpoint.DownloadStore;
import com.taptap.sdk.update.download.core.connection.DownloadConnection;
import com.taptap.sdk.update.download.core.connection.DownloadUrlConnection;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Util {
    public static final String METHOD_HEAD = "HEAD";
    public static final String RANGE = "Range";
    public static final String IF_MATCH = "If-Match";
    public static final String USER_AGENT = "User-Agent";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_RANGE = "Content-Range";
    public static final String ETAG = "Etag";
    public static final String TRANSFER_ENCODING = "Transfer-Encoding";
    public static final String ACCEPT_RANGES = "Accept-Ranges";
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String VALUE_CHUNKED = "chunked";
    public static final int CHUNKED_CONTENT_LENGTH = -1;
    public static final int RANGE_NOT_SATISFIABLE = 416;
    private static Logger logger = new EmptyLogger();

    public static void enableConsoleLog() {
        logger = null;
    }

    public static void setLogger(Logger l) {
        logger = l;
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void e(String tag, String msg, Exception e) {
        if (logger != null) {
            logger.e(tag, msg, e);
            return;
        }
        Log.e((String)tag, (String)msg, (Throwable)e);
    }

    public static void w(String tag, String msg) {
        if (logger != null) {
            logger.w(tag, msg);
            return;
        }
        Log.w((String)tag, (String)msg);
    }

    public static void d(String tag, String msg) {
        if (logger != null) {
            logger.d(tag, msg);
            return;
        }
        Log.d((String)tag, (String)msg);
    }

    public static void i(String tag, String msg) {
        if (logger != null) {
            logger.i(tag, msg);
            return;
        }
        Log.i((String)tag, (String)msg);
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static ThreadFactory threadFactory(final String name, final boolean daemon) {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread result = new Thread(runnable, name);
                result.setDaemon(daemon);
                return result;
            }
        };
    }

    public static String md5(String string) {
        byte[] hash = null;
        try {
            hash = MessageDigest.getInstance("MD5").digest(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException exception) {
            // empty catch block
        }
        if (hash != null) {
            StringBuilder hex = new StringBuilder(hash.length * 2);
            for (byte b : hash) {
                if ((b & 0xFF) < 16) {
                    hex.append('0');
                }
                hex.append(Integer.toHexString(b & 0xFF));
            }
            return hex.toString();
        }
        return null;
    }

    public static boolean isCorrectFull(long fetchedLength, long contentLength) {
        return fetchedLength == contentLength;
    }

    public static void resetBlockIfDirty(BlockInfo info) {
        boolean isDirty = false;
        if (info.getCurrentOffset() < 0L) {
            isDirty = true;
        } else if (info.getCurrentOffset() > info.getContentLength()) {
            isDirty = true;
        }
        if (isDirty) {
            Util.w("resetBlockIfDirty", "block is dirty so have to reset: " + info);
            info.resetBlock();
        }
    }

    public static long getFreeSpaceBytes(StatFs statFs) {
        long freeSpaceBytes = Build.VERSION.SDK_INT >= 18 ? statFs.getAvailableBytes() : (long)statFs.getAvailableBlocks() * (long)statFs.getBlockSize();
        return freeSpaceBytes;
    }

    public static String humanReadableBytes(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format(Locale.ENGLISH, "%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static DownloadStore createDefaultDatabase(Context context) {
        String storeOnSqliteClassName = "com.taptap.sdk.update.download.core.breakpoint.BreakpointStoreOnSQLite";
        try {
            Constructor<?> constructor = Class.forName("com.taptap.sdk.update.download.core.breakpoint.BreakpointStoreOnSQLite").getDeclaredConstructor(Context.class);
            return (DownloadStore)constructor.newInstance(context);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return new BreakpointStoreOnCache();
    }

    public static DownloadStore createRemitDatabase(DownloadStore originStore) {
        DownloadStore finalStore = originStore;
        try {
            Method createRemitSelf = originStore.getClass().getMethod("createRemitSelf", new Class[0]);
            finalStore = (DownloadStore)createRemitSelf.invoke((Object)originStore, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        Util.d("Util", "Get final download store is " + finalStore);
        return finalStore;
    }

    public static DownloadConnection.Factory createDefaultConnectionFactory() {
        String okhttpConnectionClassName = "com.taptap.sdk.update.download.core.connection.DownloadOkHttp3Connection$Factory";
        try {
            Constructor<?> constructor = Class.forName("com.taptap.sdk.update.download.core.connection.DownloadOkHttp3Connection$Factory").getDeclaredConstructor(new Class[0]);
            return (DownloadConnection.Factory)constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return new DownloadUrlConnection.Factory();
    }

    public static void assembleBlock(DownloadTask task, BreakpointInfo info, long instanceLength, boolean isAcceptRange) {
        int blockCount = OkDownload.with().downloadStrategy().isUseMultiBlock(isAcceptRange) ? OkDownload.with().downloadStrategy().determineBlockCount(task, instanceLength) : 1;
        info.resetBlockInfos();
        long eachLength = instanceLength / (long)blockCount;
        long startOffset = 0L;
        long contentLength = 0L;
        for (int i = 0; i < blockCount; ++i) {
            startOffset += contentLength;
            if (i == 0) {
                long remainLength = instanceLength % (long)blockCount;
                contentLength = eachLength + remainLength;
            } else {
                contentLength = eachLength;
            }
            BlockInfo blockInfo = new BlockInfo(startOffset, contentLength);
            info.addBlock(blockInfo);
        }
    }

    public static long parseContentLength(String contentLength) {
        if (contentLength == null) {
            return -1L;
        }
        try {
            return Long.parseLong(contentLength);
        }
        catch (NumberFormatException ignored) {
            Util.d("Util", "parseContentLength failed parse for '" + contentLength + "'");
            return -1L;
        }
    }

    public static boolean isNetworkNotOnWifiType(ConnectivityManager manager) {
        if (manager == null) {
            Util.w("Util", "failed to get connectivity manager!");
            return true;
        }
        NetworkInfo info = manager.getActiveNetworkInfo();
        return info == null || info.getType() != 1;
    }

    public static boolean checkPermission(String permission2) {
        int perm = OkDownload.with().context().checkCallingOrSelfPermission(permission2);
        return perm == 0;
    }

    public static long parseContentLengthFromContentRange(String contentRange) {
        if (contentRange == null || contentRange.length() == 0) {
            return -1L;
        }
        String pattern = "bytes (\\d+)-(\\d+)/\\d+";
        try {
            Pattern r = Pattern.compile("bytes (\\d+)-(\\d+)/\\d+");
            Matcher m = r.matcher(contentRange);
            if (m.find()) {
                long rangeStart = Long.parseLong(m.group(1));
                long rangeEnd = Long.parseLong(m.group(2));
                return rangeEnd - rangeStart + 1L;
            }
        }
        catch (Exception e) {
            Util.w("Util", "parse content-length from content-range failed " + e);
        }
        return -1L;
    }

    public static boolean isUriContentScheme(Uri uri) {
        return uri.getScheme().equals("content");
    }

    public static boolean isUriFileScheme(Uri uri) {
        return uri.getScheme().equals("file");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"Range"})
    public static String getFilenameFromContentUri(Uri contentUri) {
        ContentResolver resolver = OkDownload.with().context().getContentResolver();
        Cursor cursor = resolver.query(contentUri, null, null, null, null);
        if (cursor != null) {
            try {
                cursor.moveToFirst();
                String string = cursor.getString(cursor.getColumnIndex("_display_name"));
                return string;
            }
            finally {
                cursor.close();
            }
        }
        return null;
    }

    public static File getParentFile(File file) {
        File candidate = file.getParentFile();
        return candidate == null ? new File("/") : candidate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"Range"})
    public static long getSizeFromContentUri(Uri contentUri) {
        ContentResolver resolver = OkDownload.with().context().getContentResolver();
        Cursor cursor = resolver.query(contentUri, null, null, null, null);
        if (cursor != null) {
            try {
                cursor.moveToFirst();
                long l = cursor.getLong(cursor.getColumnIndex("_size"));
                return l;
            }
            finally {
                cursor.close();
            }
        }
        return 0L;
    }

    public static boolean isNetworkAvailable(ConnectivityManager manager) {
        if (manager == null) {
            Util.w("Util", "failed to get connectivity manager!");
            return true;
        }
        NetworkInfo info = manager.getActiveNetworkInfo();
        return info != null && info.isConnected();
    }

    public static void inspectUserHeader(Map<String, List<String>> headerField) throws IOException {
        if (headerField.containsKey(IF_MATCH) || headerField.containsKey(RANGE)) {
            throw new IOException("If-Match and Range only can be handle by internal!");
        }
    }

    public static void addUserRequestHeaderField(Map<String, List<String>> userHeaderField, DownloadConnection connection) throws IOException {
        Util.inspectUserHeader(userHeaderField);
        Util.addRequestHeaderFields(userHeaderField, connection);
    }

    public static void addRequestHeaderFields(Map<String, List<String>> headerFields, DownloadConnection connection) {
        for (Map.Entry<String, List<String>> entry : headerFields.entrySet()) {
            String key = entry.getKey();
            List<String> values = entry.getValue();
            for (String value : values) {
                connection.addHeader(key, value);
            }
        }
    }

    public static void addDefaultUserAgent(DownloadConnection connection) {
        String userAgent = "OkDownload/4.5.9";
        connection.addHeader(USER_AGENT, "OkDownload/4.5.9");
    }

    public static class EmptyLogger
    implements Logger {
        @Override
        public void e(String tag, String msg, Exception e) {
        }

        @Override
        public void w(String tag, String msg) {
        }

        @Override
        public void d(String tag, String msg) {
        }

        @Override
        public void i(String tag, String msg) {
        }
    }

    public static interface Logger {
        public void e(String var1, String var2, Exception var3);

        public void w(String var1, String var2);

        public void d(String var1, String var2);

        public void i(String var1, String var2);
    }
}

