/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.update.download.core.breakpoint;

import android.support.annotation.IntRange;
import java.util.concurrent.atomic.AtomicLong;

public class BlockInfo {
    @IntRange(from=0L)
    private final long startOffset;
    @IntRange(from=0L)
    private final long contentLength;
    private final AtomicLong currentOffset;

    public BlockInfo(long startOffset, long contentLength) {
        this(startOffset, contentLength, 0L);
    }

    public BlockInfo(long startOffset, long contentLength, @IntRange(from=0L) long currentOffset) {
        if (startOffset < 0L || contentLength < 0L && contentLength != -1L || currentOffset < 0L) {
            throw new IllegalArgumentException();
        }
        this.startOffset = startOffset;
        this.contentLength = contentLength;
        this.currentOffset = new AtomicLong(currentOffset);
    }

    public long getCurrentOffset() {
        return this.currentOffset.get();
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public long getRangeLeft() {
        return this.startOffset + this.currentOffset.get();
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public long getRangeRight() {
        return this.startOffset + this.contentLength - 1L;
    }

    public void increaseCurrentOffset(@IntRange(from=1L) long increaseLength) {
        this.currentOffset.addAndGet(increaseLength);
    }

    public void resetBlock() {
        this.currentOffset.set(0L);
    }

    public BlockInfo copy() {
        return new BlockInfo(this.startOffset, this.contentLength, this.currentOffset.get());
    }

    public String toString() {
        return "[" + this.startOffset + ", " + this.getRangeRight() + ")-current:" + this.currentOffset;
    }
}

