/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.update.download.core.breakpoint;

import android.util.SparseArray;
import com.taptap.sdk.update.download.DownloadTask;
import com.taptap.sdk.update.download.core.IdentifiedTask;
import com.taptap.sdk.update.download.core.breakpoint.BreakpointInfo;
import com.taptap.sdk.update.download.core.breakpoint.DownloadStore;
import com.taptap.sdk.update.download.core.breakpoint.KeyToIdMap;
import com.taptap.sdk.update.download.core.cause.EndCause;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class BreakpointStoreOnCache
implements DownloadStore {
    private final SparseArray<BreakpointInfo> storedInfos;
    private final HashMap<String, String> responseFilenameMap;
    private final KeyToIdMap keyToIdMap;
    private final SparseArray<IdentifiedTask> unStoredTasks;
    private final List<Integer> sortedOccupiedIds;
    private final List<Integer> fileDirtyList;
    public static final int FIRST_ID = 1;

    public BreakpointStoreOnCache() {
        this((SparseArray<BreakpointInfo>)new SparseArray(), new ArrayList<Integer>(), new HashMap<String, String>());
    }

    BreakpointStoreOnCache(SparseArray<BreakpointInfo> storedInfos, List<Integer> fileDirtyList, HashMap<String, String> responseFilenameMap, SparseArray<IdentifiedTask> unStoredTasks, List<Integer> sortedOccupiedIds, KeyToIdMap keyToIdMap) {
        this.unStoredTasks = unStoredTasks;
        this.fileDirtyList = fileDirtyList;
        this.storedInfos = storedInfos;
        this.responseFilenameMap = responseFilenameMap;
        this.sortedOccupiedIds = sortedOccupiedIds;
        this.keyToIdMap = keyToIdMap;
    }

    public BreakpointStoreOnCache(SparseArray<BreakpointInfo> storedInfos, List<Integer> fileDirtyList, HashMap<String, String> responseFilenameMap) {
        this.unStoredTasks = new SparseArray();
        this.storedInfos = storedInfos;
        this.fileDirtyList = fileDirtyList;
        this.responseFilenameMap = responseFilenameMap;
        this.keyToIdMap = new KeyToIdMap();
        int count = storedInfos.size();
        this.sortedOccupiedIds = new ArrayList<Integer>(count);
        for (int i = 0; i < count; ++i) {
            this.sortedOccupiedIds.add(((BreakpointInfo)storedInfos.valueAt((int)i)).id);
        }
        Collections.sort(this.sortedOccupiedIds);
    }

    @Override
    public BreakpointInfo get(int id2) {
        return (BreakpointInfo)this.storedInfos.get(id2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BreakpointInfo createAndInsert(DownloadTask task) {
        int id2 = task.getId();
        BreakpointInfo newInfo = new BreakpointInfo(id2, task.getUrl(), task.getParentFile(), task.getFilename());
        BreakpointStoreOnCache breakpointStoreOnCache = this;
        synchronized (breakpointStoreOnCache) {
            this.storedInfos.put(id2, (Object)newInfo);
            this.unStoredTasks.remove(id2);
        }
        return newInfo;
    }

    @Override
    public void onTaskStart(int id2) {
    }

    @Override
    public void onSyncToFilesystemSuccess(BreakpointInfo info, int blockIndex, long increaseLength) throws IOException {
        BreakpointInfo onCacheOne = (BreakpointInfo)this.storedInfos.get(info.id);
        if (info != onCacheOne) {
            throw new IOException("Info not on store!");
        }
        onCacheOne.getBlock(blockIndex).increaseCurrentOffset(increaseLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update(BreakpointInfo breakpointInfo) {
        BreakpointInfo onCacheOne;
        String filename = breakpointInfo.getFilename();
        if (breakpointInfo.isTaskOnlyProvidedParentPath() && filename != null) {
            this.responseFilenameMap.put(breakpointInfo.getUrl(), filename);
        }
        if ((onCacheOne = (BreakpointInfo)this.storedInfos.get(breakpointInfo.id)) != null) {
            if (onCacheOne == breakpointInfo) {
                return true;
            }
            BreakpointStoreOnCache breakpointStoreOnCache = this;
            synchronized (breakpointStoreOnCache) {
                this.storedInfos.put(breakpointInfo.id, (Object)breakpointInfo.copy());
            }
            return true;
        }
        return false;
    }

    @Override
    public void onTaskEnd(int id2, EndCause cause, Exception exception) {
        if (cause == EndCause.COMPLETED) {
            this.remove(id2);
        }
    }

    @Override
    public BreakpointInfo getAfterCompleted(int id2) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean markFileDirty(int id2) {
        if (!this.fileDirtyList.contains(id2)) {
            List<Integer> list = this.fileDirtyList;
            synchronized (list) {
                if (!this.fileDirtyList.contains(id2)) {
                    this.fileDirtyList.add(id2);
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean markFileClear(int id2) {
        List<Integer> list = this.fileDirtyList;
        synchronized (list) {
            return this.fileDirtyList.remove((Object)id2);
        }
    }

    @Override
    public synchronized void remove(int id2) {
        this.storedInfos.remove(id2);
        if (this.unStoredTasks.get(id2) == null) {
            this.sortedOccupiedIds.remove((Object)id2);
        }
        this.keyToIdMap.remove(id2);
    }

    @Override
    public synchronized int findOrCreateId(DownloadTask task) {
        Integer candidate = this.keyToIdMap.get(task);
        if (candidate != null) {
            return candidate;
        }
        int size = this.storedInfos.size();
        for (int i = 0; i < size; ++i) {
            BreakpointInfo info = (BreakpointInfo)this.storedInfos.valueAt(i);
            if (info == null || !info.isSameFrom(task)) continue;
            return info.id;
        }
        int unStoredSize = this.unStoredTasks.size();
        for (int i = 0; i < unStoredSize; ++i) {
            IdentifiedTask another = (IdentifiedTask)this.unStoredTasks.valueAt(i);
            if (another == null || !another.compareIgnoreId(task)) continue;
            return another.getId();
        }
        int id2 = this.allocateId();
        this.unStoredTasks.put(id2, (Object)task.mock(id2));
        this.keyToIdMap.add(task, id2);
        return id2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BreakpointInfo findAnotherInfoFromCompare(DownloadTask task, BreakpointInfo ignored) {
        SparseArray clonedMap;
        BreakpointStoreOnCache breakpointStoreOnCache = this;
        synchronized (breakpointStoreOnCache) {
            clonedMap = this.storedInfos.clone();
        }
        int size = clonedMap.size();
        for (int i = 0; i < size; ++i) {
            BreakpointInfo info = (BreakpointInfo)clonedMap.valueAt(i);
            if (info == ignored || !info.isSameFrom(task)) continue;
            return info;
        }
        return null;
    }

    @Override
    public boolean isOnlyMemoryCache() {
        return true;
    }

    @Override
    public boolean isFileDirty(int id2) {
        return this.fileDirtyList.contains(id2);
    }

    @Override
    public String getResponseFilename(String url) {
        return this.responseFilenameMap.get(url);
    }

    synchronized int allocateId() {
        int newId = 0;
        int index = 0;
        int preId = 0;
        for (int i = 0; i < this.sortedOccupiedIds.size(); ++i) {
            Integer curIdObj = this.sortedOccupiedIds.get(i);
            if (curIdObj == null) {
                index = i;
                newId = preId + 1;
                break;
            }
            int curId = curIdObj;
            if (preId == 0) {
                if (curId != 1) {
                    newId = 1;
                    index = 0;
                    break;
                }
                preId = curId;
                continue;
            }
            if (curId != preId + 1) {
                newId = preId + 1;
                index = i;
                break;
            }
            preId = curId;
        }
        if (newId == 0) {
            if (this.sortedOccupiedIds.isEmpty()) {
                newId = 1;
            } else {
                newId = this.sortedOccupiedIds.get(this.sortedOccupiedIds.size() - 1) + 1;
                index = this.sortedOccupiedIds.size();
            }
        }
        this.sortedOccupiedIds.add(index, newId);
        return newId;
    }
}

