/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.update.download.core.breakpoint;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import com.taptap.sdk.update.download.core.Util;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RemitSyncExecutor
implements Handler.Callback {
    private static final String TAG = "RemitSyncExecutor";
    static final int WHAT_SYNC_BUNCH_ID = 0;
    static final int WHAT_REMOVE_FREE_BUNCH_ID = -1;
    static final int WHAT_REMOVE_FREE_ID = -2;
    static final int WHAT_REMOVE_INFO = -3;
    private final Handler handler;
    private final Set<Integer> freeToDBIdList;
    private final RemitAgent agent;

    RemitSyncExecutor(RemitAgent agent) {
        this.agent = agent;
        this.freeToDBIdList = new HashSet<Integer>();
        HandlerThread thread = new HandlerThread("OkDownload RemitHandoverToDB");
        thread.start();
        this.handler = new Handler(thread.getLooper(), (Handler.Callback)this);
    }

    RemitSyncExecutor(RemitAgent agent, Handler handler, Set<Integer> freeToDBIdList) {
        this.agent = agent;
        this.handler = handler;
        this.freeToDBIdList = freeToDBIdList;
    }

    void shutdown() {
        this.handler.getLooper().quit();
    }

    boolean isFreeToDatabase(int id2) {
        return this.freeToDBIdList.contains(id2);
    }

    public void postSyncInfoDelay(int id2, long delayMillis) {
        this.handler.sendEmptyMessageDelayed(id2, delayMillis);
    }

    public void postSync(int id2) {
        this.handler.sendEmptyMessage(id2);
    }

    public void postSync(List<Integer> idList) {
        Message message = this.handler.obtainMessage(0);
        message.obj = idList;
        this.handler.sendMessage(message);
    }

    public void postRemoveInfo(int id2) {
        Message message = this.handler.obtainMessage(-3);
        message.arg1 = id2;
        this.handler.sendMessage(message);
    }

    public void postRemoveFreeIds(List<Integer> idList) {
        Message message = this.handler.obtainMessage(-1);
        message.obj = idList;
        this.handler.sendMessage(message);
    }

    public void postRemoveFreeId(int id2) {
        Message message = this.handler.obtainMessage(-2);
        message.arg1 = id2;
        this.handler.sendMessage(message);
    }

    void removePostWithId(int id2) {
        this.handler.removeMessages(id2);
    }

    void removePostWithIds(int[] ids) {
        for (int id2 : ids) {
            this.handler.removeMessages(id2);
        }
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case -3: {
                int id2 = msg.arg1;
                this.freeToDBIdList.remove(id2);
                this.agent.removeInfo(id2);
                Util.d(TAG, "remove info " + id2);
                break;
            }
            case -1: {
                List idList = (List)msg.obj;
                this.freeToDBIdList.removeAll(idList);
                Util.d(TAG, "remove free bunch ids " + idList);
                break;
            }
            case -2: {
                int id3 = msg.arg1;
                this.freeToDBIdList.remove(id3);
                Util.d(TAG, "remove free bunch id " + id3);
                break;
            }
            case 0: {
                List idList = (List)msg.obj;
                try {
                    this.agent.syncCacheToDB(idList);
                    this.freeToDBIdList.addAll(idList);
                    Util.d(TAG, "sync bunch info with ids: " + idList);
                }
                catch (IOException e) {
                    Util.w(TAG, "sync info to db failed for ids: " + idList);
                }
                break;
            }
            default: {
                int id4 = msg.what;
                try {
                    this.agent.syncCacheToDB(id4);
                    this.freeToDBIdList.add(id4);
                    Util.d(TAG, "sync info with id: " + id4);
                    break;
                }
                catch (IOException e) {
                    Util.w(TAG, "sync cache to db failed for id: " + id4);
                }
            }
        }
        return true;
    }

    static interface RemitAgent {
        public void syncCacheToDB(List<Integer> var1) throws IOException;

        public void syncCacheToDB(int var1) throws IOException;

        public void removeInfo(int var1);
    }
}

