/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.update.download.core.breakpoint;

import com.taptap.sdk.update.download.core.breakpoint.RemitSyncExecutor;

class RemitSyncToDBHelper {
    private final RemitSyncExecutor executor;
    long delayMillis;

    RemitSyncToDBHelper(RemitSyncExecutor.RemitAgent agent) {
        this(new RemitSyncExecutor(agent));
    }

    RemitSyncToDBHelper(RemitSyncExecutor executor) {
        this.executor = executor;
        this.delayMillis = 1500L;
    }

    void shutdown() {
        this.executor.shutdown();
    }

    boolean isNotFreeToDatabase(int id2) {
        return !this.executor.isFreeToDatabase(id2);
    }

    void onTaskStart(int id2) {
        this.executor.removePostWithId(id2);
        this.executor.postSyncInfoDelay(id2, this.delayMillis);
    }

    void endAndEnsureToDB(int id2) {
        this.executor.removePostWithId(id2);
        try {
            if (this.executor.isFreeToDatabase(id2)) {
                return;
            }
            this.executor.postSync(id2);
        }
        finally {
            this.executor.postRemoveFreeId(id2);
        }
    }

    void discard(int id2) {
        this.executor.removePostWithId(id2);
        this.executor.postRemoveInfo(id2);
    }
}

