/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.update.download.core.connection;

import com.taptap.sdk.update.download.IRedirectHandler;
import com.taptap.sdk.update.download.RedirectUtil;
import com.taptap.sdk.update.download.core.Util;
import com.taptap.sdk.update.download.core.connection.DownloadConnection;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;

public class DownloadUrlConnection
implements DownloadConnection,
DownloadConnection.Connected {
    protected URLConnection connection;
    private Configuration configuration;
    private URL url;
    private IRedirectHandler redirectHandler;
    private static final String TAG = "DownloadUrlConnection";

    DownloadUrlConnection(URLConnection connection) {
        this(connection, new RedirectHandler());
    }

    DownloadUrlConnection(URLConnection connection, IRedirectHandler redirectHandler) {
        this.connection = connection;
        this.url = connection.getURL();
        this.redirectHandler = redirectHandler;
    }

    public DownloadUrlConnection(String originUrl, Configuration configuration) throws IOException {
        this(new URL(originUrl), configuration);
    }

    public DownloadUrlConnection(URL url, Configuration configuration) throws IOException {
        this(url, configuration, new RedirectHandler());
    }

    public DownloadUrlConnection(URL url, Configuration configuration, IRedirectHandler redirectHandler) throws IOException {
        this.configuration = configuration;
        this.url = url;
        this.redirectHandler = redirectHandler;
        this.configUrlConnection();
    }

    public DownloadUrlConnection(String originUrl) throws IOException {
        this(originUrl, null);
    }

    void configUrlConnection() throws IOException {
        Util.d(TAG, "config connection for " + this.url);
        this.connection = this.configuration != null && this.configuration.proxy != null ? this.url.openConnection(this.configuration.proxy) : this.url.openConnection();
        if (this.connection instanceof HttpURLConnection) {
            ((HttpURLConnection)this.connection).setInstanceFollowRedirects(false);
        }
        if (this.configuration != null) {
            if (this.configuration.readTimeout != null) {
                this.connection.setReadTimeout(this.configuration.readTimeout);
            }
            if (this.configuration.connectTimeout != null) {
                this.connection.setConnectTimeout(this.configuration.connectTimeout);
            }
        }
    }

    @Override
    public void addHeader(String name, String value) {
        this.connection.addRequestProperty(name, value);
    }

    @Override
    public DownloadConnection.Connected execute() throws IOException {
        Map<String, List<String>> headerProperties = this.getRequestProperties();
        this.connection.connect();
        this.redirectHandler.handleRedirect(this, this, headerProperties);
        return this;
    }

    @Override
    public int getResponseCode() throws IOException {
        if (this.connection instanceof HttpURLConnection) {
            return ((HttpURLConnection)this.connection).getResponseCode();
        }
        return 0;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.connection.getInputStream();
    }

    @Override
    public boolean setRequestMethod(String method) throws ProtocolException {
        if (this.connection instanceof HttpURLConnection) {
            ((HttpURLConnection)this.connection).setRequestMethod(method);
            return true;
        }
        return false;
    }

    @Override
    public Map<String, List<String>> getResponseHeaderFields() {
        return this.connection.getHeaderFields();
    }

    @Override
    public String getResponseHeaderField(String name) {
        return this.connection.getHeaderField(name);
    }

    @Override
    public String getRedirectLocation() {
        return this.redirectHandler.getRedirectLocation();
    }

    @Override
    public void release() {
        try {
            InputStream inputStream = this.connection.getInputStream();
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        return this.connection.getRequestProperties();
    }

    @Override
    public String getRequestProperty(String key) {
        return this.connection.getRequestProperty(key);
    }

    static final class RedirectHandler
    implements IRedirectHandler {
        String redirectLocation;

        RedirectHandler() {
        }

        @Override
        public void handleRedirect(DownloadConnection originalConnection, DownloadConnection.Connected originalConnected, Map<String, List<String>> headerProperties) throws IOException {
            int responseCode = originalConnected.getResponseCode();
            int redirectCount = 0;
            DownloadUrlConnection downloadUrlConnection = (DownloadUrlConnection)originalConnection;
            while (RedirectUtil.isRedirect(responseCode)) {
                downloadUrlConnection.release();
                if (++redirectCount > 10) {
                    throw new ProtocolException("Too many redirect requests: " + redirectCount);
                }
                this.redirectLocation = RedirectUtil.getRedirectedUrl(originalConnected, responseCode);
                downloadUrlConnection.url = new URL(this.redirectLocation);
                downloadUrlConnection.configUrlConnection();
                Util.addRequestHeaderFields(headerProperties, downloadUrlConnection);
                downloadUrlConnection.connection.connect();
                responseCode = downloadUrlConnection.getResponseCode();
            }
        }

        @Override
        public String getRedirectLocation() {
            return this.redirectLocation;
        }
    }

    public static class Configuration {
        private Proxy proxy;
        private Integer readTimeout;
        private Integer connectTimeout;

        public Configuration proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Configuration readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Configuration connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }
    }

    public static class Factory
    implements DownloadConnection.Factory {
        private final Configuration configuration;

        public Factory() {
            this(null);
        }

        public Factory(Configuration configuration) {
            this.configuration = configuration;
        }

        DownloadConnection create(URL url) throws IOException {
            return new DownloadUrlConnection(url, this.configuration);
        }

        @Override
        public DownloadConnection create(String originUrl) throws IOException {
            return new DownloadUrlConnection(originUrl, this.configuration);
        }
    }
}

