/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.update.download.core.download;

import com.taptap.sdk.update.download.DownloadTask;
import com.taptap.sdk.update.download.OkDownload;
import com.taptap.sdk.update.download.core.breakpoint.BreakpointInfo;
import com.taptap.sdk.update.download.core.cause.ResumeFailedCause;
import com.taptap.sdk.update.download.core.download.ConnectTrial;
import com.taptap.sdk.update.download.core.download.DownloadStrategy;
import com.taptap.sdk.update.download.core.exception.FileBusyAfterRunException;
import com.taptap.sdk.update.download.core.exception.ServerCanceledException;
import java.io.IOException;

public class BreakpointRemoteCheck {
    private boolean acceptRange;
    private boolean resumable;
    ResumeFailedCause failedCause;
    private long instanceLength;
    private final DownloadTask task;
    private final BreakpointInfo info;

    public BreakpointRemoteCheck(DownloadTask task, BreakpointInfo info) {
        this.task = task;
        this.info = info;
    }

    public String toString() {
        return "acceptRange[" + this.acceptRange + "] resumable[" + this.resumable + "] failedCause[" + (Object)((Object)this.failedCause) + "] instanceLength[" + this.instanceLength + "] " + super.toString();
    }

    public ResumeFailedCause getCause() {
        return this.failedCause;
    }

    public ResumeFailedCause getCauseOrThrow() {
        if (this.failedCause == null) {
            throw new IllegalStateException("No cause find with resumable: " + this.resumable);
        }
        return this.failedCause;
    }

    public boolean isResumable() {
        return this.resumable;
    }

    public boolean isAcceptRange() {
        return this.acceptRange;
    }

    public long getInstanceLength() {
        return this.instanceLength;
    }

    public void check() throws IOException {
        DownloadStrategy downloadStrategy = OkDownload.with().downloadStrategy();
        ConnectTrial connectTrial = this.createConnectTrial();
        connectTrial.executeTrial();
        boolean isAcceptRange = connectTrial.isAcceptRange();
        boolean isChunked = connectTrial.isChunked();
        long instanceLength = connectTrial.getInstanceLength();
        String responseEtag = connectTrial.getResponseEtag();
        String responseFilename = connectTrial.getResponseFilename();
        int responseCode = connectTrial.getResponseCode();
        downloadStrategy.validFilenameFromResponse(responseFilename, this.task, this.info);
        this.info.setChunked(isChunked);
        this.info.setEtag(responseEtag);
        if (OkDownload.with().downloadDispatcher().isFileConflictAfterRun(this.task)) {
            throw FileBusyAfterRunException.SIGNAL;
        }
        ResumeFailedCause resumeFailedCause = downloadStrategy.getPreconditionFailedCause(responseCode, this.info.getTotalOffset() != 0L, this.info, responseEtag);
        this.resumable = resumeFailedCause == null;
        this.failedCause = resumeFailedCause;
        this.instanceLength = instanceLength;
        this.acceptRange = isAcceptRange;
        if (!this.isTrialSpecialPass(responseCode, instanceLength, this.resumable) && downloadStrategy.isServerCanceled(responseCode, this.info.getTotalOffset() != 0L)) {
            throw new ServerCanceledException(responseCode, this.info.getTotalOffset());
        }
    }

    boolean isTrialSpecialPass(int responseCode, long instanceLength, boolean isResumable) {
        return responseCode == 416 && instanceLength >= 0L && isResumable;
    }

    ConnectTrial createConnectTrial() {
        return new ConnectTrial(this.task, this.info);
    }
}

