/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.update.download.core.download;

import android.support.annotation.IntRange;
import com.taptap.sdk.update.download.DownloadListener;
import com.taptap.sdk.update.download.DownloadTask;
import com.taptap.sdk.update.download.OkDownload;
import com.taptap.sdk.update.download.core.Util;
import com.taptap.sdk.update.download.core.breakpoint.BreakpointInfo;
import com.taptap.sdk.update.download.core.connection.DownloadConnection;
import com.taptap.sdk.update.download.core.exception.DownloadSecurityException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConnectTrial {
    private static final String TAG = "ConnectTrial";
    private final DownloadTask task;
    private final BreakpointInfo info;
    private boolean acceptRange;
    @IntRange(from=-1L)
    private long instanceLength;
    private String responseEtag;
    private String responseFilename;
    private int responseCode;
    private static final Pattern CONTENT_DISPOSITION_QUOTED_PATTERN = Pattern.compile("attachment;\\s*filename\\s*=\\s*\"([^\"]*)\"");
    private static final Pattern CONTENT_DISPOSITION_NON_QUOTED_PATTERN = Pattern.compile("attachment;\\s*filename\\s*=\\s*(.*)");

    public ConnectTrial(DownloadTask task, BreakpointInfo info) {
        this.task = task;
        this.info = info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTrial() throws IOException {
        boolean isNeedTrialHeadMethod;
        OkDownload.with().downloadStrategy().inspectNetworkOnWifi(this.task);
        OkDownload.with().downloadStrategy().inspectNetworkAvailable();
        DownloadConnection connection = OkDownload.with().connectionFactory().create(this.task.getUrl());
        try {
            if (!Util.isEmpty(this.info.getEtag())) {
                connection.addHeader("If-Match", this.info.getEtag());
            }
            connection.addHeader("Range", "bytes=0-0");
            Map<String, List<String>> userHeader = this.task.getHeaderMapFields();
            if (userHeader != null) {
                Util.addUserRequestHeaderField(userHeader, connection);
            }
            DownloadListener listener = OkDownload.with().callbackDispatcher().dispatch();
            Map<String, List<String>> requestProperties = connection.getRequestProperties();
            listener.connectTrialStart(this.task, requestProperties);
            DownloadConnection.Connected connected = connection.execute();
            this.task.setRedirectLocation(connected.getRedirectLocation());
            Util.d(TAG, "task[" + this.task.getId() + "] redirect location: " + this.task.getRedirectLocation());
            this.responseCode = connected.getResponseCode();
            this.acceptRange = ConnectTrial.isAcceptRange(connected);
            this.instanceLength = ConnectTrial.findInstanceLength(connected);
            this.responseEtag = ConnectTrial.findEtag(connected);
            this.responseFilename = ConnectTrial.findFilename(connected);
            Map<String, List<String>> responseHeader = connected.getResponseHeaderFields();
            if (responseHeader == null) {
                responseHeader = new HashMap<String, List<String>>();
            }
            listener.connectTrialEnd(this.task, this.responseCode, responseHeader);
            isNeedTrialHeadMethod = this.isNeedTrialHeadMethodForInstanceLength(this.instanceLength, connected);
        }
        finally {
            connection.release();
        }
        if (isNeedTrialHeadMethod) {
            this.trialHeadMethodForInstanceLength();
        }
    }

    public long getInstanceLength() {
        return this.instanceLength;
    }

    public boolean isAcceptRange() {
        return this.acceptRange;
    }

    public boolean isChunked() {
        return this.instanceLength == -1L;
    }

    public String getResponseEtag() {
        return this.responseEtag;
    }

    public String getResponseFilename() {
        return this.responseFilename;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public boolean isEtagOverdue() {
        return this.info.getEtag() != null && !this.info.getEtag().equals(this.responseEtag);
    }

    private static boolean isAcceptRange(DownloadConnection.Connected connected) throws IOException {
        if (connected.getResponseCode() == 206) {
            return true;
        }
        String acceptRanges = connected.getResponseHeaderField("Accept-Ranges");
        return "bytes".equals(acceptRanges);
    }

    private static String findFilename(DownloadConnection.Connected connected) throws IOException {
        return ConnectTrial.parseContentDisposition(connected.getResponseHeaderField("Content-Disposition"));
    }

    private static String parseContentDisposition(String contentDisposition) throws IOException {
        if (contentDisposition == null) {
            return null;
        }
        try {
            String fileName = null;
            Matcher m = CONTENT_DISPOSITION_QUOTED_PATTERN.matcher(contentDisposition);
            if (m.find()) {
                fileName = m.group(1);
            } else {
                m = CONTENT_DISPOSITION_NON_QUOTED_PATTERN.matcher(contentDisposition);
                if (m.find()) {
                    fileName = m.group(1);
                }
            }
            if (fileName != null && fileName.contains("../")) {
                throw new DownloadSecurityException("The filename [" + fileName + "] from the response is not allowable, because it contains '../', which can raise the directory traversal vulnerability");
            }
            return fileName;
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    private static String findEtag(DownloadConnection.Connected connected) {
        return connected.getResponseHeaderField("Etag");
    }

    private static long findInstanceLength(DownloadConnection.Connected connected) {
        long instanceLength = ConnectTrial.parseContentRangeFoInstanceLength(connected.getResponseHeaderField("Content-Range"));
        if (instanceLength != -1L) {
            return instanceLength;
        }
        boolean isChunked = ConnectTrial.parseTransferEncoding(connected.getResponseHeaderField("Transfer-Encoding"));
        if (!isChunked) {
            Util.w(TAG, "Transfer-Encoding isn't chunked but there is no valid instance length found either!");
        }
        return -1L;
    }

    boolean isNeedTrialHeadMethodForInstanceLength(long oldInstanceLength, DownloadConnection.Connected connected) {
        if (oldInstanceLength != -1L) {
            return false;
        }
        String contentRange = connected.getResponseHeaderField("Content-Range");
        if (contentRange != null && contentRange.length() > 0) {
            return false;
        }
        boolean isChunked = ConnectTrial.parseTransferEncoding(connected.getResponseHeaderField("Transfer-Encoding"));
        if (isChunked) {
            return false;
        }
        String contentLengthField = connected.getResponseHeaderField("Content-Length");
        return contentLengthField != null && contentLengthField.length() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void trialHeadMethodForInstanceLength() throws IOException {
        DownloadConnection connection = OkDownload.with().connectionFactory().create(this.task.getUrl());
        DownloadListener listener = OkDownload.with().callbackDispatcher().dispatch();
        try {
            connection.setRequestMethod("HEAD");
            Map<String, List<String>> userHeader = this.task.getHeaderMapFields();
            if (userHeader != null) {
                Util.addUserRequestHeaderField(userHeader, connection);
            }
            listener.connectTrialStart(this.task, connection.getRequestProperties());
            DownloadConnection.Connected connectedForContentLength = connection.execute();
            listener.connectTrialEnd(this.task, connectedForContentLength.getResponseCode(), connectedForContentLength.getResponseHeaderFields());
            this.instanceLength = Util.parseContentLength(connectedForContentLength.getResponseHeaderField("Content-Length"));
        }
        finally {
            connection.release();
        }
    }

    private static boolean parseTransferEncoding(String transferEncoding) {
        return transferEncoding != null && transferEncoding.equals("chunked");
    }

    private static long parseContentRangeFoInstanceLength(String contentRange) {
        if (contentRange == null) {
            return -1L;
        }
        String[] session = contentRange.split("/");
        if (session.length >= 2) {
            try {
                return Long.parseLong(session[1]);
            }
            catch (NumberFormatException e) {
                Util.w(TAG, "parse instance length failed with " + contentRange);
            }
        }
        return -1L;
    }
}

