/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.update.download.core.file;

import com.taptap.sdk.update.download.core.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;

public class FileLock {
    private static final String TAG = "FileLock";
    private final Map<String, AtomicInteger> fileLockCountMap;
    private final Map<String, Thread> waitThreadForFileLockMap;
    private static final long WAIT_RELEASE_LOCK_NANO = TimeUnit.MILLISECONDS.toNanos(100L);

    FileLock(Map<String, AtomicInteger> fileLockCountMap, Map<String, Thread> waitThreadForFileLockMap) {
        this.fileLockCountMap = fileLockCountMap;
        this.waitThreadForFileLockMap = waitThreadForFileLockMap;
    }

    FileLock() {
        this(new HashMap<String, AtomicInteger>(), new HashMap<String, Thread>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseLock(String path) {
        AtomicInteger lockCount;
        Map<String, AtomicInteger> map = this.fileLockCountMap;
        synchronized (map) {
            lockCount = this.fileLockCountMap.get(path);
        }
        if (lockCount == null) {
            lockCount = new AtomicInteger(0);
            map = this.fileLockCountMap;
            synchronized (map) {
                this.fileLockCountMap.put(path, lockCount);
            }
        }
        Util.d(TAG, "increaseLock increase lock-count to " + lockCount.incrementAndGet() + path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decreaseLock(String path) {
        AtomicInteger lockCount;
        Map<String, AtomicInteger> map = this.fileLockCountMap;
        synchronized (map) {
            lockCount = this.fileLockCountMap.get(path);
        }
        if (lockCount != null && lockCount.decrementAndGet() == 0) {
            Thread lockedThread;
            Util.d(TAG, "decreaseLock decrease lock-count to 0 " + path);
            Map<String, Object> map2 = this.waitThreadForFileLockMap;
            synchronized (map2) {
                lockedThread = this.waitThreadForFileLockMap.get(path);
                if (lockedThread != null) {
                    this.waitThreadForFileLockMap.remove(path);
                }
            }
            if (lockedThread != null) {
                Util.d(TAG, "decreaseLock " + path + " unpark locked thread " + lockCount);
                this.unpark(lockedThread);
            }
            map2 = this.fileLockCountMap;
            synchronized (map2) {
                this.fileLockCountMap.remove(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForRelease(String filePath) {
        AtomicInteger lockCount;
        Map<String, Object> map = this.fileLockCountMap;
        synchronized (map) {
            lockCount = this.fileLockCountMap.get(filePath);
        }
        if (lockCount == null || lockCount.get() <= 0) {
            return;
        }
        map = this.waitThreadForFileLockMap;
        synchronized (map) {
            this.waitThreadForFileLockMap.put(filePath, Thread.currentThread());
        }
        Util.d(TAG, "waitForRelease start " + filePath);
        while (!this.isNotLocked(lockCount)) {
            this.park();
        }
        Util.d(TAG, "waitForRelease finish " + filePath);
    }

    boolean isNotLocked(AtomicInteger lockCount) {
        return lockCount.get() <= 0;
    }

    void park() {
        LockSupport.park(WAIT_RELEASE_LOCK_NANO);
    }

    void unpark(Thread lockedThread) {
        LockSupport.unpark(lockedThread);
    }
}

