/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.update.download.core.interceptor;

import android.support.annotation.IntRange;
import com.taptap.sdk.update.download.OkDownload;
import com.taptap.sdk.update.download.core.Util;
import com.taptap.sdk.update.download.core.breakpoint.BlockInfo;
import com.taptap.sdk.update.download.core.breakpoint.BreakpointInfo;
import com.taptap.sdk.update.download.core.breakpoint.DownloadStore;
import com.taptap.sdk.update.download.core.cause.ResumeFailedCause;
import com.taptap.sdk.update.download.core.connection.DownloadConnection;
import com.taptap.sdk.update.download.core.download.DownloadChain;
import com.taptap.sdk.update.download.core.exception.InterruptException;
import com.taptap.sdk.update.download.core.exception.RetryException;
import com.taptap.sdk.update.download.core.file.MultiPointOutputStream;
import com.taptap.sdk.update.download.core.interceptor.Interceptor;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BreakpointInterceptor
implements Interceptor.Connect,
Interceptor.Fetch {
    private static final String TAG = "BreakpointInterceptor";
    private static final Pattern CONTENT_RANGE_RIGHT_VALUE = Pattern.compile(".*\\d+ *- *(\\d+) */ *\\d+");

    @Override
    public DownloadConnection.Connected interceptConnect(DownloadChain chain) throws IOException {
        DownloadConnection.Connected connected = chain.processConnect();
        BreakpointInfo info = chain.getInfo();
        if (chain.getCache().isInterrupt()) {
            throw InterruptException.SIGNAL;
        }
        if (info.getBlockCount() == 1 && !info.isChunked()) {
            long blockInstanceLength = this.getExactContentLengthRangeFrom0(connected);
            long infoInstanceLength = info.getTotalLength();
            if (blockInstanceLength > 0L && blockInstanceLength != infoInstanceLength) {
                Util.d(TAG, "SingleBlock special check: the response instance-length[" + blockInstanceLength + "] isn't equal to the instance length from trial-connection[" + infoInstanceLength + "]");
                BlockInfo blockInfo = info.getBlock(0);
                boolean isFromBreakpoint = blockInfo.getRangeLeft() != 0L;
                BlockInfo newBlockInfo = new BlockInfo(0L, blockInstanceLength);
                info.resetBlockInfos();
                info.addBlock(newBlockInfo);
                if (isFromBreakpoint) {
                    String msg = "Discard breakpoint because of on this special case, we have to download from beginning";
                    Util.w(TAG, "Discard breakpoint because of on this special case, we have to download from beginning");
                    throw new RetryException("Discard breakpoint because of on this special case, we have to download from beginning");
                }
                OkDownload.with().callbackDispatcher().dispatch().downloadFromBeginning(chain.getTask(), info, ResumeFailedCause.CONTENT_LENGTH_CHANGED);
            }
        }
        DownloadStore store = chain.getDownloadStore();
        try {
            if (!store.update(info)) {
                throw new IOException("Update store failed!");
            }
        }
        catch (Exception e) {
            throw new IOException("Update store failed!", e);
        }
        return connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long interceptFetch(DownloadChain chain) throws IOException {
        long contentLength = chain.getResponseContentLength();
        int blockIndex = chain.getBlockIndex();
        boolean isNotChunked = contentLength != -1L;
        long fetchLength = 0L;
        MultiPointOutputStream outputStream = chain.getOutputStream();
        try {
            long processFetchLength;
            while ((processFetchLength = chain.loopFetch()) != -1L) {
                fetchLength += processFetchLength;
            }
        }
        finally {
            chain.flushNoCallbackIncreaseBytes();
            if (!chain.getCache().isUserCanceled()) {
                outputStream.done(blockIndex);
            }
        }
        if (isNotChunked) {
            outputStream.inspectComplete(blockIndex);
            if (fetchLength != contentLength) {
                throw new IOException("Fetch-length isn't equal to the response content-length, " + fetchLength + "!= " + contentLength);
            }
        }
        return fetchLength;
    }

    @IntRange(from=-1L)
    long getExactContentLengthRangeFrom0(DownloadConnection.Connected connected) {
        String contentLengthField;
        long rightRange;
        String contentRangeField = connected.getResponseHeaderField("Content-Range");
        long contentLength = -1L;
        if (!Util.isEmpty(contentRangeField) && (rightRange = BreakpointInterceptor.getRangeRightFromContentRange(contentRangeField)) > 0L) {
            contentLength = rightRange + 1L;
        }
        if (contentLength < 0L && !Util.isEmpty(contentLengthField = connected.getResponseHeaderField("Content-Length"))) {
            contentLength = Long.parseLong(contentLengthField);
        }
        return contentLength;
    }

    @IntRange(from=-1L)
    static long getRangeRightFromContentRange(String contentRange) {
        Matcher m = CONTENT_RANGE_RIGHT_VALUE.matcher(contentRange);
        if (m.find()) {
            return Long.parseLong(m.group(1));
        }
        return -1L;
    }
}

