/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.update.download.core.listener.assist;

import android.support.annotation.IntRange;
import com.taptap.sdk.update.download.DownloadTask;
import com.taptap.sdk.update.download.core.breakpoint.BreakpointInfo;
import com.taptap.sdk.update.download.core.cause.EndCause;
import com.taptap.sdk.update.download.core.cause.ResumeFailedCause;
import com.taptap.sdk.update.download.core.listener.assist.ListenerAssist;
import com.taptap.sdk.update.download.core.listener.assist.ListenerModelHandler;
import java.util.concurrent.atomic.AtomicLong;

public class Listener1Assist
implements ListenerAssist,
ListenerModelHandler.ModelCreator<Listener1Model> {
    private final ListenerModelHandler<Listener1Model> modelHandler;
    private Listener1Callback callback;

    public Listener1Assist() {
        this.modelHandler = new ListenerModelHandler<Listener1Model>(this);
    }

    Listener1Assist(ListenerModelHandler<Listener1Model> handler) {
        this.modelHandler = handler;
    }

    public void setCallback(Listener1Callback callback) {
        this.callback = callback;
    }

    public void taskStart(DownloadTask task) {
        Listener1Model model = this.modelHandler.addAndGetModel(task, null);
        if (this.callback != null) {
            this.callback.taskStart(task, model);
        }
    }

    public void taskEnd(DownloadTask task, EndCause cause, Exception realCause) {
        Listener1Model model = this.modelHandler.removeOrCreate(task, task.getInfo());
        if (this.callback != null) {
            this.callback.taskEnd(task, cause, realCause, model);
        }
    }

    public void downloadFromBeginning(DownloadTask task, BreakpointInfo info, ResumeFailedCause cause) {
        Listener1Model model = this.modelHandler.getOrRecoverModel(task, info);
        if (model == null) {
            return;
        }
        model.onInfoValid(info);
        if (model.isStarted.booleanValue() && this.callback != null) {
            this.callback.retry(task, cause);
        }
        model.isStarted = true;
        model.isFromResumed = false;
        model.isFirstConnect = true;
    }

    public void downloadFromBreakpoint(DownloadTask task, BreakpointInfo info) {
        Listener1Model model = this.modelHandler.getOrRecoverModel(task, info);
        if (model == null) {
            return;
        }
        model.onInfoValid(info);
        model.isStarted = true;
        model.isFromResumed = true;
        model.isFirstConnect = true;
    }

    public void connectEnd(DownloadTask task) {
        Listener1Model model = this.modelHandler.getOrRecoverModel(task, task.getInfo());
        if (model == null) {
            return;
        }
        if (Boolean.TRUE.equals(model.isFromResumed) && Boolean.TRUE.equals(model.isFirstConnect)) {
            model.isFirstConnect = false;
        }
        if (this.callback != null) {
            this.callback.connected(task, model.blockCount, model.currentOffset.get(), model.totalLength);
        }
    }

    public void fetchProgress(DownloadTask task, long increaseBytes) {
        Listener1Model model = this.modelHandler.getOrRecoverModel(task, task.getInfo());
        if (model == null) {
            return;
        }
        model.currentOffset.addAndGet(increaseBytes);
        if (this.callback != null) {
            this.callback.progress(task, model.currentOffset.get(), model.totalLength);
        }
    }

    @Override
    public boolean isAlwaysRecoverAssistModel() {
        return this.modelHandler.isAlwaysRecoverAssistModel();
    }

    @Override
    public void setAlwaysRecoverAssistModel(boolean isAlwaysRecoverAssistModel) {
        this.modelHandler.setAlwaysRecoverAssistModel(isAlwaysRecoverAssistModel);
    }

    @Override
    public void setAlwaysRecoverAssistModelIfNotSet(boolean isAlwaysRecoverAssistModel) {
        this.modelHandler.setAlwaysRecoverAssistModelIfNotSet(isAlwaysRecoverAssistModel);
    }

    @Override
    public Listener1Model create(int id2) {
        return new Listener1Model(id2);
    }

    public static interface Listener1Callback {
        public void taskStart(DownloadTask var1, Listener1Model var2);

        public void retry(DownloadTask var1, ResumeFailedCause var2);

        public void connected(DownloadTask var1, @IntRange(from=0L) int var2, @IntRange(from=0L) long var3, @IntRange(from=0L) long var5);

        public void progress(DownloadTask var1, @IntRange(from=0L) long var2, @IntRange(from=0L) long var4);

        public void taskEnd(DownloadTask var1, EndCause var2, Exception var3, Listener1Model var4);
    }

    public static class Listener1Model
    implements ListenerModelHandler.ListenerModel {
        final int id;
        Boolean isStarted;
        Boolean isFromResumed;
        volatile Boolean isFirstConnect;
        int blockCount;
        long totalLength;
        final AtomicLong currentOffset = new AtomicLong();

        Listener1Model(int id2) {
            this.id = id2;
        }

        public long getTotalLength() {
            return this.totalLength;
        }

        @Override
        public int getId() {
            return this.id;
        }

        @Override
        public void onInfoValid(BreakpointInfo info) {
            this.blockCount = info.getBlockCount();
            this.totalLength = info.getTotalLength();
            this.currentOffset.set(info.getTotalOffset());
            if (this.isStarted == null) {
                this.isStarted = false;
            }
            if (this.isFromResumed == null) {
                this.isFromResumed = this.currentOffset.get() > 0L;
            }
            if (this.isFirstConnect == null) {
                this.isFirstConnect = true;
            }
        }
    }
}

