/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.update.download.core.listener.assist;

import android.util.SparseArray;
import com.taptap.sdk.update.download.DownloadTask;
import com.taptap.sdk.update.download.SpeedCalculator;
import com.taptap.sdk.update.download.core.breakpoint.BlockInfo;
import com.taptap.sdk.update.download.core.breakpoint.BreakpointInfo;
import com.taptap.sdk.update.download.core.cause.EndCause;
import com.taptap.sdk.update.download.core.listener.assist.Listener4Assist;
import com.taptap.sdk.update.download.core.listener.assist.ListenerModelHandler;

public class Listener4SpeedAssistExtend
implements Listener4Assist.AssistExtend,
ListenerModelHandler.ModelCreator<Listener4SpeedModel> {
    private Listener4SpeedCallback callback;

    public void setCallback(Listener4SpeedCallback callback) {
        this.callback = callback;
    }

    @Override
    public boolean dispatchInfoReady(DownloadTask task, BreakpointInfo info, boolean fromBreakpoint, Listener4Assist.Listener4Model model) {
        if (this.callback != null) {
            this.callback.infoReady(task, info, fromBreakpoint, (Listener4SpeedModel)model);
        }
        return true;
    }

    @Override
    public boolean dispatchFetchProgress(DownloadTask task, int blockIndex, long increaseBytes, Listener4Assist.Listener4Model model) {
        Listener4SpeedModel speedModel = (Listener4SpeedModel)model;
        ((SpeedCalculator)speedModel.blockSpeeds.get(blockIndex)).downloading(increaseBytes);
        speedModel.taskSpeed.downloading(increaseBytes);
        if (this.callback != null) {
            this.callback.progressBlock(task, blockIndex, (Long)model.blockCurrentOffsetMap.get(blockIndex), speedModel.getBlockSpeed(blockIndex));
            this.callback.progress(task, model.currentOffset, speedModel.taskSpeed);
        }
        return true;
    }

    @Override
    public boolean dispatchBlockEnd(DownloadTask task, int blockIndex, Listener4Assist.Listener4Model model) {
        Listener4SpeedModel speedModel = (Listener4SpeedModel)model;
        ((SpeedCalculator)speedModel.blockSpeeds.get(blockIndex)).endTask();
        if (this.callback != null) {
            this.callback.blockEnd(task, blockIndex, model.info.getBlock(blockIndex), speedModel.getBlockSpeed(blockIndex));
        }
        return true;
    }

    @Override
    public boolean dispatchTaskEnd(DownloadTask task, EndCause cause, Exception realCause, Listener4Assist.Listener4Model model) {
        SpeedCalculator speedCalculator;
        Listener4SpeedModel speedModel = (Listener4SpeedModel)model;
        if (speedModel.taskSpeed != null) {
            speedCalculator = speedModel.taskSpeed;
            speedCalculator.endTask();
        } else {
            speedCalculator = new SpeedCalculator();
        }
        if (this.callback != null) {
            this.callback.taskEnd(task, cause, realCause, speedCalculator);
        }
        return true;
    }

    @Override
    public Listener4SpeedModel create(int id2) {
        return new Listener4SpeedModel(id2);
    }

    public static interface Listener4SpeedCallback {
        public void infoReady(DownloadTask var1, BreakpointInfo var2, boolean var3, Listener4SpeedModel var4);

        public void progressBlock(DownloadTask var1, int var2, long var3, SpeedCalculator var5);

        public void progress(DownloadTask var1, long var2, SpeedCalculator var4);

        public void blockEnd(DownloadTask var1, int var2, BlockInfo var3, SpeedCalculator var4);

        public void taskEnd(DownloadTask var1, EndCause var2, Exception var3, SpeedCalculator var4);
    }

    public static class Listener4SpeedModel
    extends Listener4Assist.Listener4Model {
        SpeedCalculator taskSpeed;
        SparseArray<SpeedCalculator> blockSpeeds;

        public SpeedCalculator getTaskSpeed() {
            return this.taskSpeed;
        }

        public SpeedCalculator getBlockSpeed(int blockIndex) {
            return (SpeedCalculator)this.blockSpeeds.get(blockIndex);
        }

        public Listener4SpeedModel(int id2) {
            super(id2);
        }

        @Override
        public void onInfoValid(BreakpointInfo info) {
            super.onInfoValid(info);
            this.taskSpeed = new SpeedCalculator();
            this.blockSpeeds = new SparseArray();
            int blockCount = info.getBlockCount();
            for (int i = 0; i < blockCount; ++i) {
                this.blockSpeeds.put(i, (Object)new SpeedCalculator());
            }
        }
    }
}

