/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.sdk.update.download;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import com.taptap.sdk.kit.internal.TapLogger;
import com.taptap.sdk.kit.internal.utils.PlatformXUA;
import com.taptap.sdk.update.download.DownloadTask;
import com.taptap.sdk.update.download.OkDownload;
import com.taptap.sdk.update.download.SpeedCalculator;
import com.taptap.sdk.update.download.TapUpdateDownloadListener;
import com.taptap.sdk.update.download.TapUpdateDownloadStrategy;
import com.taptap.sdk.update.download.core.breakpoint.BlockInfo;
import com.taptap.sdk.update.download.core.breakpoint.BreakpointInfo;
import com.taptap.sdk.update.download.core.cause.EndCause;
import com.taptap.sdk.update.download.core.file.FileProvider;
import com.taptap.sdk.update.download.core.listener.DownloadListener4WithSpeed;
import com.taptap.sdk.update.download.core.listener.assist.Listener4SpeedAssistExtend;
import com.taptap.sdk.update.internal.UpdateTracker;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u000e\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J,\u0010\u0011\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\u0017\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\bJ\u0010\u0010\u0019\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0006\u0010\u001a\u001a\u00020\nR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/taptap/sdk/update/download/TapUpdateDownloadManager;", "", "()V", "currentDownloadTask", "Lcom/taptap/sdk/update/download/DownloadTask;", "defaultSaveRootPath", "", "prepared", "", "cancelDownload", "", "clearCache", "context", "Landroid/content/Context;", "deleteFiles", "file", "Ljava/io/File;", "download", "url", "fileName", "listener", "Lcom/taptap/sdk/update/download/TapUpdateDownloadListener;", "getDefaultSaveRootPath", "installAPK", "isManualClick", "prepareDownload", "restartTask", "tap-update_release"})
public final class TapUpdateDownloadManager {
    @NotNull
    public static final TapUpdateDownloadManager INSTANCE = new TapUpdateDownloadManager();
    @NotNull
    private static String defaultSaveRootPath = "";
    @Nullable
    private static DownloadTask currentDownloadTask;
    private static boolean prepared;

    private TapUpdateDownloadManager() {
    }

    public final void prepareDownload(@Nullable Context context) {
        if (!prepared) {
            OkDownload.Builder builder = new OkDownload.Builder(context).downloadStrategy(new TapUpdateDownloadStrategy());
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"Builder(context)\n       \u2026UpdateDownloadStrategy())");
            OkDownload.Builder builder2 = builder;
            try {
                OkDownload.setSingletonInstance(builder2.build());
            }
            catch (Exception exception) {
                // empty catch block
            }
            prepared = true;
        }
    }

    public final void download(@NotNull Context context, @Nullable String url, @Nullable String fileName, @Nullable TapUpdateDownloadListener listener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.prepareDownload(context);
        if (currentDownloadTask == null) {
            Map header = new HashMap();
            List values = new ArrayList();
            values.add(PlatformXUA.getTrackUA());
            header.put("XUA", values);
            DownloadTask downloadTask = new DownloadTask.Builder(url, this.getDefaultSaveRootPath(context), fileName).setMinIntervalMillisCallbackProcess(1000).setHeaderMapFields(header).build();
            Intrinsics.checkNotNullExpressionValue((Object)downloadTask, (String)"Builder(\n               \u2026\n                .build()");
            DownloadTask downloadTask2 = downloadTask;
            downloadTask2.setTag(url);
            currentDownloadTask = downloadTask2;
            downloadTask2.enqueue(new DownloadListener4WithSpeed(listener){
                final /* synthetic */ TapUpdateDownloadListener $listener;
                {
                    this.$listener = $listener;
                }

                public void taskStart(@NotNull DownloadTask task) {
                    Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                    TapLogger.logd((String)"TapUpdateLog", (String)(task + " start"));
                }

                public void connectStart(@NotNull DownloadTask task, int blockIndex, @Nullable Map<String, ? extends List<String>> requestHeaderFields) {
                    Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                    TapLogger.logd((String)"TapUpdateLog", (String)(task + " connect start"));
                }

                public void connectEnd(@NotNull DownloadTask task, int blockIndex, int responseCode, @Nullable Map<String, ? extends List<String>> responseHeaderFields) {
                    Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                    TapLogger.logd((String)"TapUpdateLog", (String)(task + " connect end"));
                }

                public void infoReady(@NotNull DownloadTask task, @NotNull BreakpointInfo info, boolean fromBreakpoint, @Nullable Listener4SpeedAssistExtend.Listener4SpeedModel model) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                        TapLogger.logd((String)"TapUpdateLog", (String)(task + " info ready"));
                        TapUpdateDownloadListener tapUpdateDownloadListener = this.$listener;
                        if (tapUpdateDownloadListener == null) break block0;
                        tapUpdateDownloadListener.onDownloadStart(info.getTotalLength());
                    }
                }

                public void progressBlock(@Nullable DownloadTask task, int blockIndex, long currentBlockOffset, @Nullable SpeedCalculator blockSpeed) {
                }

                public void progress(@NotNull DownloadTask task, long currentOffset, @NotNull SpeedCalculator taskSpeed) {
                    block2: {
                        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                        Intrinsics.checkNotNullParameter((Object)taskSpeed, (String)"taskSpeed");
                        TapLogger.logd((String)"TapUpdateLog", (String)(task + " progress " + currentOffset));
                        long fileTotalLength = 0L;
                        if (task.getInfo() != null) {
                            fileTotalLength = task.getInfo().getTotalLength();
                            TapLogger.logd((String)"TapUpdateLog", (String)("APKDownload PROGRESS fileTotalLength = " + fileTotalLength + " currentOffset = " + currentOffset));
                        }
                        if (fileTotalLength == 0L) {
                            return;
                        }
                        TapUpdateDownloadListener tapUpdateDownloadListener = this.$listener;
                        if (tapUpdateDownloadListener == null) break block2;
                        tapUpdateDownloadListener.onDownloadProgress(currentOffset, fileTotalLength, taskSpeed.getBytesPerSecondAndFlush(), (int)(currentOffset * (long)100 / fileTotalLength), taskSpeed.speed());
                    }
                }

                public void blockEnd(@NotNull DownloadTask task, int blockIndex, @Nullable BlockInfo info, @Nullable SpeedCalculator blockSpeed) {
                    Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                    TapLogger.logd((String)"TapUpdateLog", (String)(task + " block end "));
                }

                public void taskEnd(@NotNull DownloadTask task, @NotNull EndCause cause, @Nullable Exception realCause, @Nullable SpeedCalculator taskSpeed) {
                    block1: {
                        block0: {
                            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                            Intrinsics.checkNotNullParameter((Object)((Object)cause), (String)"cause");
                            TapLogger.logd((String)"TapUpdateLog", (String)(task.toString() + " task end " + cause.name()));
                            if (cause != EndCause.COMPLETED) break block0;
                            TapUpdateDownloadListener tapUpdateDownloadListener = this.$listener;
                            if (tapUpdateDownloadListener == null) break block1;
                            tapUpdateDownloadListener.onDownloadSuccess(task.getFile());
                            break block1;
                        }
                        TapUpdateDownloadListener tapUpdateDownloadListener = this.$listener;
                        if (tapUpdateDownloadListener == null) break block1;
                        tapUpdateDownloadListener.onDownloadFailed(cause, realCause);
                    }
                }
            });
        } else {
            this.restartTask();
        }
    }

    public final void restartTask() {
        if (currentDownloadTask != null) {
            OkDownload.with().downloadDispatcher().enqueue(currentDownloadTask);
        }
    }

    public final void cancelDownload() {
        currentDownloadTask = null;
        OkDownload.with().downloadDispatcher().cancelAll();
    }

    public final void installAPK(@NotNull Context context, @NotNull File file, boolean isManualClick) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        UpdateTracker.INSTANCE.trackInstall(isManualClick);
        try {
            TapLogger.logd((String)"TapUpdateLog", (String)("installAPK" + file));
            Intent intent = new Intent("android.intent.action.VIEW");
            Uri uri = null;
            if (Build.VERSION.SDK_INT >= 24) {
                intent.setFlags(0x10000001);
                Uri uri2 = FileProvider.getUriForFile(context, context.getPackageName() + ".com.taptap.sdk.update.internal.fileProvider", file);
                Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"getUriForFile(\n         \u2026   file\n                )");
                uri = uri2;
            } else {
                intent.setFlags(0x10000000);
                Uri uri3 = Uri.fromFile((File)file);
                Intrinsics.checkNotNullExpressionValue((Object)uri3, (String)"fromFile(file)");
                uri = uri3;
            }
            intent.setDataAndType(uri, "application/vnd.android.package-archive");
            context.startActivity(intent);
        }
        catch (Exception e) {
            TapLogger.loge$default((String)"TapUpdateLog", (String)("installAPK failed " + e.getMessage()), null, (int)4, null);
        }
    }

    public final void clearCache(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            File file = new File(this.getDefaultSaveRootPath(context));
            if (file.exists()) {
                TapLogger.logd((String)"TapUpdateLog", (String)("clearCache " + file.getAbsolutePath()));
                boolean result = this.deleteFiles(file);
                TapLogger.logd((String)"TapUpdateLog", (String)("clearCache result " + result));
            }
        }
        catch (Exception e) {
            TapLogger.logd((String)"TapUpdateLog", (String)("clearCache failed" + e));
        }
    }

    private final boolean deleteFiles(File file) {
        if (file == null) {
            return true;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return true;
            }
            for (File f : fileArray) {
                this.deleteFiles(f);
            }
        }
        return file.delete();
    }

    private final String getDefaultSaveRootPath(Context context) {
        if (TextUtils.isEmpty((CharSequence)defaultSaveRootPath)) {
            File targetFile = context.getExternalCacheDir();
            if (targetFile == null) {
                targetFile = context.getExternalFilesDir(null);
            }
            File file = targetFile;
            String string = file != null ? file.getAbsolutePath() : null;
            if (string == null) {
                string = "";
            }
            defaultSaveRootPath = string;
            defaultSaveRootPath = defaultSaveRootPath + File.separator + "taptap" + File.separator + "services" + File.separator + "update";
        }
        return defaultSaveRootPath;
    }
}

